/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph.iterators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.FilteredNodeIterable;
import org.graalvm.compiler.graph.iterators.NodePredicate;
import org.graalvm.compiler.graph.iterators.NodePredicates;

public interface NodeIterable<T extends Node>
extends Iterable<T> {
    default public <F extends T> NodeIterable<F> filter(Class<F> clazz) {
        return new FilteredNodeIterable(this).and(NodePredicates.isA(clazz));
    }

    default public FilteredNodeIterable<T> filter(NodePredicate predicate) {
        return new FilteredNodeIterable(this).and(predicate);
    }

    default public List<T> snapshot() {
        ArrayList list = new ArrayList();
        this.snapshotTo(list);
        return list;
    }

    default public void snapshotTo(Collection<? super T> to) {
        for (Node n : this) {
            to.add(n);
        }
    }

    default public T first() {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            return (T)((Node)iterator.next());
        }
        return null;
    }

    default public int count() {
        int count = 0;
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return count;
    }

    default public boolean isEmpty() {
        return !this.iterator().hasNext();
    }

    default public boolean isNotEmpty() {
        return this.iterator().hasNext();
    }

    default public boolean contains(T node) {
        for (Node next : this) {
            if (next != node) continue;
            return true;
        }
        return false;
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }
}

