/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jdk.vm.ci.common.JVMCIError;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.hotspot.HotSpotVMConfigStore;
import jdk.vm.ci.hotspot.VMField;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.JVMCIVersionCheck;
import org.graalvm.compiler.serviceprovider.GraalServices;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

public class GraalHotSpotVMConfigAccess {
    protected final HotSpotVMConfigAccess access;
    private final Map<String, Long> vmAddresses;
    private final Map<String, Long> vmConstants;
    private final Map<String, VMField> vmFields;
    public static final Set<String> KNOWN_ARCHITECTURES = new HashSet<String>(Arrays.asList("amd64", "aarch64"));
    public static final Set<String> KNOWN_OS_NAMES = new HashSet<String>(Arrays.asList("windows", "linux", "darwin"));
    public final String osName;
    public final String osArch;
    protected static final JVMCIVersionCheck.Version JVMCI_0_55 = new JVMCIVersionCheck.Version2(0, 55);
    protected static final JVMCIVersionCheck.Version JVMCI_21_1_b02 = new JVMCIVersionCheck.Version3(21, 1, 2);
    public static final JVMCIVersionCheck.Version JVMCI_20_3_b04 = new JVMCIVersionCheck.Version3(20, 3, 4);
    protected static final JVMCIVersionCheck.Version JVMCI_20_2_b04 = new JVMCIVersionCheck.Version3(20, 2, 4);
    protected static final JVMCIVersionCheck.Version JVMCI_20_2_b01 = new JVMCIVersionCheck.Version3(20, 2, 1);
    protected static final JVMCIVersionCheck.Version JVMCI_20_1_b01 = new JVMCIVersionCheck.Version3(20, 1, 1);
    protected static final JVMCIVersionCheck.Version JVMCI_20_0_b03 = new JVMCIVersionCheck.Version3(20, 0, 3);
    protected static final JVMCIVersionCheck.Version JVMCI_19_3_b03 = new JVMCIVersionCheck.Version3(19, 3, 3);
    protected static final JVMCIVersionCheck.Version JVMCI_19_3_b04 = new JVMCIVersionCheck.Version3(19, 3, 4);
    protected static final JVMCIVersionCheck.Version JVMCI_19_3_b07 = new JVMCIVersionCheck.Version3(19, 3, 7);
    public static final int JDK = JavaVersionUtil.JAVA_SPEC;
    public static final int JDK_UPDATE = GraalServices.getJavaUpdateVersion();
    public static final boolean IS_OPENJDK = GraalHotSpotVMConfigAccess.getProperty("java.vm.name", "").startsWith("OpenJDK");
    public static final JVMCIVersionCheck.Version JVMCI_VERSION;
    public static final boolean JVMCI;
    public static final boolean JDK_PRERELEASE;
    private final List<String> missing = new ArrayList<String>();
    private final List<String> unexpected = new ArrayList<String>();
    private boolean deferErrors = this instanceof GraalHotSpotVMConfig;

    GraalHotSpotVMConfigAccess(HotSpotVMConfigStore store) {
        String arch;
        String value;
        this.access = new HotSpotVMConfigAccess(store);
        this.vmAddresses = store.getAddresses();
        this.vmConstants = store.getConstants();
        this.vmFields = store.getFields();
        switch (value = GraalHotSpotVMConfigAccess.getProperty("os.name")) {
            case "Linux": {
                value = "linux";
                break;
            }
            case "SunOS": {
                value = "solaris";
                break;
            }
            case "Mac OS X": {
                value = "darwin";
                break;
            }
            default: {
                if (value.startsWith("Windows")) {
                    value = "windows";
                    break;
                }
                throw new JVMCIError("Unexpected OS name: " + value);
            }
        }
        assert (KNOWN_OS_NAMES.contains(value));
        this.osName = value;
        switch (arch = GraalHotSpotVMConfigAccess.getProperty("os.arch")) {
            case "x86_64": {
                arch = "amd64";
            }
        }
        this.osArch = arch;
        assert (KNOWN_ARCHITECTURES.contains(arch)) : arch;
    }

    public HotSpotVMConfigStore getStore() {
        return this.access.getStore();
    }

    protected static String getProperty(String name, String def) {
        String value = (String)Services.getSavedProperties().get(name);
        if (value == null) {
            return def;
        }
        return value;
    }

    protected static String getProperty(String name) {
        return GraalHotSpotVMConfigAccess.getProperty(name, null);
    }

    public static boolean jvmciGE(JVMCIVersionCheck.Version v) {
        return JVMCI && !JVMCI_VERSION.isLessThan(v);
    }

    private boolean isPresent(String name, Map<String, ?> map, boolean expectPresent) {
        if (map.containsKey(name)) {
            if (!expectPresent) {
                this.recordError(name, this.unexpected, String.valueOf(map.get(name)));
            }
            return true;
        }
        if (expectPresent) {
            this.recordError(name, this.missing, null);
        }
        return false;
    }

    private void recordError(String name, List<String> list, String unexpectedValue) {
        if (JDK_PRERELEASE) {
            return;
        }
        String message = name;
        if (this.deferErrors) {
            StackTraceElement[] trace;
            for (StackTraceElement e : trace = new Exception().getStackTrace()) {
                if (e.getClassName().equals(GraalHotSpotVMConfigAccess.class.getName()) || !e.getMethodName().equals("<init>")) continue;
                message = message + " at " + e;
                break;
            }
        }
        if (unexpectedValue != null) {
            message = message + " [value: " + unexpectedValue + "]";
        }
        list.add(message);
        if (!this.deferErrors) {
            this.reportErrors();
        }
    }

    protected void reportErrors() {
        this.deferErrors = false;
        if (!this.missing.isEmpty() || !this.unexpected.isEmpty()) {
            String jvmci = JVMCI_VERSION == null ? "" : " jvmci-" + JVMCI_VERSION;
            String runtime = String.format("JDK %d%s %s-%s (java.home=%s, java.vm.name=%s, java.vm.version=%s)", JDK, jvmci, this.osName, this.osArch, GraalHotSpotVMConfigAccess.getProperty("java.home"), GraalHotSpotVMConfigAccess.getProperty("java.vm.name"), GraalHotSpotVMConfigAccess.getProperty("java.vm.version"));
            ArrayList<String> messages = new ArrayList<String>();
            if (!this.missing.isEmpty()) {
                messages.add(String.format("VM config values missing that should be present in %s:%n    %s", runtime, this.missing.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    "))));
            }
            if (!this.unexpected.isEmpty()) {
                messages.add(String.format("VM config values not expected to be present in %s:%n    %s", runtime, this.unexpected.stream().sorted().collect(Collectors.joining(System.lineSeparator() + "    "))));
            }
            GraalHotSpotVMConfigAccess.reportError(String.join((CharSequence)System.lineSeparator(), messages));
        }
    }

    static void reportError(String rawErrorMessage) {
        String value = System.getenv("JVMCI_CONFIG_CHECK");
        Formatter errorMessage = new Formatter().format(rawErrorMessage, new Object[0]);
        String javaHome = GraalHotSpotVMConfigAccess.getProperty("java.home");
        String vmName = GraalHotSpotVMConfigAccess.getProperty("java.vm.name");
        errorMessage.format("%nSet the JVMCI_CONFIG_CHECK environment variable to \"ignore\" to suppress ", new Object[0]);
        errorMessage.format("this error or to \"warn\" to emit a warning and continue execution.%n", new Object[0]);
        errorMessage.format("Currently used Java home directory is %s.%n", javaHome);
        errorMessage.format("Currently used VM configuration is: %s%n", vmName);
        if ("ignore".equals(value)) {
            return;
        }
        if ("warn".equals(value) || JDK_PRERELEASE) {
            System.err.println(errorMessage.toString());
        } else if (!JVMCI && Assertions.assertionsEnabled()) {
            System.err.println(errorMessage.toString());
        } else if (JVMCI) {
            throw new JVMCIError(errorMessage.toString());
        }
    }

    public long getAddress(String name, Long notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmAddresses, expectPresent)) {
            return this.access.getAddress(name, notPresent);
        }
        return notPresent;
    }

    public long getAddress(String name) {
        if (this.isPresent(name, this.vmAddresses, true)) {
            return this.access.getAddress(name, Long.valueOf(0L));
        }
        return 0L;
    }

    public <T> T getConstant(String name, Class<T> type, T notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmConstants, expectPresent)) {
            return (T)this.access.getConstant(name, type, notPresent);
        }
        return notPresent;
    }

    public <T> T getConstant(String name, Class<T> type) {
        if (this.isPresent(name, this.vmConstants, true)) {
            return (T)this.access.getConstant(name, type);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFieldOffset(String name, Class<T> type, String cppType, T notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmFields, expectPresent)) {
            return (T)this.access.getFieldOffset(name, type, cppType, notPresent);
        }
        return notPresent;
    }

    public <T> T getFieldOffset(String name, Class<T> type, String cppType) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldOffset(name, type, cppType);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFieldOffset(String name, Class<T> type) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldOffset(name, type);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public long getFieldAddress(String name, String cppType) {
        if (this.isPresent(name, this.vmFields, true)) {
            return this.access.getFieldAddress(name, cppType);
        }
        return 0L;
    }

    public <T> T getFieldValue(String name, Class<T> type, String cppType, T notPresent, boolean expectPresent) {
        if (this.isPresent(name, this.vmFields, expectPresent)) {
            return (T)this.access.getFieldValue(name, type, cppType, notPresent);
        }
        return notPresent;
    }

    public <T> T getFieldValue(String name, Class<T> type, String cppType) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldValue(name, type, cppType);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFieldValue(String name, Class<T> type) {
        if (this.isPresent(name, this.vmFields, true)) {
            return (T)this.access.getFieldValue(name, type);
        }
        return GraalHotSpotVMConfigAccess.getDefault(type);
    }

    public <T> T getFlag(String name, Class<T> type) {
        try {
            return (T)this.access.getFlag(name, type);
        }
        catch (JVMCIError e) {
            this.recordError(name, this.missing, null);
            return GraalHotSpotVMConfigAccess.getDefault(type);
        }
    }

    public <T> T getFlag(String name, Class<T> type, T notPresent, boolean expectPresent) {
        if (expectPresent) {
            return this.getFlag(name, type);
        }
        if (Assertions.assertionsEnabled()) {
            try {
                Object value = this.access.getFlag(name, type, null);
                this.recordError(name, this.unexpected, String.valueOf(value));
            }
            catch (JVMCIError jVMCIError) {
                // empty catch block
            }
        }
        return (T)this.access.getFlag(name, type, notPresent);
    }

    private static <T> T getDefault(Class<T> type) {
        if (type == Boolean.class) {
            return type.cast(Boolean.FALSE);
        }
        if (type == Byte.class) {
            return type.cast((byte)0);
        }
        if (type == Integer.class) {
            return type.cast(0);
        }
        if (type == Long.class) {
            return type.cast(0L);
        }
        if (type == String.class) {
            return type.cast(null);
        }
        throw new JVMCIError("Unsupported VM config value type: " + type.getName());
    }

    static {
        String vmVersion = GraalHotSpotVMConfigAccess.getProperty("java.vm.version");
        JVMCI_VERSION = JVMCIVersionCheck.Version.parse(vmVersion, Services.getSavedProperties());
        JDK_PRERELEASE = vmVersion.contains("SNAPSHOT") || vmVersion.contains("-dev");
        JVMCI = JVMCI_VERSION != null;
    }
}

