/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicSet;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.CompilationIdentifier;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeSourcePosition;
import org.graalvm.compiler.hotspot.CompilationContext;
import org.graalvm.compiler.hotspot.EncodedSnippets;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotGraalServices;
import org.graalvm.compiler.hotspot.SymbolicSnippetEncoder;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotWordOperationPlugin;
import org.graalvm.compiler.hotspot.word.HotSpotOperation;
import org.graalvm.compiler.nodes.Cancellable;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.spi.SnippetParameterInfo;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.printer.GraalDebugHandlersFactory;
import org.graalvm.compiler.replacements.ReplacementsImpl;

public class HotSpotReplacementsImpl
extends ReplacementsImpl {
    @NativeImageReinitialize
    private EconomicSet<ResolvedJavaMethod> registeredSnippets = EconomicSet.create();
    private boolean snippetRegistrationClosed;
    private static volatile EncodedSnippets encodedSnippets;
    @NativeImageReinitialize
    private static SymbolicSnippetEncoder snippetEncoder;

    public HotSpotReplacementsImpl(HotSpotProviders providers, SnippetReflectionProvider snippetReflection, BytecodeProvider bytecodeProvider, TargetDescription target) {
        super(new GraalDebugHandlersFactory(snippetReflection), providers, snippetReflection, bytecodeProvider, target);
    }

    HotSpotReplacementsImpl(HotSpotReplacementsImpl replacements, HotSpotProviders providers) {
        super(new GraalDebugHandlersFactory(replacements.snippetReflection), providers, replacements.snippetReflection, replacements.getDefaultReplacementBytecodeProvider(), replacements.target);
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void maybeInitializeEncoder(OptionValues options) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            return;
        }
        if (!Services.IS_BUILDING_NATIVE_IMAGE && !GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) return;
        Class<HotSpotReplacementsImpl> clazz = HotSpotReplacementsImpl.class;
        synchronized (HotSpotReplacementsImpl.class) {
            if (snippetEncoder != null) return;
            snippetEncoder = new SymbolicSnippetEncoder(this, options);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public Class<? extends GraphBuilderPlugin> getIntrinsifyingPlugin(ResolvedJavaMethod method) {
        if (!Services.IS_IN_NATIVE_IMAGE && method.getAnnotation(HotSpotOperation.class) != null) {
            return HotSpotWordOperationPlugin.class;
        }
        return super.getIntrinsifyingPlugin(method);
    }

    @Override
    public void registerMethodSubstitution(MethodSubstitutionPlugin plugin) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            snippetEncoder.registerMethodSubstitution(plugin);
        }
    }

    @Override
    public void registerConditionalPlugin(InvocationPlugin plugin) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            snippetEncoder.registerConditionalPlugin(plugin);
        }
    }

    public void checkRegistered(MethodSubstitutionPlugin plugin) {
        snippetEncoder.checkRegistered(plugin);
    }

    @Override
    public StructuredGraph getIntrinsicGraph(ResolvedJavaMethod method, CompilationIdentifier compilationId, DebugContext debug, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable) {
        HotSpotReplacementsImpl replacements;
        InvocationPlugin plugin;
        boolean useEncodedGraphs = GraalOptions.UseEncodedGraphs.getValue(debug.getOptions());
        if ((Services.IS_IN_NATIVE_IMAGE || useEncodedGraphs) && (plugin = (replacements = (HotSpotReplacementsImpl)this.providers.getReplacements()).getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(method)) instanceof MethodSubstitutionPlugin) {
            MethodSubstitutionPlugin msp = (MethodSubstitutionPlugin)plugin;
            if (!Services.IS_IN_NATIVE_IMAGE && useEncodedGraphs) {
                replacements.maybeInitializeEncoder(debug.getOptions());
                replacements.registerMethodSubstitution(msp);
            }
            StructuredGraph methodSubstitution = replacements.getMethodSubstitution(msp, method, IntrinsicContext.CompilationContext.ROOT_COMPILATION, allowAssumptions, cancellable, debug.getOptions());
            methodSubstitution.resetDebug(debug);
            return methodSubstitution;
        }
        return super.getIntrinsicGraph(method, compilationId, debug, allowAssumptions, cancellable);
    }

    @Override
    public StructuredGraph getInlineSubstitution(ResolvedJavaMethod targetMethod, int invokeBci, Invoke.InlineControl inlineControl, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, StructuredGraph.AllowAssumptions allowAssumptions, OptionValues options) {
        InvocationPlugin plugin;
        if (!inlineControl.allowSubstitution()) {
            return null;
        }
        boolean useEncodedGraphs = GraalOptions.UseEncodedGraphs.getValue(options);
        if ((Services.IS_IN_NATIVE_IMAGE || useEncodedGraphs) && (plugin = this.getGraphBuilderPlugins().getInvocationPlugins().lookupInvocation(targetMethod)) instanceof MethodSubstitutionPlugin && (!plugin.inlineOnly() || invokeBci >= 0)) {
            MethodSubstitutionPlugin msPlugin = (MethodSubstitutionPlugin)plugin;
            if (!Services.IS_IN_NATIVE_IMAGE && useEncodedGraphs) {
                this.maybeInitializeEncoder(options);
                this.registerMethodSubstitution(msPlugin);
            }
            StructuredGraph subst = this.getMethodSubstitution(msPlugin, targetMethod, IntrinsicContext.CompilationContext.INLINE_AFTER_PARSING, allowAssumptions, null, options);
            return subst;
        }
        return super.getInlineSubstitution(targetMethod, invokeBci, inlineControl, trackNodeSourcePosition, replaceePosition, allowAssumptions, options);
    }

    @Override
    public void notifyNotInlined(GraphBuilderContext b, ResolvedJavaMethod method, Invoke invoke) {
        if (!Services.IS_IN_NATIVE_IMAGE && b.parsingIntrinsic() && snippetEncoder != null && this.getIntrinsifyingPlugin(method) != null) {
            snippetEncoder.addDelayedInvocationPluginMethod(method);
            return;
        }
        super.notifyNotInlined(b, method, invoke);
    }

    @Override
    public void registerSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object receiver, boolean trackNodeSourcePosition, OptionValues options) {
        assert (method.isStatic() || receiver != null) : "must have a constant type for the receiver";
        if (!Services.IS_IN_NATIVE_IMAGE) {
            assert (!this.snippetRegistrationClosed) : "Cannot register snippet after registration is closed: " + method.format("%H.%n(%p)");
            assert (this.registeredSnippets.add((Object)method)) : "Cannot register snippet twice: " + method.format("%H.%n(%p)");
            if (Services.IS_BUILDING_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
                snippetEncoder.registerSnippet(method, original, receiver, trackNodeSourcePosition, options);
            }
        }
    }

    @Override
    public SnippetParameterInfo getSnippetParameterInfo(ResolvedJavaMethod method) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            return HotSpotReplacementsImpl.getEncodedSnippets().getSnippetParameterInfo(method);
        }
        return super.getSnippetParameterInfo(method);
    }

    @Override
    public boolean isSnippet(ResolvedJavaMethod method) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            return HotSpotReplacementsImpl.getEncodedSnippets().isSnippet(method);
        }
        return super.isSnippet(method);
    }

    @Override
    public void closeSnippetRegistration() {
        this.snippetRegistrationClosed = true;
    }

    public static EncodedSnippets getEncodedSnippets() {
        if (encodedSnippets == null) {
            throw GraalError.shouldNotReachHere("encoded snippets not found");
        }
        return encodedSnippets;
    }

    public static void maybeEncodeSnippets(OptionValues options) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            snippetEncoder.encode(options);
        }
    }

    public void clearSnippetParameterNames() {
        assert (snippetEncoder != null);
        snippetEncoder.clearSnippetParameterNames();
    }

    static void setEncodedSnippets(EncodedSnippets encodedSnippets) {
        HotSpotReplacementsImpl.encodedSnippets = encodedSnippets;
    }

    public boolean encode(OptionValues options) {
        SymbolicSnippetEncoder encoder = snippetEncoder;
        if (encoder != null) {
            return encoder.encode(options);
        }
        return false;
    }

    @Override
    public StructuredGraph getSnippet(ResolvedJavaMethod method, ResolvedJavaMethod original, Object[] args, boolean trackNodeSourcePosition, NodeSourcePosition replaceePosition, OptionValues options) {
        if (Services.IS_IN_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
            HotSpotReplacementsImpl.maybeEncodeSnippets(options);
            try (CompilationContext scope = HotSpotGraalServices.enterGlobalCompilationContext();){
                StructuredGraph graph = HotSpotReplacementsImpl.getEncodedSnippets().getEncodedSnippet(method, original, this, args, StructuredGraph.AllowAssumptions.NO, options);
                if (graph == null) {
                    throw GraalError.shouldNotReachHere("snippet not found: " + method.format("%H.%n(%p)"));
                }
                StructuredGraph structuredGraph = graph;
                return structuredGraph;
            }
        }
        assert (this.registeredSnippets == null || this.registeredSnippets.contains((Object)method)) : "Asking for snippet method that was never registered: " + method.format("%H.%n(%p)");
        return super.getSnippet(method, original, args, trackNodeSourcePosition, replaceePosition, options);
    }

    @Override
    public StructuredGraph getMethodSubstitution(MethodSubstitutionPlugin plugin, ResolvedJavaMethod original, IntrinsicContext.CompilationContext context, StructuredGraph.AllowAssumptions allowAssumptions, Cancellable cancellable, OptionValues options) {
        if (Services.IS_IN_NATIVE_IMAGE || GraalOptions.UseEncodedGraphs.getValue(options).booleanValue()) {
            HotSpotReplacementsImpl.maybeEncodeSnippets(options);
            return HotSpotReplacementsImpl.getEncodedSnippets().getMethodSubstitutionGraph(plugin, original, this, context, allowAssumptions, cancellable, options);
        }
        return null;
    }

    @Override
    public <T> T getInjectedArgument(Class<T> capability) {
        if (capability.equals(GraalHotSpotVMConfig.class)) {
            return (T)this.getProviders().getConfig();
        }
        return super.getInjectedArgument(capability);
    }

    public ResolvedJavaMethod findSnippetMethod(ResolvedJavaMethod thisMethod) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            return snippetEncoder.findSnippetMethod(thisMethod);
        }
        return null;
    }

    public static MetaAccessProvider noticeTypes(MetaAccessProvider metaAccess) {
        if (!Services.IS_IN_NATIVE_IMAGE && snippetEncoder != null) {
            return snippetEncoder.noticeTypes(metaAccess);
        }
        return metaAccess;
    }
}

