/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import jdk.vm.ci.hotspot.HotSpotJVMCICompilerFactory;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilerConfigurationFactory;
import org.graalvm.compiler.hotspot.IsGraalPredicateBase;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
class IsGraalPredicate
extends IsGraalPredicateBase {
    IsGraalPredicate() {
    }

    @Override
    void onCompilerConfigurationFactorySelection(HotSpotJVMCIRuntime runtime, CompilerConfigurationFactory factory) {
        ClassLoader jvmciLoader = this.getClass().getClassLoader();
        if (jvmciLoader != null) {
            runtime.excludeFromJVMCICompilation(new ClassLoader[]{jvmciLoader});
        }
    }

    @Override
    HotSpotJVMCICompilerFactory.CompilationLevelAdjustment getCompilationLevelAdjustment() {
        return HotSpotJVMCICompilerFactory.CompilationLevelAdjustment.None;
    }

    @Override
    boolean apply(Class<?> declaringClass) {
        throw GraalError.shouldNotReachHere();
    }
}

