/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.hotspot.SnippetObjectConstant;
import org.graalvm.compiler.hotspot.SnippetResolvedJavaMethod;

public final class SnippetResolvedJavaType
implements ResolvedJavaType {
    private final Class<?> javaClass;
    private List<SnippetResolvedJavaMethod> methods;
    private SnippetResolvedJavaType arrayOfType;

    public SnippetResolvedJavaType(Class<?> javaClass) {
        this.javaClass = javaClass;
    }

    public void setArrayOfType(SnippetResolvedJavaType arrayOfType) {
        assert (this.arrayOfType == null || this.arrayOfType.equals(arrayOfType));
        this.arrayOfType = arrayOfType;
    }

    synchronized SnippetResolvedJavaMethod add(SnippetResolvedJavaMethod method) {
        int index;
        if (Services.IS_IN_NATIVE_IMAGE) {
            throw new InternalError("immutable");
        }
        if (this.methods == null) {
            this.methods = new ArrayList<SnippetResolvedJavaMethod>(1);
        }
        if ((index = this.methods.indexOf(method)) == -1) {
            this.methods.add(method);
            return method;
        }
        return this.methods.get(index);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnippetResolvedJavaType that = (SnippetResolvedJavaType)o;
        return Objects.equals(this.javaClass, that.javaClass);
    }

    public int hashCode() {
        return Objects.hash(this.javaClass);
    }

    public boolean hasFinalizer() {
        throw new UnsupportedOperationException();
    }

    public Assumptions.AssumptionResult<Boolean> hasFinalizableSubclass() {
        throw new UnsupportedOperationException();
    }

    public int getModifiers() {
        return this.javaClass.getModifiers();
    }

    public boolean isInterface() {
        return this.javaClass.isInterface();
    }

    public boolean isInstanceClass() {
        throw new UnsupportedOperationException();
    }

    public boolean isPrimitive() {
        return this.javaClass.isPrimitive();
    }

    public boolean isEnum() {
        return this.javaClass.isEnum();
    }

    public boolean isInitialized() {
        throw new UnsupportedOperationException();
    }

    public void initialize() {
    }

    public boolean isLinked() {
        throw new UnsupportedOperationException();
    }

    public boolean isAssignableFrom(ResolvedJavaType other) {
        if (other instanceof SnippetResolvedJavaType) {
            return this.javaClass.isAssignableFrom(((SnippetResolvedJavaType)other).javaClass);
        }
        return false;
    }

    public ResolvedJavaType lookupType(UnresolvedJavaType unresolvedJavaType, boolean resolve) {
        throw new NoClassDefFoundError();
    }

    public ResolvedJavaType getHostClass() {
        throw new UnsupportedOperationException();
    }

    public boolean isInstance(JavaConstant obj) {
        if (obj instanceof SnippetObjectConstant) {
            return this.javaClass.isAssignableFrom(((SnippetObjectConstant)obj).object.getClass());
        }
        return false;
    }

    public ResolvedJavaType getSuperclass() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaType[] getInterfaces() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaType getSingleImplementor() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaType findLeastCommonAncestor(ResolvedJavaType otherType) {
        if (this.getClass() != otherType.getClass()) {
            throw new InternalError("mixing type systems: " + this + " " + otherType);
        }
        if (this.equals(otherType)) {
            return this;
        }
        throw new UnsupportedOperationException("LCA: " + this + " " + otherType);
    }

    public Assumptions.AssumptionResult<ResolvedJavaType> findLeafConcreteSubtype() {
        if (this.isLeaf()) {
            return new Assumptions.AssumptionResult((Object)this);
        }
        return null;
    }

    public boolean isJavaLangObject() {
        return false;
    }

    public String getName() {
        return MetaUtil.toInternalName((String)this.javaClass.getName());
    }

    public ResolvedJavaType getComponentType() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaType getArrayClass() {
        assert (this.arrayOfType != null);
        return this.arrayOfType;
    }

    public JavaKind getJavaKind() {
        return JavaKind.Object;
    }

    public ResolvedJavaType resolve(ResolvedJavaType accessingClass) {
        return this;
    }

    public ResolvedJavaMethod resolveMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaMethod resolveConcreteMethod(ResolvedJavaMethod method, ResolvedJavaType callerType) {
        throw new UnsupportedOperationException();
    }

    public Assumptions.AssumptionResult<ResolvedJavaMethod> findUniqueConcreteMethod(ResolvedJavaMethod method) {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaField[] getInstanceFields(boolean includeSuperclasses) {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaField[] getStaticFields() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaField findInstanceFieldWithOffset(long offset, JavaKind expectedKind) {
        throw new UnsupportedOperationException();
    }

    public String getSourceFileName() {
        throw new UnsupportedOperationException();
    }

    public boolean isLocal() {
        throw new UnsupportedOperationException();
    }

    public boolean isMember() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaType getEnclosingType() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaMethod[] getDeclaredConstructors() {
        throw new UnsupportedOperationException();
    }

    public ResolvedJavaMethod[] getDeclaredMethods() {
        if (this.methods == null) {
            return new ResolvedJavaMethod[0];
        }
        return this.methods.toArray(new ResolvedJavaMethod[this.methods.size()]);
    }

    public ResolvedJavaMethod getClassInitializer() {
        throw new UnsupportedOperationException();
    }

    public boolean isCloneableWithAllocation() {
        throw new UnsupportedOperationException();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        throw new UnsupportedOperationException();
    }

    public Annotation[] getAnnotations() {
        throw new UnsupportedOperationException();
    }

    public Annotation[] getDeclaredAnnotations() {
        throw new UnsupportedOperationException();
    }

    public boolean isArray() {
        return this.javaClass.isArray();
    }

    public String toString() {
        return "SnippetResolvedJavaType{javaClass=" + this.javaClass + '}';
    }
}

