/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import jdk.vm.ci.common.NativeImageReinitialize;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.meta.UnresolvedJavaType;

public final class SnippetSignature
implements Signature {
    private final List<String> parameters = new ArrayList<String>();
    private final String returnType;
    private final String originalString;
    @NativeImageReinitialize
    private static EnumMap<JavaKind, ResolvedJavaType> primitiveTypes = null;

    static synchronized void initPrimitiveKindCache(MetaAccessProvider metaAccess) {
        if (primitiveTypes == null) {
            EnumMap<JavaKind, ResolvedJavaType> types = new EnumMap<JavaKind, ResolvedJavaType>(JavaKind.class);
            for (JavaKind kind : JavaKind.values()) {
                if (!kind.isPrimitive()) continue;
                types.put(kind, metaAccess.lookupJavaType(kind.toJavaClass()));
            }
            primitiveTypes = types;
        }
    }

    public SnippetSignature(String signature) {
        if (signature.length() == 0) {
            throw new IllegalArgumentException("Signature cannot be empty");
        }
        this.originalString = signature;
        if (signature.charAt(0) == '(') {
            int nextCur;
            int cur = 1;
            while (cur < signature.length() && signature.charAt(cur) != ')') {
                nextCur = SnippetSignature.parseSignature(signature, cur);
                this.parameters.add(signature.substring(cur, nextCur));
                cur = nextCur;
            }
            nextCur = SnippetSignature.parseSignature(signature, ++cur);
            this.returnType = signature.substring(cur, nextCur);
            if (nextCur != signature.length()) {
                throw new IllegalArgumentException("Extra characters at end of signature: " + signature);
            }
        } else {
            throw new IllegalArgumentException("Signature must start with a '(': " + signature);
        }
    }

    private static int parseSignature(String signature, int start) {
        try {
            char first;
            int cur = start;
            do {
                first = signature.charAt(cur);
                ++cur;
            } while (first == '[');
            switch (first) {
                case 'L': {
                    while (signature.charAt(cur) != ';') {
                        if (signature.charAt(cur) == '.') {
                            throw new IllegalArgumentException("Class name in signature contains '.' at index " + cur + ": " + signature);
                        }
                        ++cur;
                    }
                    ++cur;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid character '" + signature.charAt(cur - 1) + "' at index " + (cur - 1) + " in signature: " + signature);
                }
            }
            return cur;
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new IllegalArgumentException("Truncated signature: " + signature);
        }
    }

    public int getParameterCount(boolean withReceiver) {
        return this.parameters.size() + (withReceiver ? 1 : 0);
    }

    public JavaKind getParameterKind(int index) {
        return JavaKind.fromTypeString((String)this.parameters.get(index));
    }

    private static JavaType getUnresolvedOrPrimitiveType(String name) {
        if (name.length() == 1) {
            JavaKind kind = JavaKind.fromPrimitiveOrVoidTypeChar((char)name.charAt(0));
            return (JavaType)primitiveTypes.get(kind);
        }
        return UnresolvedJavaType.create((String)name);
    }

    public JavaType getParameterType(int index, ResolvedJavaType accessingClass) {
        if (accessingClass == null) {
            return SnippetSignature.getUnresolvedOrPrimitiveType(this.parameters.get(index));
        }
        throw new NoClassDefFoundError("dynamic resolution unsupported: " + this.parameters.get(index));
    }

    public String toMethodDescriptor() {
        return this.originalString;
    }

    public JavaKind getReturnKind() {
        return JavaKind.fromTypeString((String)this.returnType);
    }

    public JavaType getReturnType(ResolvedJavaType accessingClass) {
        if (accessingClass == null) {
            return SnippetSignature.getUnresolvedOrPrimitiveType(this.returnType);
        }
        throw new NoClassDefFoundError("dynamic resolution unsupported: " + this.returnType);
    }

    public String toString() {
        return "SnippetSignature<" + this.originalString + ">";
    }

    public boolean equals(Object obj) {
        if (obj instanceof SnippetSignature) {
            SnippetSignature other = (SnippetSignature)obj;
            if (other.originalString.equals(this.originalString)) {
                assert (other.parameters.equals(this.parameters));
                assert (other.returnType.equals(this.returnType));
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.originalString.hashCode();
    }
}

