/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AArch64HotSpotLoadAddressOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64HotSpotLoadAddressOp> TYPE = LIRInstructionClass.create(AArch64HotSpotLoadAddressOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
    protected AllocatableValue result;
    private final Constant constant;
    private final Object note;

    public AArch64HotSpotLoadAddressOp(AllocatableValue result, Constant constant, Object note) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.constant = constant;
        this.note = note;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        crb.recordInlineDataInCodeWithNote(this.constant, this.note);
        AArch64Kind kind = (AArch64Kind)this.result.getPlatformKind();
        int size = 0;
        switch (kind) {
            case DWORD: {
                size = 32;
                break;
            }
            case QWORD: {
                size = 64;
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("unexpected kind: " + kind);
            }
        }
        if (crb.compilationResult.isImmutablePIC()) {
            Register dst = ValueUtil.asRegister((Value)this.result);
            masm.adrpAdd(dst);
            masm.ldr(size, dst, AArch64Address.createBaseRegisterOnlyAddress(size, dst));
        } else {
            masm.ldr(size, ValueUtil.asRegister((Value)this.result), masm.getPlaceholder(-1));
        }
    }
}

