/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.hotspot.HotSpotConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64HotSpotMove {
    public static void decodeKlassPointer(CompilationResultBuilder crb, AArch64MacroAssembler masm, Register result, Register ptr, CompressEncoding encoding) {
        try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
            Register scratch = sc.getRegister();
            boolean pic = GraalOptions.GeneratePIC.getValue(crb.getOptions());
            if (pic || encoding.hasBase() || encoding.getShift() != 0) {
                if (pic) {
                    masm.adrpAdd(scratch);
                    masm.ldr(64, scratch, AArch64Address.createBaseRegisterOnlyAddress(64, scratch));
                    masm.add(64, result, scratch, ptr, AArch64Assembler.ExtendType.UXTX, encoding.getShift());
                    crb.recordMark(HotSpotMarkId.NARROW_KLASS_BASE_ADDRESS);
                } else {
                    masm.mov(scratch, encoding.getBase());
                    masm.add(64, result, scratch, ptr, AArch64Assembler.ExtendType.UXTX, encoding.getShift());
                }
            }
        }
    }

    public static class UncompressPointer
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<UncompressPointer> TYPE = LIRInstructionClass.create(UncompressPointer.class);
        private final CompressEncoding encoding;
        private final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue baseRegister;

        public UncompressPointer(AllocatableValue result, AllocatableValue input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register inputRegister = ValueUtil.asRegister((Value)this.input);
            Register resultRegister = ValueUtil.asRegister((Value)this.result);
            boolean pic = GraalOptions.GeneratePIC.getValue(crb.getOptions());
            Register base = pic || this.encoding.hasBase() ? ValueUtil.asRegister((Value)this.baseRegister) : null;
            UncompressPointer.emitUncompressCode(masm, inputRegister, resultRegister, base, this.encoding.getShift(), this.nonNull);
        }

        public static void emitUncompressCode(AArch64MacroAssembler masm, Register inputRegister, Register resReg, Register baseReg, int shift, boolean nonNull) {
            if (baseReg == null) {
                if (shift != 0) {
                    masm.lsl(64, resReg, inputRegister, shift);
                } else if (!resReg.equals((Object)inputRegister)) {
                    masm.mov(64, resReg, inputRegister);
                }
                return;
            }
            if (nonNull) {
                masm.add(64, resReg, baseReg, inputRegister, AArch64Assembler.ShiftType.LSL, shift);
            } else {
                Label done = new Label();
                if (!resReg.equals((Object)inputRegister)) {
                    masm.mov(32, resReg, inputRegister);
                }
                masm.cbz(32, resReg, done);
                masm.add(64, resReg, baseReg, resReg, AArch64Assembler.ShiftType.LSL, shift);
                masm.bind(done);
            }
        }
    }

    public static class CompressPointer
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<CompressPointer> TYPE = LIRInstructionClass.create(CompressPointer.class);
        private final CompressEncoding encoding;
        private final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
        protected AllocatableValue baseRegister;

        public CompressPointer(AllocatableValue result, AllocatableValue input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register resultRegister = ValueUtil.asRegister((Value)this.result);
            Register ptr = ValueUtil.asRegister((Value)this.input);
            Register base = ValueUtil.isRegister((Value)this.baseRegister) ? ValueUtil.asRegister((Value)this.baseRegister) : AArch64.zr;
            boolean pic = GraalOptions.GeneratePIC.getValue(crb.getOptions());
            if (!pic && !this.encoding.hasBase()) {
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, ptr, this.encoding.getShift());
                } else {
                    masm.mov(64, resultRegister, ptr);
                }
            } else if (this.nonNull) {
                masm.sub(64, resultRegister, ptr, base);
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            } else {
                masm.compare(64, ptr, 0);
                masm.csel(64, resultRegister, ptr, base, AArch64Assembler.ConditionFlag.NE);
                masm.sub(64, resultRegister, resultRegister, base);
                if (this.encoding.hasShift()) {
                    masm.lsr(64, resultRegister, resultRegister, this.encoding.getShift());
                }
            }
        }
    }

    public static final class BaseMove
    extends AArch64LIRInstruction {
        public static final LIRInstructionClass<BaseMove> TYPE = LIRInstructionClass.create(BaseMove.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;

        public BaseMove(AllocatableValue result) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.result = result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            try (AArch64MacroAssembler.ScratchRegister sc = masm.getScratchRegister();){
                Register scratch = sc.getRegister();
                masm.adrp(scratch);
                masm.add(64, scratch, scratch, 1);
                masm.ldr(64, ValueUtil.asRegister((Value)this.result), AArch64Address.createBaseRegisterOnlyAddress(64, scratch));
                masm.nop();
                crb.recordMark(HotSpotMarkId.NARROW_KLASS_BASE_ADDRESS);
            }
        }
    }

    public static class LoadHotSpotObjectConstantInline
    extends AArch64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<LoadHotSpotObjectConstantInline> TYPE = LIRInstructionClass.create(LoadHotSpotObjectConstantInline.class);
        private HotSpotConstant constant;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        AllocatableValue result;

        public LoadHotSpotObjectConstantInline(HotSpotConstant constant, AllocatableValue result) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.constant = constant;
            this.result = result;
        }

        @Override
        protected void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            crb.recordInlineDataInCode((Constant)this.constant);
            if (this.constant.isCompressed()) {
                masm.movNarrowAddress(ValueUtil.asRegister((Value)this.result), 0L);
            } else {
                masm.movNativeAddress(ValueUtil.asRegister((Value)this.result), 0L);
            }
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public Constant getConstant() {
            return this.constant;
        }
    }
}

