/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotEpilogueBlockEndOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;

@Opcode(value="JUMP_TO_EXCEPTION_HANDLER_IN_CALLER")
final class AMD64HotSpotJumpToExceptionHandlerInCallerOp
extends AMD64HotSpotEpilogueBlockEndOp {
    public static final LIRInstructionClass<AMD64HotSpotJumpToExceptionHandlerInCallerOp> TYPE = LIRInstructionClass.create(AMD64HotSpotJumpToExceptionHandlerInCallerOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue handlerInCallerPc;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue exception;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    AllocatableValue exceptionPc;
    private final Register thread;
    private final int isMethodHandleReturnOffset;

    AMD64HotSpotJumpToExceptionHandlerInCallerOp(AllocatableValue handlerInCallerPc, AllocatableValue exception, AllocatableValue exceptionPc, int isMethodHandleReturnOffset, Register thread) {
        super((LIRInstructionClass<? extends AMD64HotSpotEpilogueBlockEndOp>)TYPE);
        this.handlerInCallerPc = handlerInCallerPc;
        this.exception = exception;
        this.exceptionPc = exceptionPc;
        this.isMethodHandleReturnOffset = isMethodHandleReturnOffset;
        this.thread = thread;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        this.leaveFrameAndRestoreRbp(crb, masm);
        masm.incrementq(AMD64.rsp, 8);
        if (JavaVersionUtil.JAVA_SPEC < 8) {
            AMD64Address dst = new AMD64Address(this.thread, this.isMethodHandleReturnOffset);
            masm.cmpl(dst, 0);
            masm.cmovq(AMD64Assembler.ConditionFlag.NotEqual, AMD64.rsp, AMD64.rbp);
        }
        masm.jmp(ValueUtil.asRegister((Value)this.handlerInCallerPc));
    }
}

