/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.aot;

import jdk.vm.ci.meta.Constant;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.replacements.EncodedSymbolConstant;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.word.Word;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, size=NodeSize.SIZE_IGNORED)
public final class EncodedSymbolNode
extends FloatingNode
implements Canonicalizable {
    public static final NodeClass<EncodedSymbolNode> TYPE = NodeClass.create(EncodedSymbolNode.class);
    @Node.OptionalInput
    protected ValueNode value;

    public EncodedSymbolNode(@Node.InjectedNodeParameter Stamp stamp, ValueNode value) {
        super((NodeClass<? extends FloatingNode>)TYPE, stamp);
        assert (value != null);
        this.value = value;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        Constant constant;
        if (this.value != null && (constant = GraphUtil.foldIfConstantAndRemove(this, this.value)) != null) {
            return new ConstantNode((Constant)new EncodedSymbolConstant(constant), StampFactory.pointer());
        }
        return this;
    }

    @Node.NodeIntrinsic
    public static native Word encode(Object var0);
}

