/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.aot;

import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.DeoptimizingNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_UNKNOWN, size=NodeSize.SIZE_16)
public class InitializeKlassStubCall
extends AbstractMemoryCheckpoint
implements LIRLowerable,
Canonicalizable,
DeoptimizingNode.DeoptBefore,
SingleMemoryKill {
    public static final NodeClass<InitializeKlassStubCall> TYPE = NodeClass.create(InitializeKlassStubCall.class);
    @Node.OptionalInput
    protected ValueNode value;
    @Node.Input
    protected ValueNode string;
    @Node.OptionalInput(value=InputType.State)
    protected FrameState stateBefore;
    protected Constant constant;

    protected InitializeKlassStubCall(ValueNode value, ValueNode string) {
        super((NodeClass<? extends AbstractMemoryCheckpoint>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.string = string;
    }

    @Node.NodeIntrinsic
    public static native KlassPointer initializeKlass(KlassPointer var0, Word var1);

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.value != null) {
            this.constant = GraphUtil.foldIfConstantAndRemove(this, this.value);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.constant != null) : "Expected the value to fold: " + this.value;
        Value stringValue = gen.operand(this.string);
        LIRFrameState fs = gen.state(this);
        assert (fs != null) : "Frame state should be set";
        assert (this.constant instanceof HotSpotMetaspaceConstant);
        Value result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitKlassInitializationAndRetrieval(this.constant, stringValue, fs);
        gen.setResult(this, result);
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    @Override
    public FrameState stateBefore() {
        return this.stateBefore;
    }

    @Override
    public void setStateBefore(FrameState f) {
        this.updateUsages(this.stateBefore, f);
        this.stateBefore = f;
    }
}

