/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.aot;

import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.hotspot.word.MethodPointer;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_1)
public class LoadConstantIndirectlyFixedNode
extends FixedWithNextNode
implements Canonicalizable,
LIRLowerable {
    public static final NodeClass<LoadConstantIndirectlyFixedNode> TYPE = NodeClass.create(LoadConstantIndirectlyFixedNode.class);
    @Node.OptionalInput
    protected ValueNode value;
    protected Constant constant;
    protected HotSpotConstantLoadAction action;

    public LoadConstantIndirectlyFixedNode(ValueNode value) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.constant = null;
        this.action = HotSpotConstantLoadAction.RESOLVE;
    }

    public LoadConstantIndirectlyFixedNode(ValueNode value, HotSpotConstantLoadAction action) {
        super((NodeClass<? extends FixedWithNextNode>)TYPE, value.stamp(NodeView.DEFAULT));
        this.value = value;
        this.constant = null;
        this.action = action;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.value != null) {
            this.constant = GraphUtil.foldIfConstantAndRemove(this, this.value);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Value result;
        assert (this.constant != null) : "Expected the value to fold: " + this.value;
        if (this.constant instanceof HotSpotObjectConstant) {
            result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitLoadObjectAddress(this.constant);
        } else if (this.constant instanceof HotSpotMetaspaceConstant) {
            result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitLoadMetaspaceAddress(this.constant, this.action);
        } else {
            throw new PermanentBailoutException("Unsupported constant type: " + this.constant);
        }
        gen.setResult(this, result);
    }

    @Node.NodeIntrinsic
    public static native KlassPointer loadKlass(KlassPointer var0, @Node.ConstantNodeParameter HotSpotConstantLoadAction var1);

    @Node.NodeIntrinsic
    public static native KlassPointer loadKlass(KlassPointer var0);

    @Node.NodeIntrinsic
    public static native MethodPointer loadMethod(MethodPointer var0);

    @Node.NodeIntrinsic
    public static native Object loadObject(Object var0);
}

