/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.aot;

import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.PermanentBailoutException;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.meta.HotSpotConstantLoadAction;
import org.graalvm.compiler.hotspot.nodes.type.MethodCountersPointerStamp;
import org.graalvm.compiler.hotspot.word.MethodCountersPointer;
import org.graalvm.compiler.hotspot.word.MethodPointer;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.FloatingNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(cycles=NodeCycles.CYCLES_4, size=NodeSize.SIZE_4)
public class LoadMethodCountersIndirectlyNode
extends FloatingNode
implements Canonicalizable,
LIRLowerable {
    public static final NodeClass<LoadMethodCountersIndirectlyNode> TYPE = NodeClass.create(LoadMethodCountersIndirectlyNode.class);
    @Node.OptionalInput
    protected ValueNode value;
    protected Constant constant;

    public LoadMethodCountersIndirectlyNode(ValueNode value) {
        super((NodeClass<? extends FloatingNode>)TYPE, (Stamp)MethodCountersPointerStamp.methodCounters());
        this.value = value;
        this.constant = null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        if (this.value != null) {
            this.constant = GraphUtil.foldIfConstantAndRemove(this, this.value);
        }
        return this;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        assert (this.constant != null) : "Expected the value to fold: " + this.value;
        if (!(this.constant instanceof HotSpotMetaspaceConstant)) {
            throw new PermanentBailoutException("Unsupported constant type: " + this.constant);
        }
        Value result = ((HotSpotLIRGenerator)gen.getLIRGeneratorTool()).emitLoadMetaspaceAddress(this.constant, HotSpotConstantLoadAction.LOAD_COUNTERS);
        gen.setResult(this, result);
    }

    @Node.NodeIntrinsic
    public static native MethodCountersPointer loadMethodCounters(MethodPointer var0);
}

