/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.profiling;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.DeoptimizingFixedWithNextNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.word.LocationIdentity;

@NodeInfo(cycles=NodeCycles.CYCLES_IGNORED, cyclesRationale="profiling should be ignored", size=NodeSize.SIZE_IGNORED, sizeRationale="profiling should be ignored")
public abstract class ProfileNode
extends DeoptimizingFixedWithNextNode
implements SingleMemoryKill,
Simplifiable,
Lowerable {
    public static final NodeClass<ProfileNode> TYPE = NodeClass.create(ProfileNode.class);
    protected ResolvedJavaMethod method;
    @Node.OptionalInput
    protected ValueNode random;
    protected int probabilityLog;
    protected int step;

    protected ProfileNode(NodeClass<? extends DeoptimizingFixedWithNextNode> c, ResolvedJavaMethod method, int probabilityLog) {
        super(c, StampFactory.forVoid());
        this.method = method;
        this.probabilityLog = probabilityLog;
        this.step = 1;
    }

    public ProfileNode(ResolvedJavaMethod method, int probabilityLog) {
        this(TYPE, method, probabilityLog);
    }

    @Override
    public boolean canDeoptimize() {
        return true;
    }

    public ResolvedJavaMethod getProfiledMethod() {
        return this.method;
    }

    public ValueNode getRandom() {
        return this.random;
    }

    public void setRandom(ValueNode r) {
        this.updateUsages(this.random, r);
        this.random = r;
    }

    public int getStep() {
        return this.step;
    }

    public void setStep(int s) {
        this.step = s;
    }

    public int getProbabilityLog() {
        return this.probabilityLog;
    }

    public static NodeIterable<ProfileNode> getProfileNodes(StructuredGraph graph) {
        return graph.getNodes().filter(ProfileNode.class);
    }

    protected abstract boolean canBeMergedWith(ProfileNode var1);

    @Override
    public void simplify(SimplifierTool tool) {
        for (Node p = this.predecessor(); p != null && !(p instanceof ControlSplitNode) && !(p instanceof AbstractMergeNode); p = p.predecessor()) {
            ProfileNode that;
            if (!(p instanceof ProfileNode) || !this.canBeMergedWith(that = (ProfileNode)p)) continue;
            that.setStep(this.getStep() + that.getStep());
            GraphUtil.removeFixedWithUnusedInputs(this);
            tool.addToWorkList(that);
            break;
        }
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return LocationIdentity.any();
    }

    public static class Options {
        @Option(help={"Control probabilistic profiling on AMD64"}, type=OptionType.Expert)
        public static final OptionKey<Boolean> ProbabilisticProfiling = new OptionKey<Boolean>(true);
    }
}

