/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.lang.reflect.Array;
import org.graalvm.compiler.api.directives.GraalDirectives;
import org.graalvm.compiler.api.replacements.ClassSubstitution;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.replacements.HotSpotReplacementsUtil;
import org.graalvm.compiler.nodes.java.DynamicNewArrayNode;

@ClassSubstitution(value=Array.class)
public class HotSpotArraySubstitutions {
    @MethodSubstitution
    public static Object newInstance(Class<?> componentType, int length) {
        if (componentType == null || HotSpotReplacementsUtil.loadKlassFromObject(componentType, HotSpotReplacementsUtil.arrayKlassOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), HotSpotReplacementsUtil.CLASS_ARRAY_KLASS_LOCATION).isNull()) {
            return HotSpotArraySubstitutions.newInstance(componentType, length);
        }
        return DynamicNewArrayNode.newArray(GraalDirectives.guardingNonNull(componentType), length);
    }
}

