/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.lang.ref.Reference;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotMetaspaceConstant;
import jdk.vm.ci.hotspot.HotSpotResolvedObjectType;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.UnresolvedJavaType;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.hotspot.nodes.GraalHotSpotVMConfigNode;
import org.graalvm.compiler.hotspot.replacements.KlassLayoutHelperNode;
import org.graalvm.compiler.hotspot.word.KlassPointer;
import org.graalvm.compiler.nodes.CanonicalizableLocation;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.ComputeObjectAddressNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.nodes.extended.LoadHubNode;
import org.graalvm.compiler.nodes.extended.LoadHubOrNullNode;
import org.graalvm.compiler.nodes.extended.RawLoadNode;
import org.graalvm.compiler.nodes.extended.StoreHubNode;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.memory.AddressableMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.memory.address.OffsetAddressNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.replacements.ReplacementsUtil;
import org.graalvm.compiler.replacements.nodes.ReadRegisterNode;
import org.graalvm.compiler.replacements.nodes.WriteRegisterNode;
import org.graalvm.compiler.word.Word;
import org.graalvm.word.LocationIdentity;
import org.graalvm.word.WordBase;
import org.graalvm.word.WordFactory;

public class HotSpotReplacementsUtil {
    public static final LocationIdentity EXCEPTION_OOP_LOCATION = NamedLocationIdentity.mutable("ExceptionOop");
    public static final LocationIdentity EXCEPTION_PC_LOCATION = NamedLocationIdentity.mutable("ExceptionPc");
    public static final LocationIdentity TLAB_TOP_LOCATION = NamedLocationIdentity.mutable("TlabTop");
    public static final LocationIdentity TLAB_END_LOCATION = NamedLocationIdentity.mutable("TlabEnd");
    public static final LocationIdentity PENDING_EXCEPTION_LOCATION = NamedLocationIdentity.mutable("PendingException");
    public static final LocationIdentity JAVA_THREAD_THREAD_OBJECT_LOCATION = NamedLocationIdentity.immutable("JavaThread::_threadObj");
    public static final LocationIdentity JAVA_THREAD_OSTHREAD_LOCATION = NamedLocationIdentity.mutable("JavaThread::_osthread");
    public static final LocationIdentity PROTOTYPE_MARK_WORD_LOCATION = NamedLocationIdentity.mutable("PrototypeMarkWord");
    public static final LocationIdentity KLASS_ACCESS_FLAGS_LOCATION = NamedLocationIdentity.immutable("Klass::_access_flags");
    public static final LocationIdentity KLASS_LAYOUT_HELPER_LOCATION = new HotSpotOptimizingLocationIdentity("Klass::_layout_helper"){

        @Override
        public ValueNode canonicalizeRead(ValueNode read, ValueNode object, ValueNode location, CoreProviders tool) {
            ObjectStamp stamp;
            HotSpotResolvedObjectType type;
            ValueNode javaObject = this.findReadHub(object);
            if (javaObject != null && javaObject.stamp(NodeView.DEFAULT) instanceof ObjectStamp && (type = (HotSpotResolvedObjectType)(stamp = (ObjectStamp)javaObject.stamp(NodeView.DEFAULT)).javaType(tool.getMetaAccess())).isArray() && !type.getComponentType().isPrimitive()) {
                int layout = type.layoutHelper();
                return ConstantNode.forInt(layout);
            }
            return read;
        }
    };
    public static final LocationIdentity ARRAY_KLASS_COMPONENT_MIRROR = NamedLocationIdentity.immutable("ArrayKlass::_component_mirror");
    public static final LocationIdentity KLASS_SUPER_KLASS_LOCATION = NamedLocationIdentity.immutable("Klass::_super");
    public static final LocationIdentity MARK_WORD_LOCATION = NamedLocationIdentity.mutable("MarkWord");
    public static final LocationIdentity HUB_WRITE_LOCATION = NamedLocationIdentity.mutable("Hub:write");
    public static final LocationIdentity HUB_LOCATION = new HotSpotOptimizingLocationIdentity("Hub"){

        @Override
        public ValueNode canonicalizeRead(ValueNode read, ValueNode object, ValueNode location, CoreProviders tool) {
            TypeReference constantType = StampTool.typeReferenceOrNull(object);
            if (constantType != null && constantType.isExact()) {
                return ConstantNode.forConstant(read.stamp(NodeView.DEFAULT), tool.getConstantReflection().asObjectHub(constantType.getType()), tool.getMetaAccess());
            }
            return read;
        }
    };
    public static final LocationIdentity COMPRESSED_HUB_LOCATION = new HotSpotOptimizingLocationIdentity("CompressedHub"){

        @Override
        public ValueNode canonicalizeRead(ValueNode read, ValueNode object, ValueNode location, CoreProviders tool) {
            TypeReference constantType = StampTool.typeReferenceOrNull(object);
            if (constantType != null && constantType.isExact()) {
                return ConstantNode.forConstant(read.stamp(NodeView.DEFAULT), ((HotSpotMetaspaceConstant)tool.getConstantReflection().asObjectHub(constantType.getType())).compress(), tool.getMetaAccess());
            }
            return read;
        }
    };
    public static final LocationIdentity KLASS_SUPER_CHECK_OFFSET_LOCATION = NamedLocationIdentity.immutable("Klass::_super_check_offset");
    public static final LocationIdentity SECONDARY_SUPER_CACHE_LOCATION = NamedLocationIdentity.mutable("SecondarySuperCache");
    public static final LocationIdentity SECONDARY_SUPERS_LOCATION = NamedLocationIdentity.immutable("SecondarySupers");
    public static final LocationIdentity DISPLACED_MARK_WORD_LOCATION = NamedLocationIdentity.mutable("DisplacedMarkWord");
    public static final LocationIdentity OBJECT_MONITOR_OWNER_LOCATION = NamedLocationIdentity.mutable("ObjectMonitor::_owner");
    public static final LocationIdentity OBJECT_MONITOR_RECURSION_LOCATION = NamedLocationIdentity.mutable("ObjectMonitor::_recursions");
    public static final LocationIdentity OBJECT_MONITOR_CXQ_LOCATION = NamedLocationIdentity.mutable("ObjectMonitor::_cxq");
    public static final LocationIdentity OBJECT_MONITOR_ENTRY_LIST_LOCATION = NamedLocationIdentity.mutable("ObjectMonitor::_EntryList");
    public static final LocationIdentity OBJECT_MONITOR_SUCC_LOCATION = NamedLocationIdentity.mutable("ObjectMonitor::_succ");
    static final LocationIdentity CLASS_INIT_STATE_LOCATION = NamedLocationIdentity.mutable("ClassInitState");
    static final LocationIdentity CLASS_INIT_THREAD_LOCATION = NamedLocationIdentity.mutable("ClassInitThread");
    public static final LocationIdentity KLASS_MODIFIER_FLAGS_LOCATION = NamedLocationIdentity.immutable("Klass::_modifier_flags");
    public static final LocationIdentity CLASS_KLASS_LOCATION = new HotSpotOptimizingLocationIdentity("Class._klass"){

        @Override
        public ValueNode canonicalizeRead(ValueNode read, ValueNode object, ValueNode location, CoreProviders tool) {
            return 4.foldIndirection(read, object, CLASS_MIRROR_LOCATION);
        }
    };
    public static final LocationIdentity CLASS_ARRAY_KLASS_LOCATION = new HotSpotOptimizingLocationIdentity("Class._array_klass"){

        @Override
        public ValueNode canonicalizeRead(ValueNode read, ValueNode object, ValueNode location, CoreProviders tool) {
            return 5.foldIndirection(read, object, ARRAY_KLASS_COMPONENT_MIRROR);
        }
    };
    public static final LocationIdentity CLASS_MIRROR_LOCATION = NamedLocationIdentity.immutable("Klass::_java_mirror");
    public static final LocationIdentity HOTSPOT_OOP_HANDLE_LOCATION = NamedLocationIdentity.immutable("OopHandle contents");
    public static final LocationIdentity OBJ_ARRAY_KLASS_ELEMENT_KLASS_LOCATION = new HotSpotOptimizingLocationIdentity("ObjArrayKlass::_element_klass"){

        @Override
        public ValueNode canonicalizeRead(ValueNode read, ValueNode object, ValueNode location, CoreProviders tool) {
            ResolvedJavaType element;
            ResolvedJavaType type;
            ValueNode javaObject = this.findReadHub(object);
            if (javaObject != null && (type = StampTool.typeOrNull(javaObject)) != null && type.isArray() && (element = type.getComponentType()) != null && !element.isPrimitive() && !element.getElementalType().isInterface()) {
                Assumptions assumptions = object.graph().getAssumptions();
                Assumptions.AssumptionResult leafType = element.findLeafConcreteSubtype();
                if (leafType != null && leafType.canRecordTo(assumptions)) {
                    leafType.recordTo(assumptions);
                    return ConstantNode.forConstant(read.stamp(NodeView.DEFAULT), tool.getConstantReflection().asObjectHub((ResolvedJavaType)leafType.getResult()), tool.getMetaAccess());
                }
            }
            return read;
        }
    };
    public static final LocationIdentity PRIMARY_SUPERS_LOCATION = NamedLocationIdentity.immutable("PrimarySupers");
    public static final LocationIdentity METASPACE_ARRAY_LENGTH_LOCATION = NamedLocationIdentity.immutable("MetaspaceArrayLength");
    public static final LocationIdentity SECONDARY_SUPERS_ELEMENT_LOCATION = NamedLocationIdentity.immutable("SecondarySupersElement");

    @Fold
    public static ResolvedJavaType methodHolderClass(@Fold.InjectedParameter IntrinsicContext context) {
        return context.getOriginalMethod().getDeclaringClass();
    }

    @Fold
    static ResolvedJavaType getType(@Fold.InjectedParameter IntrinsicContext context, String typeName) {
        try {
            UnresolvedJavaType unresolved = UnresolvedJavaType.create((String)typeName);
            return unresolved.resolve(HotSpotReplacementsUtil.methodHolderClass(context));
        }
        catch (LinkageError e) {
            throw new GraalError(e);
        }
    }

    @Fold
    public static int getFieldOffset(ResolvedJavaType type, String fieldName) {
        return HotSpotReplacementsUtil.getField(type, fieldName).getOffset();
    }

    private static ResolvedJavaField getField(ResolvedJavaType type, String fieldName) {
        for (ResolvedJavaField field : type.getInstanceFields(true)) {
            if (!field.getName().equals(fieldName)) continue;
            return field;
        }
        throw new GraalError("missing field " + fieldName + " in type " + type);
    }

    public static HotSpotJVMCIRuntime runtime() {
        return HotSpotJVMCIRuntime.runtime();
    }

    @Fold
    public static int getHeapWordSize(@Fold.InjectedParameter GraalHotSpotVMConfig injectedVMConfig) {
        return injectedVMConfig.heapWordSize;
    }

    @Fold
    public static int klassLayoutHelperNeutralValue(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.klassLayoutHelperNeutralValue;
    }

    @Fold
    public static boolean useTLAB(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.useTLAB;
    }

    @Fold
    public static boolean useG1GC(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.useG1GC;
    }

    @Fold
    public static int doingUnsafeAccessOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        assert (config.doingUnsafeAccessOffset != Integer.MAX_VALUE);
        return config.doingUnsafeAccessOffset;
    }

    @Fold
    public static int threadExceptionOopOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.threadExceptionOopOffset;
    }

    @Fold
    public static int threadExceptionPcOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.threadExceptionPcOffset;
    }

    @Fold
    public static int threadTlabTopOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.threadTlabTopOffset();
    }

    @Fold
    static int threadTlabEndOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.threadTlabEndOffset();
    }

    @Fold
    static int threadPendingExceptionOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.pendingExceptionOffset;
    }

    public static Object readExceptionOop(Word thread) {
        return thread.readObject(HotSpotReplacementsUtil.threadExceptionOopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), EXCEPTION_OOP_LOCATION);
    }

    public static Word readExceptionPc(Word thread) {
        return (Word)thread.readWord(HotSpotReplacementsUtil.threadExceptionPcOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), EXCEPTION_PC_LOCATION);
    }

    public static void writeExceptionOop(Word thread, Object value) {
        thread.writeObject(HotSpotReplacementsUtil.threadExceptionOopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), value, EXCEPTION_OOP_LOCATION);
    }

    public static void writeExceptionPc(Word thread, Word value) {
        thread.writeWord(HotSpotReplacementsUtil.threadExceptionPcOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)value, EXCEPTION_PC_LOCATION);
    }

    public static Word readTlabTop(Word thread) {
        return (Word)thread.readWord(HotSpotReplacementsUtil.threadTlabTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), TLAB_TOP_LOCATION);
    }

    public static Word readTlabEnd(Word thread) {
        return (Word)thread.readWord(HotSpotReplacementsUtil.threadTlabEndOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), TLAB_END_LOCATION);
    }

    public static void writeTlabTop(Word thread, Word top) {
        thread.writeWord(HotSpotReplacementsUtil.threadTlabTopOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)top, TLAB_TOP_LOCATION);
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"}, justification="foldable method parameters are injected")
    public static Object clearPendingException(Word thread) {
        Object result = thread.readObject(HotSpotReplacementsUtil.threadPendingExceptionOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), PENDING_EXCEPTION_LOCATION);
        thread.writeObject(HotSpotReplacementsUtil.threadPendingExceptionOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), null, PENDING_EXCEPTION_LOCATION);
        return result;
    }

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF_NONVIRTUAL"}, justification="foldable method parameters are injected")
    public static Object getPendingException(Word thread) {
        return thread.readObject(HotSpotReplacementsUtil.threadPendingExceptionOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), PENDING_EXCEPTION_LOCATION);
    }

    @Fold
    public static int threadObjectOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.threadObjectOffset;
    }

    @Fold
    public static int osThreadOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        assert (config.osThreadOffset != Integer.MAX_VALUE);
        return config.osThreadOffset;
    }

    @Fold
    public static int osThreadInterruptedOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        assert (config.osThreadInterruptedOffset != Integer.MAX_VALUE);
        return config.osThreadInterruptedOffset;
    }

    @Fold
    public static JavaKind getWordKind() {
        return HotSpotReplacementsUtil.runtime().getHostJVMCIBackend().getCodeCache().getTarget().wordJavaKind;
    }

    @Fold
    public static int wordSize() {
        return HotSpotReplacementsUtil.runtime().getHostJVMCIBackend().getCodeCache().getTarget().wordSize;
    }

    @Fold
    public static int pageSize(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.vmPageSize;
    }

    @Fold
    public static int prototypeMarkWordOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.prototypeMarkWordOffset;
    }

    @Fold
    public static int klassAccessFlagsOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.klassAccessFlagsOffset;
    }

    @Fold
    public static int jvmAccWrittenFlags(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.jvmAccWrittenFlags;
    }

    @Fold
    public static int jvmAccIsHiddenClass(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.jvmAccIsHiddenClass;
    }

    @Fold
    public static int jvmAccHasFinalizer(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.jvmAccHasFinalizer;
    }

    @Fold
    public static int allocatePrefetchStyle(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.allocatePrefetchStyle;
    }

    @Fold
    public static int allocatePrefetchLines(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.allocatePrefetchLines;
    }

    @Fold
    public static int allocatePrefetchDistance(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.allocatePrefetchDistance;
    }

    @Fold
    public static int allocateInstancePrefetchLines(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.allocateInstancePrefetchLines;
    }

    @Fold
    public static int allocatePrefetchStepSize(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.allocatePrefetchStepSize;
    }

    @Fold
    public static int invocationCounterIncrement(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.invocationCounterIncrement;
    }

    @Fold
    public static int invocationCounterOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.invocationCounterOffset;
    }

    @Fold
    public static int backedgeCounterOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.backedgeCounterOffset;
    }

    @Fold
    public static int invocationCounterShift(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.invocationCounterShift;
    }

    @Fold
    public static int stackBias(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.stackBias;
    }

    @Node.NodeIntrinsic(value=KlassLayoutHelperNode.class)
    public static native int readLayoutHelper(KlassPointer var0);

    public static boolean klassIsArray(KlassPointer klassNonNull) {
        int layoutHelperNeutralValue;
        int layoutHelper = HotSpotReplacementsUtil.readLayoutHelper(klassNonNull);
        return layoutHelper < (layoutHelperNeutralValue = HotSpotReplacementsUtil.klassLayoutHelperNeutralValue(GraalHotSpotVMConfig.INJECTED_VMCONFIG));
    }

    @Fold
    public static int arrayKlassComponentMirrorOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.getFieldOffset("ArrayKlass::_component_mirror", Integer.class, "oop");
    }

    @Fold
    public static int klassSuperKlassOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.klassSuperKlassOffset;
    }

    @Fold
    public static int markOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.markOffset;
    }

    @Fold
    static int hubOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.hubOffset;
    }

    public static void initializeObjectHeader(Word memory, Word markWord, KlassPointer hub) {
        memory.writeWord(HotSpotReplacementsUtil.markOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), (WordBase)markWord, MARK_WORD_LOCATION);
        StoreHubNode.write(memory, hub);
    }

    @Fold
    public static int unlockedMask(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.unlockedMask;
    }

    @Fold
    public static int monitorMask(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.monitorMask;
    }

    @Fold
    public static int objectMonitorOwnerOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.objectMonitorOwner;
    }

    @Fold
    public static int objectMonitorRecursionsOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.objectMonitorRecursions;
    }

    @Fold
    public static int objectMonitorCxqOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.objectMonitorCxq;
    }

    @Fold
    public static int objectMonitorEntryListOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.objectMonitorEntryList;
    }

    @Fold
    public static int objectMonitorSuccOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.objectMonitorSucc;
    }

    @Fold
    public static int biasedLockMaskInPlace(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.biasedLockMaskInPlace;
    }

    @Fold
    public static int epochMaskInPlace(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.epochMaskInPlace;
    }

    @Fold
    public static int biasedLockPattern(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.biasedLockPattern;
    }

    @Fold
    public static int ageMaskInPlace(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.ageMaskInPlace;
    }

    @Fold
    public static int metaspaceArrayLengthOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.metaspaceArrayLengthOffset;
    }

    @Fold
    public static int metaspaceArrayBaseOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.metaspaceArrayBaseOffset;
    }

    @Fold
    public static int arrayLengthOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.arrayOopDescLengthOffset();
    }

    public static Word arrayStart(int[] a) {
        return (Word)WordFactory.unsigned((long)ComputeObjectAddressNode.get(a, ReplacementsUtil.getArrayBaseOffset(GraalHotSpotVMConfig.INJECTED_METAACCESS, JavaKind.Int)));
    }

    @Fold
    public static boolean verifyBeforeOrAfterGC(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.verifyBeforeGC || config.verifyAfterGC;
    }

    @Fold
    public static int objectAlignment(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.objectAlignment;
    }

    @Fold
    public static int instanceHeaderSize(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.useCompressedClassPointers ? 2 * HotSpotReplacementsUtil.wordSize() - 4 : 2 * HotSpotReplacementsUtil.wordSize();
    }

    @Fold
    public static byte dirtyCardValue(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.dirtyCardValue;
    }

    @Fold
    public static byte g1YoungCardValue(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.g1YoungCardValue;
    }

    @Fold
    public static int cardTableShift(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.cardtableShift;
    }

    @Fold
    public static int g1CardQueueIndexOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.g1CardQueueIndexOffset;
    }

    @Fold
    public static int g1CardQueueBufferOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.g1CardQueueBufferOffset;
    }

    @Fold
    public static int g1SATBQueueMarkingOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.g1SATBQueueMarkingOffset;
    }

    @Fold
    public static int g1SATBQueueIndexOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.g1SATBQueueIndexOffset;
    }

    @Fold
    public static int g1SATBQueueBufferOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.g1SATBQueueBufferOffset;
    }

    @Fold
    public static int superCheckOffsetOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.superCheckOffsetOffset;
    }

    @Fold
    public static int secondarySuperCacheOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.secondarySuperCacheOffset;
    }

    @Fold
    public static int secondarySupersOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.secondarySupersOffset;
    }

    @Fold
    public static int lockDisplacedMarkOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.basicLockDisplacedHeaderOffset;
    }

    @Fold
    public static boolean useBiasedLocking(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.useBiasedLocking;
    }

    @Fold
    static int uninitializedIdentityHashCodeValue(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.uninitializedIdentityHashCodeValue;
    }

    @Fold
    static int identityHashCodeShift(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.identityHashCodeShift;
    }

    public static KlassPointer loadHub(Object object) {
        return HotSpotReplacementsUtil.loadHubIntrinsic(object);
    }

    public static Object verifyOop(Object object) {
        if (GraalHotSpotVMConfigNode.verifyOops()) {
            HotSpotReplacementsUtil.verifyOopStub(HotSpotForeignCallsProviderImpl.VERIFY_OOP, object);
        }
        return object;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native Object verifyOopStub(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    public static Word loadWordFromObject(Object object, int offset) {
        ReplacementsUtil.staticAssert(offset != HotSpotReplacementsUtil.hubOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), "Use loadHubIntrinsic instead of loadWordFromObject");
        return HotSpotReplacementsUtil.loadWordFromObjectIntrinsic(object, offset, LocationIdentity.any(), HotSpotReplacementsUtil.getWordKind());
    }

    public static Word loadWordFromObject(Object object, int offset, LocationIdentity identity) {
        ReplacementsUtil.staticAssert(offset != HotSpotReplacementsUtil.hubOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), "Use loadHubIntrinsic instead of loadWordFromObject");
        return HotSpotReplacementsUtil.loadWordFromObjectIntrinsic(object, offset, identity, HotSpotReplacementsUtil.getWordKind());
    }

    public static KlassPointer loadKlassFromObject(Object object, int offset, LocationIdentity identity) {
        ReplacementsUtil.staticAssert(offset != HotSpotReplacementsUtil.hubOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), "Use loadHubIntrinsic instead of loadKlassFromObject");
        return HotSpotReplacementsUtil.loadKlassFromObjectIntrinsic(object, offset, identity, HotSpotReplacementsUtil.getWordKind());
    }

    public static Word registerAsWord(@Node.ConstantNodeParameter Register register) {
        return HotSpotReplacementsUtil.registerAsWord(register, true, false);
    }

    @Node.NodeIntrinsic(value=ReadRegisterNode.class)
    public static native Word registerAsWord(@Node.ConstantNodeParameter Register var0, @Node.ConstantNodeParameter boolean var1, @Node.ConstantNodeParameter boolean var2);

    @Node.NodeIntrinsic(value=WriteRegisterNode.class)
    public static native void writeRegisterAsWord(@Node.ConstantNodeParameter Register var0, Word var1);

    @Node.NodeIntrinsic(value=RawLoadNode.class)
    private static native Word loadWordFromObjectIntrinsic(Object var0, long var1, @Node.ConstantNodeParameter LocationIdentity var3, @Node.ConstantNodeParameter JavaKind var4);

    @Node.NodeIntrinsic(value=RawLoadNode.class)
    private static native KlassPointer loadKlassFromObjectIntrinsic(Object var0, long var1, @Node.ConstantNodeParameter LocationIdentity var3, @Node.ConstantNodeParameter JavaKind var4);

    @Node.NodeIntrinsic(value=LoadHubNode.class)
    public static native KlassPointer loadHubIntrinsic(Object var0);

    @Node.NodeIntrinsic(value=LoadHubOrNullNode.class)
    public static native KlassPointer loadHubOrNullIntrinsic(Object var0);

    @Fold
    static int instanceKlassInitStateOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.instanceKlassInitStateOffset;
    }

    @Fold
    static int instanceKlassInitThreadOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        assert (config.instanceKlassInitThreadOffset != -1);
        return config.instanceKlassInitThreadOffset;
    }

    @Fold
    public static int instanceKlassStateFullyInitialized(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.instanceKlassStateFullyInitialized;
    }

    @Fold
    public static int instanceKlassStateBeingInitialized(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        assert (config.instanceKlassStateBeingInitialized != -1);
        return config.instanceKlassStateBeingInitialized;
    }

    public static boolean isInstanceKlassFullyInitialized(KlassPointer hub) {
        return HotSpotReplacementsUtil.readInstanceKlassInitState(hub) == HotSpotReplacementsUtil.instanceKlassStateFullyInitialized(GraalHotSpotVMConfig.INJECTED_VMCONFIG);
    }

    static byte readInstanceKlassInitState(KlassPointer hub) {
        return hub.readByte(HotSpotReplacementsUtil.instanceKlassInitStateOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), CLASS_INIT_STATE_LOCATION);
    }

    static Word readInstanceKlassInitThread(KlassPointer hub) {
        return hub.readWord(HotSpotReplacementsUtil.instanceKlassInitThreadOffset(GraalHotSpotVMConfig.INJECTED_VMCONFIG), CLASS_INIT_THREAD_LOCATION);
    }

    @Fold
    public static int klassModifierFlagsOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.klassModifierFlagsOffset;
    }

    @Fold
    public static int arrayKlassOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.arrayKlassOffset;
    }

    @Fold
    public static int layoutHelperHeaderSizeShift(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.layoutHelperHeaderSizeShift;
    }

    @Fold
    public static int layoutHelperHeaderSizeMask(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.layoutHelperHeaderSizeMask;
    }

    @Fold
    public static int layoutHelperLog2ElementSizeShift(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.layoutHelperLog2ElementSizeShift;
    }

    @Fold
    public static int layoutHelperLog2ElementSizeMask(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.layoutHelperLog2ElementSizeMask;
    }

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    public static native int identityHashCode(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1);

    @Fold
    public static long gcTotalCollectionsAddress(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.gcTotalCollectionsAddress();
    }

    public static String referentFieldName() {
        return "referent";
    }

    @Fold
    public static long referentOffset(@Fold.InjectedParameter MetaAccessProvider metaAccessProvider) {
        return HotSpotReplacementsUtil.referentField(metaAccessProvider).getOffset();
    }

    @Fold
    public static ResolvedJavaField referentField(@Fold.InjectedParameter MetaAccessProvider metaAccessProvider) {
        return HotSpotReplacementsUtil.getField(HotSpotReplacementsUtil.referenceType(metaAccessProvider), HotSpotReplacementsUtil.referentFieldName());
    }

    @Fold
    public static ResolvedJavaType referenceType(@Fold.InjectedParameter MetaAccessProvider metaAccessProvider) {
        return metaAccessProvider.lookupJavaType(Reference.class);
    }

    @Fold
    public static int arrayClassElementOffset(@Fold.InjectedParameter GraalHotSpotVMConfig config) {
        return config.arrayClassElementOffset;
    }

    static abstract class HotSpotOptimizingLocationIdentity
    extends NamedLocationIdentity
    implements CanonicalizableLocation {
        HotSpotOptimizingLocationIdentity(String name) {
            super(name, true);
        }

        @Override
        public abstract ValueNode canonicalizeRead(ValueNode var1, ValueNode var2, ValueNode var3, CoreProviders var4);

        protected ValueNode findReadHub(ValueNode object) {
            ValueNode base = object;
            if (base instanceof CompressionNode) {
                base = ((CompressionNode)base).getValue();
            }
            if (base instanceof AddressableMemoryAccess) {
                AddressNode address;
                AddressableMemoryAccess access = (AddressableMemoryAccess)((Object)base);
                if ((access.getLocationIdentity().equals(HUB_LOCATION) || access.getLocationIdentity().equals(COMPRESSED_HUB_LOCATION)) && (address = access.getAddress()) instanceof OffsetAddressNode) {
                    OffsetAddressNode offset = (OffsetAddressNode)address;
                    return offset.getBase();
                }
            } else if (base instanceof LoadHubNode) {
                LoadHubNode loadhub = (LoadHubNode)base;
                return loadhub.getValue();
            }
            return null;
        }

        protected static ValueNode foldIndirection(ValueNode read, ValueNode object, LocationIdentity otherLocation) {
            AddressNode address;
            AddressableMemoryAccess access;
            if (object instanceof AddressableMemoryAccess && (access = (AddressableMemoryAccess)((Object)object)).getLocationIdentity().equals(otherLocation) && (address = access.getAddress()) instanceof OffsetAddressNode) {
                OffsetAddressNode offset = (OffsetAddressNode)address;
                assert (offset.getBase().stamp(NodeView.DEFAULT).isCompatible(read.stamp(NodeView.DEFAULT)));
                return offset.getBase();
            }
            return read;
        }
    }
}

