/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;

public final class EdgeMoveOptimizer
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR ir = lirGenRes.getLIR();
        Optimizer optimizer = new Optimizer(ir);
        AbstractBlockBase<?>[] blockList = ir.linearScanOrder();
        for (int i = blockList.length - 1; i >= 1; --i) {
            AbstractBlockBase<?> block = blockList[i];
            if (block.getPredecessorCount() > 1) {
                optimizer.optimizeMovesAtBlockEnd(block);
            }
            if (block.getSuccessorCount() != 2) continue;
            optimizer.optimizeMovesAtBlockBegin(block);
        }
    }

    private static final class Optimizer {
        private final List<List<LIRInstruction>> edgeInstructionSeqences;
        private LIR ir;

        Optimizer(LIR ir) {
            this.ir = ir;
            this.edgeInstructionSeqences = new ArrayList<List<LIRInstruction>>(4);
        }

        private static boolean same(LIRInstruction op1, LIRInstruction op2) {
            assert (op1 != null);
            assert (op2 != null);
            if (StandardOp.ValueMoveOp.isValueMoveOp(op1) && StandardOp.ValueMoveOp.isValueMoveOp(op2)) {
                StandardOp.ValueMoveOp move1 = StandardOp.ValueMoveOp.asValueMoveOp(op1);
                StandardOp.ValueMoveOp move2 = StandardOp.ValueMoveOp.asValueMoveOp(op2);
                if (move1.getInput().equals((Object)move2.getInput()) && move1.getResult().equals((Object)move2.getResult())) {
                    return true;
                }
            } else if (StandardOp.LoadConstantOp.isLoadConstantOp(op1) && StandardOp.LoadConstantOp.isLoadConstantOp(op2)) {
                StandardOp.LoadConstantOp move1 = StandardOp.LoadConstantOp.asLoadConstantOp(op1);
                StandardOp.LoadConstantOp move2 = StandardOp.LoadConstantOp.asLoadConstantOp(op2);
                if (move1.getConstant().equals(move2.getConstant()) && move1.getResult().equals((Object)move2.getResult())) {
                    return true;
                }
            }
            return false;
        }

        private void optimizeMovesAtBlockEnd(AbstractBlockBase<?> block) {
            for (AbstractBlockBase pred : block.getPredecessors()) {
                if (pred != block) continue;
                return;
            }
            this.edgeInstructionSeqences.clear();
            int numPreds = block.getPredecessorCount();
            assert (numPreds > 1) : "do not call otherwise";
            for (AbstractBlockBase pred : block.getPredecessors()) {
                assert (pred != null);
                assert (this.ir.getLIRforBlock(pred) != null);
                ArrayList<LIRInstruction> predInstructions = this.ir.getLIRforBlock(pred);
                if (pred.getSuccessorCount() != 1) {
                    return;
                }
                assert (pred.getSuccessors()[0] == block) : "invalid control flow";
                assert (predInstructions.get(predInstructions.size() - 1) instanceof StandardOp.JumpOp) : "block must end with unconditional jump";
                if (predInstructions.get(predInstructions.size() - 1).hasState()) {
                    return;
                }
                List<LIRInstruction> seq = predInstructions.subList(0, predInstructions.size() - 1);
                this.edgeInstructionSeqences.add(seq);
            }
            List<LIRInstruction> seq;
            block2: while (!(seq = this.edgeInstructionSeqences.get(0)).isEmpty()) {
                int i;
                LIRInstruction op = Optimizer.last(seq);
                for (i = 1; i < numPreds; ++i) {
                    List<LIRInstruction> otherSeq = this.edgeInstructionSeqences.get(i);
                    if (!otherSeq.isEmpty() && Optimizer.same(op, Optimizer.last(otherSeq))) continue;
                    return;
                }
                this.ir.getLIRforBlock(block).add(1, op);
                i = 0;
                while (true) {
                    if (i >= numPreds) continue block2;
                    seq = this.edgeInstructionSeqences.get(i);
                    Optimizer.removeLast(seq);
                    ++i;
                }
                break;
            }
            return;
        }

        private void optimizeMovesAtBlockBegin(AbstractBlockBase<?> block) {
            this.edgeInstructionSeqences.clear();
            int numSux = block.getSuccessorCount();
            ArrayList<LIRInstruction> instructions = this.ir.getLIRforBlock(block);
            assert (numSux == 2) : "method should not be called otherwise";
            LIRInstruction lastInstruction = instructions.get(instructions.size() - 1);
            if (lastInstruction.hasState()) {
                return;
            }
            LIRInstruction branch = lastInstruction;
            if (!(branch instanceof StandardOp.BranchOp) || branch.hasOperands()) {
                return;
            }
            int insertIdx = instructions.size() - 1;
            for (AbstractBlockBase sux : block.getSuccessors()) {
                ArrayList<LIRInstruction> suxInstructions = this.ir.getLIRforBlock(sux);
                assert (suxInstructions.get(0) instanceof StandardOp.LabelOp) : "block must start with label";
                if (sux.getPredecessorCount() != 1) {
                    return;
                }
                assert (sux.getPredecessors()[0] == block) : "invalid control flow";
                List<LIRInstruction> seq = suxInstructions.subList(1, suxInstructions.size());
                this.edgeInstructionSeqences.add(seq);
            }
            List<LIRInstruction> seq;
            block1: while (!(seq = this.edgeInstructionSeqences.get(0)).isEmpty()) {
                int i;
                LIRInstruction op = Optimizer.first(seq);
                for (i = 1; i < numSux; ++i) {
                    List<LIRInstruction> otherSeq = this.edgeInstructionSeqences.get(i);
                    if (!otherSeq.isEmpty() && Optimizer.same(op, Optimizer.first(otherSeq))) continue;
                    return;
                }
                this.ir.getLIRforBlock(block).add(insertIdx, op);
                ++insertIdx;
                i = 0;
                while (true) {
                    if (i >= numSux) continue block1;
                    seq = this.edgeInstructionSeqences.get(i);
                    Optimizer.removeFirst(seq);
                    ++i;
                }
                break;
            }
            return;
        }

        private static LIRInstruction first(List<LIRInstruction> seq) {
            return seq.get(0);
        }

        private static LIRInstruction last(List<LIRInstruction> seq) {
            return seq.get(seq.size() - 1);
        }

        private static void removeFirst(List<LIRInstruction> seq) {
            seq.remove(0);
        }

        private static void removeLast(List<LIRInstruction> seq) {
            seq.remove(seq.size() - 1);
        }
    }
}

