/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public final class AArch64CCall
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64CCall> TYPE = LIRInstructionClass.create(AArch64CCall.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL})
    protected Value result;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
    protected Value[] parameters;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    protected Value functionPtr;

    public AArch64CCall(Value result, Value functionPtr, Value[] parameters) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.result = result;
        this.functionPtr = functionPtr;
        this.parameters = parameters;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        this.directCall(masm);
    }

    private void directCall(AArch64MacroAssembler masm) {
        Register reg = ValueUtil.asRegister((Value)this.functionPtr);
        masm.blr(reg);
        masm.ensureUniquePC();
    }

    @Override
    public boolean destroysCallerSavedRegisters() {
        return true;
    }
}

