/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64Convert {

    public static class ASIMDFloatConvertOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDFloatConvertOp> TYPE = LIRInstructionClass.create(ASIMDFloatConvertOp.class);
        private final FloatConvert op;
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Use
        protected AllocatableValue inputValue;

        public ASIMDFloatConvertOp(FloatConvert op, AllocatableValue resultValue, AllocatableValue inputValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.resultValue = resultValue;
            this.inputValue = inputValue;
        }

        private boolean verifyConversionSizes(AArch64ASIMDAssembler.ElementSize dstESize, AArch64ASIMDAssembler.ElementSize srcESize) {
            switch (this.op) {
                case F2I: 
                case I2F: {
                    assert (srcESize == AArch64ASIMDAssembler.ElementSize.Word && dstESize == AArch64ASIMDAssembler.ElementSize.Word);
                    break;
                }
                case I2D: 
                case F2D: {
                    assert (srcESize == AArch64ASIMDAssembler.ElementSize.Word && dstESize == AArch64ASIMDAssembler.ElementSize.DoubleWord);
                    break;
                }
                case D2I: 
                case D2F: {
                    assert (srcESize == AArch64ASIMDAssembler.ElementSize.DoubleWord && dstESize == AArch64ASIMDAssembler.ElementSize.Word);
                    break;
                }
                case D2L: 
                case L2D: {
                    assert (srcESize == AArch64ASIMDAssembler.ElementSize.DoubleWord && dstESize == AArch64ASIMDAssembler.ElementSize.DoubleWord);
                    break;
                }
            }
            return true;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ASIMDSize size = AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.resultValue.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize dstESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.resultValue.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize srcESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.inputValue.getPlatformKind());
            assert (this.verifyConversionSizes(dstESize, srcESize));
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register input = ValueUtil.asRegister((Value)this.inputValue);
            switch (this.op) {
                case F2I: {
                    masm.neon.fcvtzsVV(size, srcESize, result, input);
                    break;
                }
                case D2L: {
                    masm.neon.fcvtzsVV(size, srcESize, result, input);
                    break;
                }
                case I2F: {
                    masm.neon.scvtfVV(size, srcESize, result, input);
                    break;
                }
                case L2D: {
                    masm.neon.scvtfVV(size, srcESize, result, input);
                    break;
                }
                case D2F: {
                    masm.neon.fcvtnVV(srcESize, result, input);
                    break;
                }
                case F2D: {
                    masm.neon.fcvtlVV(srcESize, result, input);
                    break;
                }
                case I2D: {
                    masm.neon.sxtlVV(srcESize, result, input);
                    masm.neon.scvtfVV(size, AArch64ASIMDAssembler.ElementSize.fromKind(this.resultValue.getPlatformKind()), result, result);
                    break;
                }
                case D2I: {
                    masm.neon.fcvtzsVV(size, srcESize, result, input);
                    masm.neon.xtnVV(dstESize, result, result);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere("Unsupported conversion requested.");
                }
            }
        }
    }

    public static class ASIMDZeroExtendOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDZeroExtendOp> TYPE = LIRInstructionClass.create(ASIMDZeroExtendOp.class);
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Use
        protected AllocatableValue inputValue;

        public ASIMDZeroExtendOp(AllocatableValue resultValue, AllocatableValue inputValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.resultValue = resultValue;
            this.inputValue = inputValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ElementSize finalESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.resultValue.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize currentESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.inputValue.getPlatformKind());
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register input = ValueUtil.asRegister((Value)this.inputValue);
            if (currentESize == finalESize) {
                masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.resultValue.getPlatformKind()), result, input);
            } else {
                do {
                    masm.neon.uxtlVV(currentESize, result, input);
                    currentESize = currentESize.expand();
                    input = result;
                } while (currentESize != finalESize);
            }
        }
    }

    public static class ASIMDSignExtendOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDSignExtendOp> TYPE = LIRInstructionClass.create(ASIMDSignExtendOp.class);
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Use
        protected AllocatableValue inputValue;

        public ASIMDSignExtendOp(AllocatableValue resultValue, AllocatableValue inputValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.resultValue = resultValue;
            this.inputValue = inputValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ElementSize finalESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.resultValue.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize currentESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.inputValue.getPlatformKind());
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register input = ValueUtil.asRegister((Value)this.inputValue);
            if (currentESize == finalESize) {
                masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.resultValue.getPlatformKind()), result, input);
            } else {
                do {
                    masm.neon.sxtlVV(currentESize, result, input);
                    currentESize = currentESize.expand();
                    input = result;
                } while (currentESize != finalESize);
            }
        }
    }

    public static class ASIMDNarrowOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<ASIMDNarrowOp> TYPE = LIRInstructionClass.create(ASIMDNarrowOp.class);
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Use
        protected AllocatableValue inputValue;

        public ASIMDNarrowOp(AllocatableValue resultValue, AllocatableValue inputValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.resultValue = resultValue;
            this.inputValue = inputValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            AArch64ASIMDAssembler.ElementSize finalESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.resultValue.getPlatformKind());
            AArch64ASIMDAssembler.ElementSize currentESize = AArch64ASIMDAssembler.ElementSize.fromKind(this.inputValue.getPlatformKind());
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register input = ValueUtil.asRegister((Value)this.inputValue);
            if (currentESize == finalESize) {
                masm.neon.moveVV(AArch64ASIMDAssembler.ASIMDSize.fromVectorKind(this.resultValue.getPlatformKind()), result, input);
            } else {
                do {
                    currentESize = currentESize.narrow();
                    masm.neon.xtnVV(currentESize, result, input);
                    input = result;
                } while (currentESize != finalESize);
            }
        }
    }

    public static final class FloatConvertOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<FloatConvertOp> TYPE = LIRInstructionClass.create(FloatConvertOp.class);
        private final FloatConvert op;
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Use
        protected AllocatableValue inputValue;

        public FloatConvertOp(FloatConvert op, AllocatableValue resultValue, AllocatableValue inputValue) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.op = op;
            this.resultValue = resultValue;
            this.inputValue = inputValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int fromSize = this.inputValue.getPlatformKind().getSizeInBytes() * 8;
            int toSize = this.resultValue.getPlatformKind().getSizeInBytes() * 8;
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register input = ValueUtil.asRegister((Value)this.inputValue);
            switch (this.op) {
                case F2I: 
                case D2I: 
                case F2L: 
                case D2L: {
                    masm.fcvtzs(toSize, fromSize, result, input);
                    break;
                }
                case I2F: 
                case I2D: 
                case L2F: 
                case L2D: {
                    masm.scvtf(toSize, fromSize, result, input);
                    break;
                }
                case D2F: 
                case F2D: {
                    masm.fcvt(fromSize, result, input);
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    public static class SignExtendOp
    extends AArch64LIRInstruction {
        private static final LIRInstructionClass<SignExtendOp> TYPE = LIRInstructionClass.create(SignExtendOp.class);
        @LIRInstruction.Def
        protected AllocatableValue resultValue;
        @LIRInstruction.Use
        protected AllocatableValue inputValue;
        private final int fromBits;
        private final int toBits;

        public SignExtendOp(AllocatableValue resultValue, AllocatableValue inputValue, int fromBits, int toBits) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.resultValue = resultValue;
            this.inputValue = inputValue;
            this.fromBits = fromBits;
            this.toBits = toBits;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            Register result = ValueUtil.asRegister((Value)this.resultValue);
            Register input = ValueUtil.asRegister((Value)this.inputValue);
            masm.sxt(this.toBits <= 32 ? 32 : 64, this.fromBits, result, input);
        }
    }
}

