/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import java.util.Arrays;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.aarch64.AArch64SaveRegistersOp;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="RESTORE_REGISTER")
public class AArch64RestoreRegistersOp
extends AArch64LIRInstruction
implements StandardOp.RestoreRegistersOp {
    public static final LIRInstructionClass<AArch64RestoreRegistersOp> TYPE = LIRInstructionClass.create(AArch64RestoreRegistersOp.class);
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK})
    protected final AllocatableValue[] slots;
    private final AArch64SaveRegistersOp save;

    public AArch64RestoreRegistersOp(AllocatableValue[] values, AArch64SaveRegistersOp save) {
        this(TYPE, values, save);
    }

    protected AArch64RestoreRegistersOp(LIRInstructionClass<? extends AArch64RestoreRegistersOp> c, AllocatableValue[] values, AArch64SaveRegistersOp save) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)c);
        assert (Arrays.asList(values).stream().allMatch(LIRValueUtil::isVirtualStackSlot));
        this.slots = values;
        this.save = save;
    }

    protected Register[] getSavedRegisters() {
        return this.save.getSavedRegisters();
    }

    protected void restoreRegister(CompilationResultBuilder crb, AArch64MacroAssembler masm, Register result, StackSlot input) {
        AArch64Move.stack2reg(crb, masm, (AllocatableValue)result.asValue(), input);
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register[] savedRegisters = this.getSavedRegisters();
        for (int i = 0; i < savedRegisters.length; ++i) {
            if (savedRegisters[i] == null) continue;
            assert (ValueUtil.isStackSlot((Value)this.slots[i])) : "not a StackSlot: " + this.slots[i];
            this.restoreRegister(crb, masm, savedRegisters[i], ValueUtil.asStackSlot((Value)this.slots[i]));
        }
    }
}

