/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

public class AArch64Unary {

    public static class MemoryOp
    extends AArch64LIRInstruction
    implements StandardOp.ImplicitNullCheck {
        public static final LIRInstructionClass<MemoryOp> TYPE = LIRInstructionClass.create(MemoryOp.class);
        private final boolean isSigned;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AArch64AddressValue input;
        @LIRInstruction.State
        protected LIRFrameState state;
        private int targetSize;
        private int srcSize;

        public MemoryOp(boolean isSigned, int targetSize, int srcSize, AllocatableValue result, AArch64AddressValue input, LIRFrameState state) {
            super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
            this.targetSize = targetSize;
            this.srcSize = srcSize;
            this.isSigned = isSigned;
            this.result = result;
            this.input = input;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
            int prePosition = masm.position();
            AArch64Address address = this.input.toAddress();
            Register dst = ValueUtil.asRegister((Value)this.result);
            if (this.isSigned) {
                masm.ldrs(this.targetSize, this.srcSize, dst, address);
            } else {
                masm.ldr(this.srcSize, dst, address);
            }
            if (this.state != null) {
                int implicitExceptionPosition = prePosition;
                if (prePosition == masm.position() && masm.isImmLoadStoreMerged() && crb.isImplicitExceptionExist(implicitExceptionPosition = prePosition - 4)) {
                    return;
                }
                crb.recordImplicitException(implicitExceptionPosition, this.state);
            }
        }

        @Override
        public boolean makeNullCheckFor(Value value, LIRFrameState nullCheckState, int implicitNullCheckLimit) {
            int displacement = this.input.getDisplacement();
            if (this.state == null && value.equals((Object)this.input.getBase()) && this.input.getOffset().equals((Object)Value.ILLEGAL) && displacement >= 0 && displacement < implicitNullCheckLimit) {
                this.state = nullCheckState;
                return true;
            }
            return false;
        }
    }
}

