/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.meta.JavaConstant;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="ZAP_REGISTER")
public final class AArch64ZapRegistersOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ZapRegistersOp> TYPE = LIRInstructionClass.create(AArch64ZapRegistersOp.class);
    protected final Register[] zappedRegisters;
    protected final JavaConstant[] zapValues;

    public AArch64ZapRegistersOp(Register[] zappedRegisters, JavaConstant[] zapValues) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.zappedRegisters = zappedRegisters;
        this.zapValues = zapValues;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        for (int i = 0; i < this.zappedRegisters.length; ++i) {
            Register reg = this.zappedRegisters[i];
            if (reg == null) continue;
            AArch64Move.const2reg(crb, masm, reg, this.zapValues[i]);
        }
    }
}

