/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="ZAP_STACK")
public final class AArch64ZapStackOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64ZapStackOp> TYPE = LIRInstructionClass.create(AArch64ZapStackOp.class);
    @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
    protected final StackSlot[] zappedStack;
    protected final JavaConstant[] zapValues;

    public AArch64ZapStackOp(StackSlot[] zappedStack, JavaConstant[] zapValues) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.zappedStack = zappedStack;
        this.zapValues = zapValues;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        for (int i = 0; i < this.zappedStack.length; ++i) {
            StackSlot slot = this.zappedStack[i];
            if (slot == null) continue;
            AArch64Move.const2stack(crb, masm, (Value)slot, this.zapValues[i]);
        }
    }
}

