/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import java.util.ArrayList;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.debug.CounterKey;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;

public class MoveResolver {
    private static final CounterKey cycleBreakingSlotsAllocated = DebugContext.counter("LSRA[cycleBreakingSlotsAllocated]");
    private static final CounterKey moveResolverMovesInserted = DebugContext.counter("LSRA[moveResolverMovesInserted]");
    private final LinearScan allocator;
    private int insertIdx;
    private LIRInsertionBuffer insertionBuffer;
    private final ArrayList<Interval> mappingFrom;
    private final ArrayList<Constant> mappingFromOpr;
    private final ArrayList<Interval> mappingTo;
    private boolean multipleReadsAllowed;
    private final int[] registerBlocked;
    private final LIRGenerationResult res;

    protected void setValueBlocked(Value location, int direction) {
        assert (direction == 1 || direction == -1) : "out of bounds";
        if (!ValueUtil.isRegister((Value)location)) {
            throw GraalError.shouldNotReachHere("unhandled value " + location);
        }
        int n = ValueUtil.asRegister((Value)location).number;
        this.registerBlocked[n] = this.registerBlocked[n] + direction;
    }

    protected Interval getMappingFrom(int i) {
        return this.mappingFrom.get(i);
    }

    protected int mappingFromSize() {
        return this.mappingFrom.size();
    }

    protected int valueBlocked(Value location) {
        if (ValueUtil.isRegister((Value)location)) {
            return this.registerBlocked[ValueUtil.asRegister((Value)location).number];
        }
        throw GraalError.shouldNotReachHere("unhandled value " + location);
    }

    void setMultipleReadsAllowed() {
        this.multipleReadsAllowed = true;
    }

    protected boolean areMultipleReadsAllowed() {
        return this.multipleReadsAllowed;
    }

    boolean hasMappings() {
        return this.mappingFrom.size() > 0;
    }

    protected LinearScan getAllocator() {
        return this.allocator;
    }

    protected MoveResolver(LinearScan allocator) {
        this.allocator = allocator;
        this.multipleReadsAllowed = false;
        this.mappingFrom = new ArrayList(8);
        this.mappingFromOpr = new ArrayList(8);
        this.mappingTo = new ArrayList(8);
        this.insertIdx = -1;
        this.insertionBuffer = new LIRInsertionBuffer();
        this.registerBlocked = new int[allocator.getRegisters().size()];
        this.res = allocator.getLIRGenerationResult();
    }

    protected boolean checkEmpty() {
        assert (this.mappingFrom.size() == 0 && this.mappingFromOpr.size() == 0 && this.mappingTo.size() == 0) : "list must be empty before and after processing";
        for (int i = 0; i < this.getAllocator().getRegisters().size(); ++i) {
            assert (this.registerBlocked[i] == 0) : "register map must be empty before and after processing";
        }
        this.checkMultipleReads();
        return true;
    }

    protected void checkMultipleReads() {
        assert (!this.areMultipleReadsAllowed()) : "must have default value";
    }

    private boolean verifyBeforeResolve() {
        boolean unique;
        Interval interval;
        int j;
        int i;
        assert (this.mappingFrom.size() == this.mappingFromOpr.size()) : "length must be equal";
        assert (this.mappingFrom.size() == this.mappingTo.size()) : "length must be equal";
        assert (this.insertIdx != -1) : "insert position not set";
        if (!this.areMultipleReadsAllowed()) {
            for (i = 0; i < this.mappingFrom.size(); ++i) {
                for (j = i + 1; j < this.mappingFrom.size(); ++j) {
                    assert (this.mappingFrom.get(i) == null || this.mappingFrom.get(i) != this.mappingFrom.get(j)) : "cannot read from same interval twice";
                }
            }
        }
        for (i = 0; i < this.mappingTo.size(); ++i) {
            for (j = i + 1; j < this.mappingTo.size(); ++j) {
                assert (this.mappingTo.get(i) != this.mappingTo.get(j)) : "cannot write to same interval twice";
            }
        }
        EconomicSet usedRegs = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        if (!this.areMultipleReadsAllowed()) {
            for (i = 0; i < this.mappingFrom.size(); ++i) {
                interval = this.mappingFrom.get(i);
                if (interval == null || ValueUtil.isIllegal((Value)interval.location())) continue;
                unique = usedRegs.add((Object)interval.location());
                assert (unique) : "cannot read from same register twice";
            }
        }
        usedRegs.clear();
        for (i = 0; i < this.mappingTo.size(); ++i) {
            interval = this.mappingTo.get(i);
            if (ValueUtil.isIllegal((Value)interval.location())) continue;
            unique = usedRegs.add((Object)interval.location());
            assert (unique) : "cannot write to same register twice";
        }
        this.verifyStackSlotMapping();
        return true;
    }

    protected void verifyStackSlotMapping() {
        Interval interval;
        int i;
        EconomicSet usedRegs = EconomicSet.create((Equivalence)Equivalence.DEFAULT);
        for (i = 0; i < this.mappingFrom.size(); ++i) {
            interval = this.mappingFrom.get(i);
            if (interval == null || ValueUtil.isRegister((Value)interval.location())) continue;
            usedRegs.add((Object)interval.location());
        }
        for (i = 0; i < this.mappingTo.size(); ++i) {
            interval = this.mappingTo.get(i);
            assert (!usedRegs.contains((Object)interval.location()) || MoveResolver.checkIntervalLocation(this.mappingFrom.get(i), interval, this.mappingFromOpr.get(i))) : "stack slots used in mappingFrom must be disjoint to mappingTo";
        }
    }

    private static boolean checkIntervalLocation(Interval from, Interval to, Constant fromOpr) {
        if (from == null) {
            return fromOpr != null;
        }
        return to.location().equals((Object)from.location());
    }

    private void blockRegisters(Interval interval) {
        AllocatableValue location = interval.location();
        if (this.mightBeBlocked((Value)location)) {
            assert (this.areMultipleReadsAllowed() || this.valueBlocked((Value)location) == 0) : "location already marked as used: " + location;
            int direction = 1;
            this.setValueBlocked((Value)location, direction);
            this.allocator.getDebug().log("block %s", location);
        }
    }

    private void unblockRegisters(Interval interval) {
        AllocatableValue location = interval.location();
        if (this.mightBeBlocked((Value)location)) {
            assert (this.valueBlocked((Value)location) > 0) : "location already marked as unused: " + location;
            this.setValueBlocked((Value)location, -1);
            this.allocator.getDebug().log("unblock %s", location);
        }
    }

    private boolean safeToProcessMove(Interval from, Interval to) {
        AllocatableValue fromReg = from != null ? from.location() : null;
        AllocatableValue location = to.location();
        return !this.mightBeBlocked((Value)location) || this.valueBlocked((Value)location) <= 1 && (this.valueBlocked((Value)location) != 1 || this.isMoveToSelf((Value)fromReg, (Value)location));
    }

    protected boolean isMoveToSelf(Value from, Value to) {
        assert (to != null);
        if (to.equals((Object)from)) {
            return true;
        }
        if (from != null && ValueUtil.isRegister((Value)from) && ValueUtil.isRegister((Value)to) && ValueUtil.asRegister((Value)from).equals((Object)ValueUtil.asRegister((Value)to))) {
            assert (LIRKind.verifyMoveKinds(to.getValueKind(), from.getValueKind(), this.allocator.getRegisterAllocationConfig())) : String.format("Same register but Kind mismatch %s <- %s", to, from);
            return true;
        }
        return false;
    }

    protected boolean mightBeBlocked(Value location) {
        return ValueUtil.isRegister((Value)location);
    }

    private void createInsertionBuffer(ArrayList<LIRInstruction> list) {
        assert (!this.insertionBuffer.initialized()) : "overwriting existing buffer";
        this.insertionBuffer.init(list);
    }

    private void appendInsertionBuffer() {
        if (this.insertionBuffer.initialized()) {
            this.insertionBuffer.finish();
        }
        assert (!this.insertionBuffer.initialized()) : "must be uninitialized now";
        this.insertIdx = -1;
    }

    private LIRInstruction insertMove(Interval fromInterval, Interval toInterval) {
        assert (!fromInterval.operand.equals((Object)toInterval.operand)) : "from and to interval equal: " + fromInterval;
        assert (LIRKind.verifyMoveKinds(toInterval.kind(), fromInterval.kind(), this.allocator.getRegisterAllocationConfig())) : "move between different types";
        assert (this.insertIdx != -1) : "must setup insert position first";
        LIRInstruction move = this.createMove(fromInterval.operand, toInterval.operand, fromInterval.location(), toInterval.location());
        this.insertionBuffer.append(this.insertIdx, move);
        DebugContext debug = this.allocator.getDebug();
        if (debug.isLogEnabled()) {
            debug.log("insert move from %s to %s at %d", fromInterval, (Object)toInterval, (Object)this.insertIdx);
        }
        moveResolverMovesInserted.increment(debug);
        return move;
    }

    protected LIRInstruction createMove(AllocatableValue fromOpr, AllocatableValue toOpr, AllocatableValue fromLocation, AllocatableValue toLocation) {
        return this.getAllocator().getSpillMoveFactory().createMove(toOpr, (Value)fromOpr);
    }

    private LIRInstruction insertMove(Constant fromOpr, Interval toInterval) {
        assert (this.insertIdx != -1) : "must setup insert position first";
        AllocatableValue toOpr = toInterval.operand;
        LIRInstruction move = LIRValueUtil.isStackSlotValue((Value)toInterval.location()) ? this.getAllocator().getSpillMoveFactory().createStackLoad(toOpr, fromOpr) : this.getAllocator().getSpillMoveFactory().createLoad(toOpr, fromOpr);
        this.insertionBuffer.append(this.insertIdx, move);
        DebugContext debug = this.allocator.getDebug();
        if (debug.isLogEnabled()) {
            debug.log("insert move from value %s to %s at %d", fromOpr, (Object)toInterval, (Object)this.insertIdx);
        }
        return move;
    }

    private void resolveMappings() {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("resolveMapping");){
            int i;
            assert (this.verifyBeforeResolve());
            if (debug.isLogEnabled()) {
                this.printMapping();
            }
            for (i = this.mappingFrom.size() - 1; i >= 0; --i) {
                Interval fromInterval = this.mappingFrom.get(i);
                if (fromInterval == null) continue;
                this.blockRegisters(fromInterval);
            }
            ArrayList<AllocatableValue> busySpillSlots = null;
            while (this.mappingFrom.size() > 0) {
                boolean processedInterval = false;
                int spillCandidate = -1;
                for (i = this.mappingFrom.size() - 1; i >= 0; --i) {
                    Interval toInterval;
                    Interval fromInterval = this.mappingFrom.get(i);
                    if (this.safeToProcessMove(fromInterval, toInterval = this.mappingTo.get(i))) {
                        LIRInstruction move;
                        if (fromInterval != null) {
                            move = this.insertMove(fromInterval, toInterval);
                            this.unblockRegisters(fromInterval);
                        } else {
                            move = this.insertMove(this.mappingFromOpr.get(i), toInterval);
                        }
                        move.setComment(this.res, "MoveResolver resolve mapping");
                        if (LIRValueUtil.isStackSlotValue((Value)toInterval.location())) {
                            if (busySpillSlots == null) {
                                busySpillSlots = new ArrayList<AllocatableValue>(2);
                            }
                            busySpillSlots.add(toInterval.location());
                        }
                        this.mappingFrom.remove(i);
                        this.mappingFromOpr.remove(i);
                        this.mappingTo.remove(i);
                        processedInterval = true;
                        continue;
                    }
                    if (fromInterval == null || !ValueUtil.isRegister((Value)fromInterval.location()) || busySpillSlots != null && busySpillSlots.contains(fromInterval.spillSlot())) continue;
                    spillCandidate = i;
                }
                if (processedInterval) continue;
                this.breakCycle(spillCandidate);
            }
        }
        this.multipleReadsAllowed = false;
        assert (this.checkEmpty());
    }

    protected void breakCycle(int spillCandidate) {
        assert (spillCandidate != -1) : "no interval in register for spilling found";
        Interval fromInterval = this.mappingFrom.get(spillCandidate);
        AllocatableValue spillSlot = fromInterval.spillSlot();
        if (spillSlot == null) {
            spillSlot = this.getAllocator().getFrameMapBuilder().allocateSpillSlot(fromInterval.kind());
            fromInterval.setSpillSlot(spillSlot);
            cycleBreakingSlotsAllocated.increment(this.allocator.getDebug());
        }
        this.spillInterval(spillCandidate, fromInterval, spillSlot);
    }

    protected void spillInterval(int spillCandidate, Interval fromInterval, AllocatableValue spillSlot) {
        assert (this.mappingFrom.get(spillCandidate).equals(fromInterval));
        Interval spillInterval = this.getAllocator().createDerivedInterval(fromInterval);
        spillInterval.setKind(fromInterval.kind());
        spillInterval.addRange(1, 2);
        spillInterval.assignLocation(spillSlot);
        DebugContext debug = this.allocator.getDebug();
        if (debug.isLogEnabled()) {
            debug.log("created new Interval for spilling: %s", spillInterval);
        }
        this.blockRegisters(spillInterval);
        LIRInstruction move = this.insertMove(fromInterval, spillInterval);
        this.mappingFrom.set(spillCandidate, spillInterval);
        this.unblockRegisters(fromInterval);
        move.setComment(this.res, "MoveResolver break cycle");
    }

    private void printMapping() {
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("Mapping");){
            for (int i = this.mappingFrom.size() - 1; i >= 0; --i) {
                Interval fromInterval = this.mappingFrom.get(i);
                Interval toInterval = this.mappingTo.get(i);
                AllocatableValue to = toInterval.location();
                String from = fromInterval == null ? this.mappingFromOpr.get(i).toString() : fromInterval.location().toString();
                debug.log("move %s <- %s", (Object)from, (Object)to);
            }
        }
    }

    void setInsertPosition(ArrayList<LIRInstruction> insertList, int insertIdx) {
        assert (this.insertIdx == -1) : "use moveInsertPosition instead of setInsertPosition when data already set";
        this.createInsertionBuffer(insertList);
        this.insertIdx = insertIdx;
    }

    void moveInsertPosition(ArrayList<LIRInstruction> newInsertList, int newInsertIdx) {
        if (this.insertionBuffer.lirList() != null && (this.insertionBuffer.lirList() != newInsertList || this.insertIdx != newInsertIdx)) {
            this.resolveMappings();
        }
        if (this.insertionBuffer.lirList() != newInsertList) {
            this.appendInsertionBuffer();
            this.createInsertionBuffer(newInsertList);
        }
        this.insertIdx = newInsertIdx;
    }

    public void addMapping(Interval fromInterval, Interval toInterval) {
        DebugContext debug = this.allocator.getDebug();
        if (ValueUtil.isIllegal((Value)toInterval.location()) && toInterval.canMaterialize()) {
            if (debug.isLogEnabled()) {
                debug.log("no store to rematerializable interval %s needed", toInterval);
            }
            return;
        }
        if (ValueUtil.isIllegal((Value)fromInterval.location()) && fromInterval.canMaterialize()) {
            Constant rematValue = fromInterval.getMaterializedValue();
            this.addMapping(rematValue, toInterval);
            return;
        }
        if (debug.isLogEnabled()) {
            debug.log("add move mapping from %s to %s", (Object)fromInterval, (Object)toInterval);
        }
        assert (!fromInterval.operand.equals((Object)toInterval.operand)) : "from and to interval equal: " + fromInterval;
        assert (LIRKind.verifyMoveKinds(toInterval.kind(), fromInterval.kind(), this.allocator.getRegisterAllocationConfig())) : String.format("Kind mismatch: %s vs. %s, from=%s, to=%s", fromInterval.kind(), toInterval.kind(), fromInterval, toInterval);
        this.mappingFrom.add(fromInterval);
        this.mappingFromOpr.add(null);
        this.mappingTo.add(toInterval);
    }

    public void addMapping(Constant fromOpr, Interval toInterval) {
        DebugContext debug = this.allocator.getDebug();
        if (debug.isLogEnabled()) {
            debug.log("add move mapping from %s to %s", (Object)fromOpr, (Object)toInterval);
        }
        this.mappingFrom.add(null);
        this.mappingFromOpr.add(fromOpr);
        this.mappingTo.add(toInterval);
    }

    void resolveAndAppendMoves() {
        if (this.hasMappings()) {
            this.resolveMappings();
        }
        this.appendInsertionBuffer();
    }
}

