/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.alloc.lsra;

import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.alloc.lsra.Interval;
import org.graalvm.compiler.lir.alloc.lsra.LinearScan;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanWalker;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;

public class OptimizingLinearScanWalker
extends LinearScanWalker {
    OptimizingLinearScanWalker(LinearScan allocator, Interval unhandledFixedFirst, Interval unhandledAnyFirst) {
        super(allocator, unhandledFixedFirst, unhandledAnyFirst);
    }

    @Override
    protected void handleSpillSlot(Interval interval) {
        assert (interval.location() != null) : "interval  not assigned " + interval;
        if (interval.canMaterialize()) {
            assert (!LIRValueUtil.isStackSlotValue((Value)interval.location())) : "interval can materialize but assigned to a stack slot " + interval;
            return;
        }
        assert (LIRValueUtil.isStackSlotValue((Value)interval.location())) : "interval not assigned to a stack slot " + interval;
        DebugContext debug = this.allocator.getDebug();
        try (DebugContext.Scope s1 = debug.scope("LSRAOptimization");){
            debug.log("adding stack to unhandled list %s", interval);
            this.unhandledLists.addToListSortedByStartAndUsePositions(Interval.RegisterBinding.Stack, interval);
        }
    }

    private static void printRegisterBindingList(DebugContext debug, Interval.RegisterBindingLists list, Interval.RegisterBinding binding) {
        Interval interval = list.get(binding);
        while (!interval.isEndMarker()) {
            debug.log("%s", interval);
            interval = interval.next;
        }
    }

    @Override
    void walk() {
        try (DebugContext.Scope s = this.allocator.getDebug().scope("OptimizingLinearScanWalker");){
            for (AbstractBlockBase<?> block : this.allocator.sortedBlocks()) {
                this.optimizeBlock(block);
            }
        }
        super.walk();
    }

    private void optimizeBlock(AbstractBlockBase<?> block) {
        block59: {
            if (block.getPredecessorCount() == 1) {
                int nextBlock = this.allocator.getFirstLirInstructionId(block);
                DebugContext debug = this.allocator.getDebug();
                try (DebugContext.Scope s1 = debug.scope("LSRAOptimization");){
                    debug.log("next block: %s (%d)", (Object)block, nextBlock);
                }
                var5_5 = null;
                try (Indent indent0 = debug.indent();){
                    this.walkTo(nextBlock);
                    try (DebugContext.Scope s1 = debug.scope("LSRAOptimization");){
                        boolean changed = true;
                        while (changed) {
                            changed = false;
                            Indent indent1 = debug.logAndIndent("Active intervals: (block %s [%d])", (Object)block, nextBlock);
                            Throwable throwable = null;
                            try {
                                Interval active = this.activeLists.get(Interval.RegisterBinding.Any);
                                while (!active.isEndMarker()) {
                                    debug.log("active   (any): %s", active);
                                    if (this.optimize(nextBlock, block, active, Interval.RegisterBinding.Any)) {
                                        changed = true;
                                        break block59;
                                    }
                                    active = active.next;
                                }
                                active = this.activeLists.get(Interval.RegisterBinding.Stack);
                                while (!active.isEndMarker()) {
                                    debug.log("active (stack): %s", active);
                                    if (this.optimize(nextBlock, block, active, Interval.RegisterBinding.Stack)) {
                                        changed = true;
                                        break block59;
                                    }
                                    active = active.next;
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            finally {
                                if (indent1 == null) continue;
                                if (throwable != null) {
                                    try {
                                        indent1.close();
                                    }
                                    catch (Throwable throwable3) {
                                        throwable.addSuppressed(throwable3);
                                    }
                                    continue;
                                }
                                indent1.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
            }
        }
    }

    private boolean optimize(int currentPos, AbstractBlockBase<?> currentBlock, Interval currentInterval, Interval.RegisterBinding binding) {
        assert (currentBlock != null) : "block must not be null";
        assert (currentInterval != null) : "interval must not be null";
        assert (currentBlock.getPredecessorCount() == 1) : "more than one predecessors -> optimization not possible";
        if (!currentInterval.isSplitChild()) {
            return false;
        }
        if (currentInterval.from() == currentPos) {
            return false;
        }
        AllocatableValue currentLocation = currentInterval.location();
        assert (currentLocation != null) : "active intervals must have a location assigned!";
        AbstractBlockBase predecessorBlock = currentBlock.getPredecessors()[0];
        int predEndId = this.allocator.getLastLirInstructionId(predecessorBlock);
        Interval predecessorInterval = currentInterval.getIntervalCoveringOpId(predEndId);
        assert (predecessorInterval != null) : "variable not live at the end of the only predecessor! " + predecessorBlock + " -> " + currentBlock + " interval: " + currentInterval;
        AllocatableValue predecessorLocation = predecessorInterval.location();
        assert (predecessorLocation != null) : "handled intervals must have a location assigned!";
        if (currentLocation.equals((Object)predecessorLocation)) {
            return false;
        }
        if (!LIRValueUtil.isStackSlotValue((Value)predecessorLocation) && !ValueUtil.isRegister((Value)predecessorLocation)) {
            assert (predecessorInterval.canMaterialize());
            return false;
        }
        assert (LIRValueUtil.isStackSlotValue((Value)currentLocation) || ValueUtil.isRegister((Value)currentLocation)) : "current location not a register or stack slot " + currentLocation;
        DebugContext debug = this.allocator.getDebug();
        try (Indent indent = debug.logAndIndent("location differs: %s vs. %s", (Object)predecessorLocation, (Object)currentLocation);){
            debug.log("splitting at position %d", currentPos);
            assert (this.allocator.isBlockBegin(currentPos) && (currentPos & 1) == 0) : "split pos must be even when on block boundary";
            Interval splitPart = currentInterval.split(currentPos, this.allocator);
            this.activeLists.remove(binding, currentInterval);
            assert (splitPart.from() >= this.currentPosition) : "cannot append new interval before current walk position";
            assert (splitPart.currentSplitChild() == currentInterval) : "overwriting wrong currentSplitChild";
            splitPart.makeCurrentSplitChild();
            if (debug.isLogEnabled()) {
                debug.log("left interval  : %s", (Object)currentInterval.logString(this.allocator));
                debug.log("right interval : %s", (Object)splitPart.logString(this.allocator));
            }
            if (Options.LSRAOptSplitOnly.getValue(this.allocator.getOptions()).booleanValue()) {
                this.unhandledLists.addToListSortedByStartAndUsePositions(Interval.RegisterBinding.Any, splitPart);
            } else if (ValueUtil.isRegister((Value)predecessorLocation)) {
                this.splitRegisterInterval(splitPart, ValueUtil.asRegister((Value)predecessorLocation));
            } else {
                assert (LIRValueUtil.isStackSlotValue((Value)predecessorLocation));
                debug.log("assigning interval %s to %s", (Object)splitPart, (Object)predecessorLocation);
                splitPart.assignLocation(predecessorLocation);
                this.activeLists.addToListSortedByCurrentFromPositions(Interval.RegisterBinding.Stack, splitPart);
                splitPart.state = Interval.State.Active;
                this.splitStackInterval(splitPart);
            }
        }
        return true;
    }

    private void splitRegisterInterval(Interval interval, Register reg) {
        this.initVarsForAlloc(interval);
        this.initUseLists(false);
        this.spillExcludeActiveFixed();
        assert (this.unhandledLists.get(Interval.RegisterBinding.Fixed).isEndMarker()) : "must not have unhandled fixed intervals because all fixed intervals have a use at position 0";
        this.spillBlockInactiveFixed(interval);
        this.spillCollectActiveAny(Interval.RegisterPriority.LiveAtLoopEnd);
        this.spillCollectInactiveAny(interval);
        DebugContext debug = this.allocator.getDebug();
        if (debug.isLogEnabled()) {
            try (Indent indent2 = debug.logAndIndent("state of registers:");){
                for (Register register : this.availableRegs) {
                    int i = register.number;
                    try (Indent indent3 = debug.logAndIndent("reg %d: usePos: %d, blockPos: %d, intervals: ", i, this.usePos[i], this.blockPos[i]);){
                        for (int j = 0; j < this.spillIntervals[i].size(); ++j) {
                            debug.log("%d ", ((Interval)this.spillIntervals[i].get((int)j)).operandNumber);
                        }
                    }
                }
            }
        }
        boolean needSplit = this.blockPos[reg.number] <= interval.to();
        int splitPos = this.blockPos[reg.number];
        assert (splitPos > 0) : "invalid splitPos";
        assert (needSplit || splitPos > interval.from()) : "splitting interval at from";
        debug.log("assigning interval %s to %s", (Object)interval, (Object)reg);
        interval.assignLocation((AllocatableValue)reg.asValue(interval.kind()));
        if (needSplit) {
            this.splitWhenPartialRegisterAvailable(interval, splitPos);
        }
        this.splitAndSpillIntersectingIntervals(reg);
        this.activeLists.addToListSortedByCurrentFromPositions(Interval.RegisterBinding.Any, interval);
        interval.state = Interval.State.Active;
    }

    public static class Options {
        @Option(help={"Enable LSRA optimization"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> LSRAOptimization = new OptionKey<Boolean>(false);
        @Option(help={"LSRA optimization: Only split but do not reassign"}, type=OptionType.Debug)
        public static final OptionKey<Boolean> LSRAOptSplitOnly = new OptionKey<Boolean>(false);
    }
}

