/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.amd64.AMD64Kind;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64Assembler;
import org.graalvm.compiler.asm.amd64.AMD64BaseAssembler;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.core.common.type.DataPointerConstant;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.amd64.AMD64AddressValue;
import org.graalvm.compiler.lir.amd64.AMD64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;
import org.graalvm.compiler.options.OptionValues;

public class AMD64Move {
    public static void move(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, Value input) {
        AMD64Move.move((AMD64Kind)result.getPlatformKind(), crb, masm, result, input);
    }

    private static void move(AMD64Kind moveKind, CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, Value input) {
        if (ValueUtil.isRegister((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                AMD64Move.reg2reg(moveKind, masm, result, input);
                return;
            }
            if (ValueUtil.isStackSlot((Value)result)) {
                AMD64Move.reg2stack(moveKind, crb, masm, result, ValueUtil.asRegister((Value)input));
                return;
            }
        } else if (ValueUtil.isStackSlot((Value)input)) {
            if (ValueUtil.isRegister((Value)result)) {
                AMD64Move.stack2reg(moveKind, crb, masm, ValueUtil.asRegister((Value)result), input);
                return;
            }
        } else if (LIRValueUtil.isJavaConstant(input)) {
            if (ValueUtil.isRegister((Value)result)) {
                AMD64Move.const2reg(crb, masm, ValueUtil.asRegister((Value)result), LIRValueUtil.asJavaConstant(input), moveKind);
                return;
            }
            if (ValueUtil.isStackSlot((Value)result)) {
                AMD64Move.const2stack(crb, masm, result, LIRValueUtil.asJavaConstant(input));
                return;
            }
        }
        throw GraalError.shouldNotReachHere("input=" + input + " input.class=" + input.getClass().getName() + " result=" + result + " result.class=" + result.getClass().getName());
    }

    private static void reg2reg(AMD64Kind kind, AMD64MacroAssembler masm, Value result, Value input) {
        if (ValueUtil.asRegister((Value)input).equals((Object)ValueUtil.asRegister((Value)result))) {
            return;
        }
        assert (ValueUtil.asRegister((Value)result).getRegisterCategory().equals((Object)ValueUtil.asRegister((Value)input).getRegisterCategory()));
        switch (kind) {
            case BYTE: 
            case WORD: 
            case DWORD: {
                masm.movl(ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)input));
                break;
            }
            case QWORD: {
                masm.movq(ValueUtil.asRegister((Value)result), ValueUtil.asRegister((Value)input));
                break;
            }
            case SINGLE: {
                masm.movflt(ValueUtil.asRegister((Value)result, (PlatformKind)AMD64Kind.SINGLE), ValueUtil.asRegister((Value)input, (PlatformKind)AMD64Kind.SINGLE));
                break;
            }
            case DOUBLE: {
                masm.movdbl(ValueUtil.asRegister((Value)result, (PlatformKind)AMD64Kind.DOUBLE), ValueUtil.asRegister((Value)input, (PlatformKind)AMD64Kind.DOUBLE));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("kind=" + kind + " input=" + input + " result=" + result);
            }
        }
    }

    public static void reg2stack(AMD64Kind kind, CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, Register input) {
        AMD64Address dest = (AMD64Address)crb.asAddress(result);
        switch (kind) {
            case BYTE: {
                masm.movb(dest, input);
                break;
            }
            case WORD: {
                masm.movw(dest, input);
                break;
            }
            case DWORD: {
                masm.movl(dest, input);
                break;
            }
            case QWORD: {
                masm.movq(dest, input);
                break;
            }
            case SINGLE: {
                masm.movflt(dest, input);
                break;
            }
            case DOUBLE: {
                masm.movsd(dest, input);
                break;
            }
            case V128_QWORD: {
                masm.movdqu(dest, input);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("kind=" + kind + " input=" + input + " result=" + result);
            }
        }
    }

    public static void stack2reg(AMD64Kind kind, CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, Value input) {
        AMD64Address src = (AMD64Address)crb.asAddress(input);
        switch (kind) {
            case BYTE: {
                masm.movsbl(result, src);
                break;
            }
            case WORD: {
                masm.movswl(result, src);
                break;
            }
            case DWORD: {
                masm.movl(result, src);
                break;
            }
            case QWORD: {
                masm.movq(result, src);
                break;
            }
            case SINGLE: {
                masm.movflt(result, src);
                break;
            }
            case DOUBLE: {
                masm.movdbl(result, src);
                break;
            }
            case V128_QWORD: {
                masm.movdqu(result, src);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("kind=" + kind + " input=" + input + " result=" + result);
            }
        }
    }

    public static void const2reg(CompilationResultBuilder crb, AMD64MacroAssembler masm, Register result, JavaConstant input, AMD64Kind moveKind) {
        assert (!result.getRegisterCategory().equals((Object)AMD64.MASK)) : "no general const-to-mask moves supported";
        switch (input.getJavaKind().getStackKind()) {
            case Int: {
                masm.movl(result, input.asInt());
                break;
            }
            case Long: {
                if (input.asLong() == (long)((int)input.asLong())) {
                    masm.movslq(result, (int)input.asLong());
                    break;
                }
                if ((input.asLong() & 0xFFFFFFFFL) == input.asLong()) {
                    masm.movl(result, (int)input.asLong());
                    break;
                }
                masm.movq(result, input.asLong());
                break;
            }
            case Float: {
                if (Float.floatToRawIntBits(input.asFloat()) == Float.floatToRawIntBits(0.0f)) {
                    masm.xorps(result, result);
                    break;
                }
                masm.movflt(result, (AMD64Address)crb.asFloatConstRef(input));
                break;
            }
            case Double: {
                if (Double.doubleToRawLongBits(input.asDouble()) == Double.doubleToRawLongBits(0.0)) {
                    masm.xorpd(result, result);
                    break;
                }
                masm.movdbl(result, (AMD64Address)crb.asDoubleConstRef(input));
                break;
            }
            case Object: {
                assert (moveKind != null) : "a nun-null moveKind is required for loading an object constant";
                if (input.isNull()) {
                    if (moveKind == AMD64Kind.QWORD && crb.mustReplaceWithUncompressedNullRegister(input)) {
                        masm.movq(result, crb.uncompressedNullRegister);
                        break;
                    }
                    masm.movslq(result, 0);
                    break;
                }
                if (crb.target.inlineObjects) {
                    crb.recordInlineDataInCode((Constant)input);
                    if (moveKind == AMD64Kind.DWORD) {
                        masm.movl(result, -559030611, true);
                        break;
                    }
                    masm.movq(result, -2401018187971961171L, true);
                    break;
                }
                if (moveKind == AMD64Kind.DWORD) {
                    masm.movl(result, (AMD64Address)crb.recordDataReferenceInCode((Constant)input, 0));
                    break;
                }
                masm.movq(result, (AMD64Address)crb.recordDataReferenceInCode((Constant)input, 0));
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
    }

    public static boolean canMoveConst2Stack(JavaConstant input) {
        switch (input.getJavaKind().getStackKind()) {
            case Int: {
                break;
            }
            case Long: {
                break;
            }
            case Float: {
                break;
            }
            case Double: {
                break;
            }
            case Object: {
                return input.isNull();
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public static void const2stack(CompilationResultBuilder crb, AMD64MacroAssembler masm, Value result, JavaConstant input) {
        long imm;
        AMD64Address dest = (AMD64Address)crb.asAddress(result);
        switch (input.getJavaKind().getStackKind()) {
            case Int: {
                imm = input.asInt();
                break;
            }
            case Long: {
                imm = input.asLong();
                break;
            }
            case Float: {
                imm = Float.floatToRawIntBits(input.asFloat());
                break;
            }
            case Double: {
                imm = Double.doubleToRawLongBits(input.asDouble());
                break;
            }
            case Object: {
                if (input.isNull()) {
                    if (crb.mustReplaceWithUncompressedNullRegister(input)) {
                        masm.movq(dest, crb.uncompressedNullRegister);
                        return;
                    }
                    imm = 0L;
                    break;
                }
                throw GraalError.shouldNotReachHere("Non-null object constants must be in a register");
            }
            default: {
                throw GraalError.shouldNotReachHere();
            }
        }
        switch ((AMD64Kind)result.getPlatformKind()) {
            case BYTE: {
                assert (NumUtil.isByte(imm)) : "Is not in byte range: " + imm;
                AMD64Assembler.AMD64MIOp.MOVB.emit((AMD64Assembler)masm, AMD64BaseAssembler.OperandSize.BYTE, dest, (int)imm);
                break;
            }
            case WORD: {
                assert (NumUtil.isShort(imm)) : "Is not in short range: " + imm;
                AMD64Assembler.AMD64MIOp.MOV.emit((AMD64Assembler)masm, AMD64BaseAssembler.OperandSize.WORD, dest, (int)imm);
                break;
            }
            case DWORD: 
            case SINGLE: {
                assert (NumUtil.isInt(imm)) : "Is not in int range: " + imm;
                masm.movl(dest, (int)imm);
                break;
            }
            case QWORD: 
            case DOUBLE: {
                masm.movlong(dest, imm);
                break;
            }
            default: {
                throw GraalError.shouldNotReachHere("Unknown result Kind: " + result.getPlatformKind());
            }
        }
    }

    public static class ConvertZeroToNullOp
    extends ZeroNullConversionOp {
        public static final LIRInstructionClass<ConvertZeroToNullOp> TYPE = LIRInstructionClass.create(ConvertZeroToNullOp.class);

        public ConvertZeroToNullOp(AllocatableValue result, AllocatableValue input) {
            super(TYPE, result, input);
        }

        @Override
        protected final void emitConversion(Register resultRegister, Register inputRegister, Register nullRegister, AMD64MacroAssembler masm) {
            if (!inputRegister.equals((Object)resultRegister)) {
                masm.movq(resultRegister, inputRegister);
            }
            masm.testq(inputRegister, inputRegister);
            masm.cmovq(AMD64Assembler.ConditionFlag.Equal, resultRegister, nullRegister);
        }
    }

    public static class ConvertNullToZeroOp
    extends ZeroNullConversionOp {
        public static final LIRInstructionClass<ConvertNullToZeroOp> TYPE = LIRInstructionClass.create(ConvertNullToZeroOp.class);

        public ConvertNullToZeroOp(AllocatableValue result, AllocatableValue input) {
            super(TYPE, result, input);
        }

        @Override
        protected final void emitConversion(Register resultRegister, Register inputRegister, Register nullRegister, AMD64MacroAssembler masm) {
            if (inputRegister.equals((Object)resultRegister)) {
                Label done = new Label();
                masm.subqAndJcc(inputRegister, nullRegister, AMD64Assembler.ConditionFlag.Equal, done, true);
                masm.addq(inputRegister, nullRegister);
                masm.bind(done);
            } else {
                masm.subq(resultRegister, resultRegister);
                masm.cmpq(inputRegister, nullRegister);
                masm.cmovq(AMD64Assembler.ConditionFlag.NotEqual, resultRegister, inputRegister);
            }
        }
    }

    private static abstract class ZeroNullConversionOp
    extends AMD64LIRInstruction {
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue input;

        protected ZeroNullConversionOp(LIRInstructionClass<? extends ZeroNullConversionOp> type, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)type);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Register nullRegister = crb.uncompressedNullRegister;
            if (!nullRegister.equals((Object)Register.None)) {
                this.emitConversion(ValueUtil.asRegister((Value)this.result), ValueUtil.asRegister((Value)this.input), nullRegister, masm);
            }
        }

        protected abstract void emitConversion(Register var1, Register var2, Register var3, AMD64MacroAssembler var4);
    }

    public static class UncompressPointerOp
    extends PointerCompressionOp {
        public static final LIRInstructionClass<UncompressPointerOp> TYPE = LIRInstructionClass.create(UncompressPointerOp.class);

        public UncompressPointerOp(AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            this(TYPE, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        private UncompressPointerOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super(type, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            Register inputReg;
            Register baseReg = this.getBaseRegister(crb);
            int shift = this.getShift();
            Register resReg = this.getResultRegister();
            if (this.nonNull && !baseReg.equals((Object)Register.None) && this.getInput() instanceof RegisterValue && !(inputReg = ((RegisterValue)this.getInput()).getRegister()).equals((Object)resReg)) {
                UncompressPointerOp.emitUncompressWithBaseRegister(masm, resReg, baseReg, inputReg, shift, false);
                return;
            }
            this.move(this.lirKindTool.getNarrowOopKind(), crb, masm);
            UncompressPointerOp.emitUncompressCode(masm, resReg, shift, baseReg, this.nonNull);
        }

        public static void emitUncompressCode(AMD64MacroAssembler masm, Register resReg, int shift, Register baseReg, boolean nonNull) {
            if (nonNull) {
                if (!baseReg.equals((Object)Register.None)) {
                    UncompressPointerOp.emitUncompressWithBaseRegister(masm, resReg, baseReg, shift, false);
                } else if (shift != 0) {
                    masm.shlq(resReg, shift);
                }
            } else {
                if (shift != 0) {
                    masm.shlq(resReg, shift);
                }
                if (!baseReg.equals((Object)Register.None)) {
                    if (shift == 0) {
                        masm.testq(resReg, resReg);
                    }
                    Label done = new Label();
                    masm.jccb(AMD64Assembler.ConditionFlag.Equal, done);
                    masm.addq(resReg, baseReg);
                    masm.bind(done);
                }
            }
        }
    }

    public static class CompressPointerOp
    extends PointerCompressionOp {
        public static final LIRInstructionClass<CompressPointerOp> TYPE = LIRInstructionClass.create(CompressPointerOp.class);

        public CompressPointerOp(AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            this(TYPE, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        private CompressPointerOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super(type, result, input, baseRegister, encoding, nonNull, lirKindTool);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            int shift;
            this.move(this.lirKindTool.getObjectKind(), crb, masm);
            Register resReg = this.getResultRegister();
            Register baseReg = this.getBaseRegister(crb);
            if (!baseReg.equals((Object)Register.None)) {
                if (!this.nonNull) {
                    masm.testq(resReg, resReg);
                    masm.cmovq(AMD64Assembler.ConditionFlag.Equal, resReg, baseReg);
                }
                masm.subq(resReg, baseReg);
            }
            if ((shift = this.getShift()) != 0) {
                masm.shrq(resReg, shift);
            }
        }
    }

    public static abstract class PointerCompressionOp
    extends AMD64LIRInstruction {
        protected final LIRKindTool lirKindTool;
        protected final CompressEncoding encoding;
        protected final boolean nonNull;
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        private AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.CONST})
        private Value input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.ILLEGAL, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue baseRegister;

        protected PointerCompressionOp(LIRInstructionClass<? extends PointerCompressionOp> type, AllocatableValue result, Value input, AllocatableValue baseRegister, CompressEncoding encoding, boolean nonNull, LIRKindTool lirKindTool) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)type);
            this.result = result;
            this.input = input;
            this.baseRegister = baseRegister;
            this.encoding = encoding;
            this.nonNull = nonNull;
            this.lirKindTool = lirKindTool;
        }

        public static boolean hasBase(OptionValues options, CompressEncoding encoding) {
            return GraalOptions.GeneratePIC.getValue(options) != false || encoding.hasBase();
        }

        public final Value getInput() {
            return this.input;
        }

        public final AllocatableValue getResult() {
            return this.result;
        }

        protected final Register getResultRegister() {
            return ValueUtil.asRegister((Value)this.result);
        }

        protected final Register getBaseRegister(CompilationResultBuilder crb) {
            return PointerCompressionOp.hasBase(crb.getOptions(), this.encoding) ? ValueUtil.asRegister((Value)this.baseRegister) : Register.None;
        }

        protected final int getShift() {
            return this.encoding.getShift();
        }

        protected final void move(LIRKind kind, CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move((AMD64Kind)kind.getPlatformKind(), crb, masm, (Value)this.result, this.input);
        }

        public static void emitUncompressWithBaseRegister(AMD64MacroAssembler masm, Register inputAndResultReg, Register baseReg, int shift, boolean preserveFlagsRegister) {
            PointerCompressionOp.emitUncompressWithBaseRegister(masm, inputAndResultReg, baseReg, inputAndResultReg, shift, preserveFlagsRegister);
        }

        public static void emitUncompressWithBaseRegister(AMD64MacroAssembler masm, Register resultReg, Register baseReg, Register inputReg, int shift, boolean preserveFlagsRegister) {
            assert (!baseReg.equals((Object)Register.None) || shift != 0) : "compression not enabled";
            if (AMD64Address.Scale.isScaleShiftSupported(shift)) {
                AMD64Address.Scale scale = AMD64Address.Scale.fromShift(shift);
                masm.leaq(resultReg, new AMD64Address(baseReg, inputReg, scale));
            } else {
                if (preserveFlagsRegister) {
                    throw GraalError.shouldNotReachHere("No valid flag-effect-free instruction available to uncompress oop");
                }
                if (!resultReg.equals((Object)inputReg)) {
                    masm.movq(resultReg, inputReg);
                }
                masm.shlq(resultReg, shift);
                masm.addq(resultReg, baseReg);
            }
        }
    }

    @Opcode(value="ATOMIC_READ_AND_WRITE")
    public static final class AtomicReadAndWriteOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndWriteOp> TYPE = LIRInstructionClass.create(AtomicReadAndWriteOp.class);
        private final AMD64Kind accessKind;
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.Use
        protected AllocatableValue newValue;

        public AtomicReadAndWriteOp(AMD64Kind accessKind, AllocatableValue result, AMD64AddressValue address, AllocatableValue newValue) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.accessKind = accessKind;
            this.result = result;
            this.address = address;
            this.newValue = newValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(this.accessKind, crb, masm, (Value)this.result, (Value)this.newValue);
            switch (this.accessKind) {
                case BYTE: {
                    masm.xchgb(ValueUtil.asRegister((Value)this.result), this.address.toAddress());
                    break;
                }
                case WORD: {
                    masm.xchgw(ValueUtil.asRegister((Value)this.result), this.address.toAddress());
                    break;
                }
                case DWORD: {
                    masm.xchgl(ValueUtil.asRegister((Value)this.result), this.address.toAddress());
                    break;
                }
                case QWORD: {
                    masm.xchgq(ValueUtil.asRegister((Value)this.result), this.address.toAddress());
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    @Opcode(value="ATOMIC_READ_AND_ADD")
    public static final class AtomicReadAndAddOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AtomicReadAndAddOp> TYPE = LIRInstructionClass.create(AtomicReadAndAddOp.class);
        private final AMD64Kind accessKind;
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.Use
        protected AllocatableValue delta;

        public AtomicReadAndAddOp(AMD64Kind accessKind, AllocatableValue result, AMD64AddressValue address, AllocatableValue delta) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.accessKind = accessKind;
            this.result = result;
            this.address = address;
            this.delta = delta;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(this.accessKind, crb, masm, (Value)this.result, (Value)this.delta);
            if (crb.target.isMP) {
                masm.lock();
            }
            switch (this.accessKind) {
                case BYTE: {
                    masm.xaddb(this.address.toAddress(), ValueUtil.asRegister((Value)this.result));
                    break;
                }
                case WORD: {
                    masm.xaddw(this.address.toAddress(), ValueUtil.asRegister((Value)this.result));
                    break;
                }
                case DWORD: {
                    masm.xaddl(this.address.toAddress(), ValueUtil.asRegister((Value)this.result));
                    break;
                }
                case QWORD: {
                    masm.xaddq(this.address.toAddress(), ValueUtil.asRegister((Value)this.result));
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    @Opcode(value="CAS")
    public static final class CompareAndSwapOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<CompareAndSwapOp> TYPE = LIRInstructionClass.create(CompareAndSwapOp.class);
        private final AMD64Kind accessKind;
        @LIRInstruction.Def
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.Use
        protected AllocatableValue cmpValue;
        @LIRInstruction.Use
        protected AllocatableValue newValue;

        public CompareAndSwapOp(AMD64Kind accessKind, AllocatableValue result, AMD64AddressValue address, AllocatableValue cmpValue, AllocatableValue newValue) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.accessKind = accessKind;
            this.result = result;
            this.address = address;
            this.cmpValue = cmpValue;
            this.newValue = newValue;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            assert (ValueUtil.asRegister((Value)this.cmpValue).equals((Object)AMD64.rax) && ValueUtil.asRegister((Value)this.result).equals((Object)AMD64.rax));
            if (crb.target.isMP) {
                masm.lock();
            }
            switch (this.accessKind) {
                case BYTE: {
                    masm.cmpxchgb(ValueUtil.asRegister((Value)this.newValue), this.address.toAddress());
                    break;
                }
                case WORD: {
                    masm.cmpxchgw(ValueUtil.asRegister((Value)this.newValue), this.address.toAddress());
                    break;
                }
                case DWORD: {
                    masm.cmpxchgl(ValueUtil.asRegister((Value)this.newValue), this.address.toAddress());
                    break;
                }
                case QWORD: {
                    masm.cmpxchgq(ValueUtil.asRegister((Value)this.newValue), this.address.toAddress());
                    break;
                }
                default: {
                    throw GraalError.shouldNotReachHere();
                }
            }
        }
    }

    public static final class NullCheckOp
    extends AMD64LIRInstruction
    implements StandardOp.NullCheck {
        public static final LIRInstructionClass<NullCheckOp> TYPE = LIRInstructionClass.create(NullCheckOp.class);
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE})
        protected AMD64AddressValue address;
        @LIRInstruction.State
        protected LIRFrameState state;

        public NullCheckOp(AMD64AddressValue address, LIRFrameState state) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.address = address;
            this.state = state;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            crb.recordImplicitException(masm.position(), this.state);
            masm.nullCheck(this.address.toAddress());
        }

        @Override
        public Value getCheckedValue() {
            return this.address.base;
        }

        @Override
        public LIRFrameState getState() {
            return this.state;
        }
    }

    public static final class MembarOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<MembarOp> TYPE = LIRInstructionClass.create(MembarOp.class);
        private final int barriers;

        public MembarOp(int barriers) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.barriers = barriers;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            masm.membar(this.barriers);
        }
    }

    public static final class StackLeaOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<StackLeaOp> TYPE = LIRInstructionClass.create(StackLeaOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        protected AllocatableValue slot;

        public StackLeaOp(AllocatableValue result, AllocatableValue slot) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.slot = slot;
            assert (slot instanceof VirtualStackSlot || slot instanceof StackSlot);
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            masm.leaq(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.QWORD), (AMD64Address)crb.asAddress((Value)this.slot));
        }
    }

    public static final class LeaDataOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<LeaDataOp> TYPE = LIRInstructionClass.create(LeaDataOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        private final DataPointerConstant data;

        public LeaDataOp(AllocatableValue result, DataPointerConstant data) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.data = data;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            masm.leaq(ValueUtil.asRegister((Value)this.result), (AMD64Address)crb.recordDataReferenceInCode(this.data));
        }
    }

    public static final class LeaOp
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<LeaOp> TYPE = LIRInstructionClass.create(LeaOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.COMPOSITE, LIRInstruction.OperandFlag.UNINITIALIZED})
        protected AMD64AddressValue address;
        private final AMD64BaseAssembler.OperandSize size;

        public LeaOp(AllocatableValue result, AMD64AddressValue address, AMD64BaseAssembler.OperandSize size) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.address = address;
            this.size = size;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (this.size == AMD64BaseAssembler.OperandSize.QWORD) {
                masm.leaq(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.QWORD), this.address.toAddress());
            } else {
                assert (this.size == AMD64BaseAssembler.OperandSize.DWORD);
                masm.lead(ValueUtil.asRegister((Value)this.result, (PlatformKind)AMD64Kind.DWORD), this.address.toAddress());
            }
        }
    }

    @Opcode(value="STACKMOVE")
    public static final class AMD64PushPopStackMove
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<AMD64PushPopStackMove> TYPE = LIRInstructionClass.create(AMD64PushPopStackMove.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;
        private final AMD64BaseAssembler.OperandSize size;

        public AMD64PushPopStackMove(AMD64BaseAssembler.OperandSize size, AllocatableValue result, AllocatableValue input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.size = size;
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Assembler.AMD64MOp.PUSH.emit((AMD64Assembler)masm, this.size, (AMD64Address)crb.asAddress((Value)this.input));
            AMD64Assembler.AMD64MOp.POP.emit((AMD64Assembler)masm, this.size, (AMD64Address)crb.asAddress((Value)this.result));
        }
    }

    @Opcode(value="MULTISTACKMOVE")
    public static final class AMD64MultiStackMove
    extends AMD64LIRInstruction {
        public static final LIRInstructionClass<AMD64MultiStackMove> TYPE = LIRInstructionClass.create(AMD64MultiStackMove.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue[] results;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK})
        protected Value[] inputs;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue backupSlot;
        private Register scratch;

        public AMD64MultiStackMove(AllocatableValue[] results, Value[] inputs, Register scratch, AllocatableValue backupSlot) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.results = results;
            this.inputs = inputs;
            this.backupSlot = backupSlot;
            this.scratch = scratch;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind backupKind = (AMD64Kind)this.backupSlot.getPlatformKind();
            if (backupKind.isXMM()) {
                backupKind = AMD64Kind.DOUBLE;
            }
            AMD64Move.move(backupKind, crb, masm, (Value)this.backupSlot, (Value)this.scratch.asValue(this.backupSlot.getValueKind()));
            for (int i = 0; i < this.results.length; ++i) {
                Value input = this.inputs[i];
                AllocatableValue result = this.results[i];
                AMD64Move.move((AMD64Kind)input.getPlatformKind(), crb, masm, (Value)this.scratch.asValue(input.getValueKind()), input);
                AMD64Move.move((AMD64Kind)result.getPlatformKind(), crb, masm, (Value)result, (Value)this.scratch.asValue(result.getValueKind()));
            }
            AMD64Move.move(backupKind, crb, masm, (Value)this.scratch.asValue(this.backupSlot.getValueKind()), (Value)this.backupSlot);
        }
    }

    @Opcode(value="STACKMOVE")
    public static final class AMD64StackMove
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<AMD64StackMove> TYPE = LIRInstructionClass.create(AMD64StackMove.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;
        @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.UNINITIALIZED})
        private AllocatableValue backupSlot;
        private Register scratch;

        public AMD64StackMove(AllocatableValue result, AllocatableValue input, Register scratch, AllocatableValue backupSlot) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
            this.backupSlot = backupSlot;
            this.scratch = scratch;
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }

        public Register getScratchRegister() {
            return this.scratch;
        }

        public AllocatableValue getBackupSlot() {
            return this.backupSlot;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Kind backupKind = (AMD64Kind)this.backupSlot.getPlatformKind();
            if (backupKind.isXMM()) {
                backupKind = AMD64Kind.DOUBLE;
            }
            AMD64Move.reg2stack(backupKind, crb, masm, (Value)this.backupSlot, this.scratch);
            AMD64Move.stack2reg((AMD64Kind)this.getInput().getPlatformKind(), crb, masm, this.scratch, (Value)this.getInput());
            AMD64Move.reg2stack((AMD64Kind)this.getResult().getPlatformKind(), crb, masm, (Value)this.getResult(), this.scratch);
            AMD64Move.stack2reg(backupKind, crb, masm, this.scratch, (Value)this.backupSlot);
        }
    }

    @Opcode(value="MOVE")
    public static class MoveFromConstOp
    extends AMD64LIRInstruction
    implements StandardOp.LoadConstantOp {
        public static final LIRInstructionClass<MoveFromConstOp> TYPE = LIRInstructionClass.create(MoveFromConstOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        private final JavaConstant input;

        public MoveFromConstOp(AllocatableValue result, JavaConstant input) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)TYPE);
            this.result = result;
            this.input = input;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            if (ValueUtil.isRegister((Value)this.result)) {
                AMD64Move.const2reg(crb, masm, ValueUtil.asRegister((Value)this.result), this.input, (AMD64Kind)this.result.getPlatformKind());
            } else {
                assert (ValueUtil.isStackSlot((Value)this.result));
                AMD64Move.const2stack(crb, masm, (Value)this.result, this.input);
            }
        }

        @Override
        public Constant getConstant() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="MOVE")
    public static final class MoveFromRegOp
    extends AbstractMoveOp {
        public static final LIRInstructionClass<MoveFromRegOp> TYPE = LIRInstructionClass.create(MoveFromRegOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue input;

        public MoveFromRegOp(AMD64Kind moveKind, AllocatableValue result, AllocatableValue input) {
            super(TYPE, moveKind);
            this.result = result;
            this.input = input;
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    @Opcode(value="MOVE")
    public static final class MoveToRegOp
    extends AbstractMoveOp {
        public static final LIRInstructionClass<MoveToRegOp> TYPE = LIRInstructionClass.create(MoveToRegOp.class);
        @LIRInstruction.Def(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK, LIRInstruction.OperandFlag.HINT})
        protected AllocatableValue result;
        @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG, LIRInstruction.OperandFlag.STACK})
        protected AllocatableValue input;

        public MoveToRegOp(AMD64Kind moveKind, AllocatableValue result, AllocatableValue input) {
            super(TYPE, moveKind);
            this.result = result;
            this.input = input;
        }

        @Override
        public AllocatableValue getInput() {
            return this.input;
        }

        @Override
        public AllocatableValue getResult() {
            return this.result;
        }
    }

    private static abstract class AbstractMoveOp
    extends AMD64LIRInstruction
    implements StandardOp.ValueMoveOp {
        public static final LIRInstructionClass<AbstractMoveOp> TYPE = LIRInstructionClass.create(AbstractMoveOp.class);
        private AMD64Kind moveKind;

        protected AbstractMoveOp(LIRInstructionClass<? extends AbstractMoveOp> c, AMD64Kind moveKind) {
            super((LIRInstructionClass<? extends AMD64LIRInstruction>)c);
            this.moveKind = moveKind;
        }

        @Override
        public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
            AMD64Move.move(this.moveKind, crb, masm, (Value)this.getResult(), (Value)this.getInput());
        }
    }
}

