/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.constopt;

import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.ValueProcedure;

class UseEntry {
    private final AbstractBlockBase<?> block;
    private final LIRInstruction instruction;
    private final Value value;

    UseEntry(AbstractBlockBase<?> block, LIRInstruction instruction, Value value) {
        this.block = block;
        this.instruction = instruction;
        this.value = value;
    }

    public LIRInstruction getInstruction() {
        return this.instruction;
    }

    public AbstractBlockBase<?> getBlock() {
        return this.block;
    }

    public void setValue(Value newValue) {
        UseEntry.replaceValue(this.instruction, this.value, newValue);
    }

    private static void replaceValue(LIRInstruction op, Value oldValue, Value newValue) {
        ValueProcedure proc = (value, mode, flags) -> value.identityEquals(oldValue) ? newValue : value;
        op.forEachAlive(proc);
        op.forEachInput(proc);
        op.forEachOutput(proc);
        op.forEachTemp(proc);
        op.forEachState(proc);
    }

    public Value getValue() {
        return this.value;
    }

    public String toString() {
        return "Use[" + this.getValue() + ":" + this.instruction + ":" + this.block + "]";
    }
}

