/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.gen;

import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerator;
import org.graalvm.compiler.options.OptionValues;

public abstract class ArithmeticLIRGenerator
implements ArithmeticLIRGeneratorTool {
    LIRGenerator lirGen;

    public LIRGenerator getLIRGen() {
        return this.lirGen;
    }

    protected final AllocatableValue asAllocatable(Value value) {
        return this.lirGen.asAllocatable(value);
    }

    public OptionValues getOptions() {
        return this.getLIRGen().getResult().getLIR().getOptions();
    }

    protected abstract boolean isNumericInteger(PlatformKind var1);

    protected abstract Variable emitAdd(LIRKind var1, Value var2, Value var3, boolean var4);

    protected abstract Variable emitSub(LIRKind var1, Value var2, Value var3, boolean var4);

    public final Variable emitAdd(Value aVal, Value bVal, boolean setFlags) {
        return this.emitAddOrSub(aVal, bVal, setFlags, true);
    }

    public final Variable emitSub(Value aVal, Value bVal, boolean setFlags) {
        return this.emitAddOrSub(aVal, bVal, setFlags, false);
    }

    private Variable emitAddOrSub(Value aVal, Value bVal, boolean setFlags, boolean isAdd) {
        LIRKind resultKind;
        Value a = aVal;
        Value b = bVal;
        if (this.isNumericInteger(a.getPlatformKind())) {
            LIRKind aKind = (LIRKind)a.getValueKind(LIRKind.class);
            LIRKind bKind = (LIRKind)b.getValueKind(LIRKind.class);
            assert (a.getPlatformKind() == b.getPlatformKind()) : a.getPlatformKind() + " vs. " + b.getPlatformKind();
            if (aKind.isUnknownReference()) {
                resultKind = aKind;
            } else if (bKind.isUnknownReference()) {
                resultKind = bKind;
            } else if (aKind.isValue() && bKind.isValue()) {
                resultKind = aKind;
            } else if (aKind.isValue()) {
                if (bKind.isDerivedReference()) {
                    resultKind = bKind;
                } else {
                    AllocatableValue allocatable = this.asAllocatable(b);
                    resultKind = bKind.makeDerivedReference(allocatable);
                    b = allocatable;
                }
            } else if (bKind.isValue()) {
                if (aKind.isDerivedReference()) {
                    resultKind = aKind;
                } else {
                    AllocatableValue allocatable = this.asAllocatable(a);
                    resultKind = aKind.makeDerivedReference(allocatable);
                    a = allocatable;
                }
            } else {
                resultKind = aKind.makeUnknownReference();
            }
        } else {
            resultKind = LIRKind.combine(a, b);
        }
        return isAdd ? this.emitAdd(resultKind, a, b, setFlags) : this.emitSub(resultKind, a, b, setFlags);
    }

    public Value emitRor(Value value, Value distance) {
        return this.emitOr(this.emitUShr(value, distance), this.emitShl(value, this.emitNegate(distance)));
    }
}

