/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.gen;

import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.FloatConvert;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.Variable;

public interface ArithmeticLIRGeneratorTool {
    public Value emitNegate(Value var1);

    public Value emitAdd(Value var1, Value var2, boolean var3);

    public Value emitSub(Value var1, Value var2, boolean var3);

    public Value emitMul(Value var1, Value var2, boolean var3);

    public Value emitMulHigh(Value var1, Value var2);

    public Value emitUMulHigh(Value var1, Value var2);

    public Value emitDiv(Value var1, Value var2, LIRFrameState var3);

    public Value emitRem(Value var1, Value var2, LIRFrameState var3);

    public Value emitUDiv(Value var1, Value var2, LIRFrameState var3);

    public Value emitURem(Value var1, Value var2, LIRFrameState var3);

    public Value emitNot(Value var1);

    public Value emitAnd(Value var1, Value var2);

    public Value emitOr(Value var1, Value var2);

    public Value emitXor(Value var1, Value var2);

    public Value emitXorFP(Value var1, Value var2);

    public Value emitShl(Value var1, Value var2);

    public Value emitShr(Value var1, Value var2);

    public Value emitUShr(Value var1, Value var2);

    public Value emitFloatConvert(FloatConvert var1, Value var2);

    public Value emitReinterpret(LIRKind var1, Value var2);

    public Value emitNarrow(Value var1, int var2);

    public Value emitSignExtend(Value var1, int var2, int var3);

    public Value emitZeroExtend(Value var1, int var2, int var3);

    public Value emitMathAbs(Value var1);

    public Value emitMathSqrt(Value var1);

    public Value emitMathSignum(Value var1);

    public Value emitMathCopySign(Value var1, Value var2);

    public Value emitBitCount(Value var1);

    public Value emitBitScanForward(Value var1);

    public Value emitBitScanReverse(Value var1);

    public Variable emitLoad(LIRKind var1, Value var2, LIRFrameState var3);

    public Variable emitVolatileLoad(LIRKind var1, Value var2, LIRFrameState var3);

    public void emitStore(ValueKind<?> var1, Value var2, Value var3, LIRFrameState var4);

    public void emitVolatileStore(ValueKind<?> var1, Value var2, Value var3, LIRFrameState var4);

    default public Value emitFusedMultiplyAdd(Value a, Value b, Value c) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathLog(Value input, boolean base10) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathCos(Value input) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathSin(Value input) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathTan(Value input) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathExp(Value input) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathPow(Value x, Value y) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathMax(Value x, Value y) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitMathMin(Value x, Value y) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    default public Value emitRound(Value operand, RoundingMode mode) {
        throw GraalError.unimplemented("No specialized implementation available");
    }

    public static enum RoundingMode {
        NEAREST(0),
        DOWN(1),
        UP(2),
        TRUNCATE(3);

        public final int encoding;

        private RoundingMode(int encoding) {
            this.encoding = encoding;
        }
    }
}

