/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.gen;

import jdk.vm.ci.code.CodeCacheProvider;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterConfig;
import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueKindFactory;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.spi.CodeGenProviders;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.gen.ArithmeticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;

public interface LIRGeneratorTool
extends DiagnosticLIRGeneratorTool,
ValueKindFactory<LIRKind> {
    public ArithmeticLIRGeneratorTool getArithmetic();

    public CodeGenProviders getProviders();

    public TargetDescription target();

    public MetaAccessProvider getMetaAccess();

    public CodeCacheProvider getCodeCache();

    public ForeignCallsProvider getForeignCalls();

    public AbstractBlockBase<?> getCurrentBlock();

    public LIRGenerationResult getResult();

    public RegisterConfig getRegisterConfig();

    public MoveFactory getMoveFactory();

    public MoveFactory getSpillMoveFactory();

    public boolean canInlineConstant(Constant var1);

    public boolean mayEmbedConstantLoad(Constant var1);

    public Value emitConstant(LIRKind var1, Constant var2);

    public Value emitJavaConstant(JavaConstant var1);

    public <K extends ValueKind<K>> K toRegisterKind(K var1);

    public AllocatableValue emitLoadConstant(ValueKind<?> var1, Constant var2);

    public void emitNullCheck(Value var1, LIRFrameState var2);

    public Variable emitLogicCompareAndSwap(LIRKind var1, Value var2, Value var3, Value var4, Value var5, Value var6, MemoryOrderMode var7);

    public Value emitValueCompareAndSwap(LIRKind var1, Value var2, Value var3, Value var4, MemoryOrderMode var5);

    default public Value emitAtomicReadAndAdd(Value address, ValueKind<?> valueKind, Value delta) {
        throw GraalError.unimplemented();
    }

    default public Value emitAtomicReadAndWrite(Value address, ValueKind<?> valueKind, Value newValue) {
        throw GraalError.unimplemented();
    }

    public void emitDeoptimize(Value var1, Value var2, LIRFrameState var3);

    public Variable emitForeignCall(ForeignCallLinkage var1, LIRFrameState var2, Value ... var3);

    public Variable newVariable(ValueKind<?> var1);

    public Variable emitMove(Value var1);

    public void emitMove(AllocatableValue var1, Value var2);

    public Variable emitReadRegister(Register var1, ValueKind<?> var2);

    public void emitWriteRegister(Register var1, Value var2, ValueKind<?> var3);

    public void emitMoveConstant(AllocatableValue var1, Constant var2);

    public Variable emitAddress(AllocatableValue var1);

    public void emitMembar(int var1);

    public void emitUnwind(Value var1);

    public void emitReturn(JavaKind var1, Value var2);

    public AllocatableValue asAllocatable(Value var1);

    public Variable load(Value var1);

    public <I extends LIRInstruction> I append(I var1);

    public void emitJump(LabelRef var1);

    public Variable emitConditionalMove(PlatformKind var1, Value var2, Value var3, Condition var4, boolean var5, Value var6, Value var7);

    public Variable emitIntegerTestMove(Value var1, Value var2, Value var3, Value var4);

    public Variable emitByteSwap(Value var1);

    default public Variable emitArrayCompareTo(JavaKind kind1, JavaKind kind2, int array1BaseOffset, int array2BaseOffset, Value array1, Value array2, Value length1, Value length2) {
        throw GraalError.unimplemented("String.compareTo substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEquals(JavaKind kind, int array1BaseOffset, int array2BaseOffset, Value array1, Value array2, Value length, boolean directPointers) {
        throw GraalError.unimplemented("Array.equals substitution is not implemented on this architecture");
    }

    default public Variable emitArrayEquals(JavaKind kind1, JavaKind kind2, int array1BaseOffset, int array2BaseOffset, Value array1, Value array2, Value length, boolean directPointers) {
        throw GraalError.unimplemented("Array.equals with different types substitution is not implemented on this architecture");
    }

    default public Variable emitArrayIndexOf(int arrayBaseOffset, JavaKind valueKind, boolean findTwoConsecutive, Value sourcePointer, Value sourceCount, Value fromIndex, Value ... searchValues) {
        throw GraalError.unimplemented("String.indexOf substitution is not implemented on this architecture");
    }

    default public void emitStringLatin1Inflate(Value src, Value dst, Value len) {
        throw GraalError.unimplemented("StringLatin1.inflate substitution is not implemented on this architecture");
    }

    default public Variable emitStringUTF16Compress(Value src, Value dst, Value len) {
        throw GraalError.unimplemented("StringUTF16.compress substitution is not implemented on this architecture");
    }

    public void emitBlackhole(Value var1);

    public LIRKind getLIRKind(Stamp var1);

    public void emitPause();

    public void emitPrefetchAllocate(Value var1);

    public Value emitCompress(Value var1, CompressEncoding var2, boolean var3);

    public Value emitUncompress(Value var1, CompressEncoding var2, boolean var3);

    default public void emitConvertNullToZero(AllocatableValue result, Value input) {
        this.emitMove(result, input);
    }

    default public void emitConvertZeroToNull(AllocatableValue result, Value input) {
        this.emitMove(result, input);
    }

    public void emitSpeculationFence();

    default public VirtualStackSlot allocateStackMemory(int sizeInBytes, int alignmentInBytes) {
        return this.getResult().getFrameMapBuilder().allocateStackMemory(sizeInBytes, alignmentInBytes);
    }

    default public Value emitTimeStampWithProcid() {
        throw new GraalError("Emitting code to return the current value of the timestamp counter with procid is not currently supported on %s", this.target().arch);
    }

    default public Value emitReadCallerStackPointer(Stamp wordStamp) {
        return this.emitAddress((AllocatableValue)StackSlot.get((ValueKind)this.getLIRKind(wordStamp), (int)0, (boolean)true));
    }

    default public Value emitReadReturnAddress(Stamp wordStamp, int returnAddressSize) {
        return this.emitMove((Value)StackSlot.get((ValueKind)this.getLIRKind(wordStamp), (int)(-returnAddressSize), (boolean)true));
    }

    default public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        throw GraalError.unimplemented("Bulk zeroing is not implemented on this architecture");
    }

    public void emitCacheWriteback(Value var1);

    public void emitCacheWritebackSync(boolean var1);

    public static abstract class BlockScope
    implements AutoCloseable {
        public abstract AbstractBlockBase<?> getCurrentBlock();

        @Override
        public abstract void close();
    }

    public static interface MoveFactory {
        default public boolean mayEmbedConstantLoad(Constant constant) {
            return false;
        }

        public boolean canInlineConstant(Constant var1);

        public boolean allowConstantToStackMove(Constant var1);

        public LIRInstruction createMove(AllocatableValue var1, Value var2);

        public LIRInstruction createStackMove(AllocatableValue var1, AllocatableValue var2);

        public LIRInstruction createLoad(AllocatableValue var1, Constant var2);

        public LIRInstruction createStackLoad(AllocatableValue var1, Constant var2);
    }
}

