/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.phases;

import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.lir.alloc.AllocationStageVerifier;
import org.graalvm.compiler.lir.alloc.lsra.LinearScanPhase;
import org.graalvm.compiler.lir.dfa.MarkBasePointersPhase;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.phases.LIRPhaseSuite;
import org.graalvm.compiler.lir.stackslotalloc.LSStackSlotAllocator;
import org.graalvm.compiler.lir.stackslotalloc.SimpleStackSlotAllocator;
import org.graalvm.compiler.options.OptionValues;

public class AllocationStage
extends LIRPhaseSuite<AllocationPhase.AllocationContext> {
    public AllocationStage(OptionValues options) {
        this.appendPhase(new MarkBasePointersPhase());
        this.appendPhase(new LinearScanPhase());
        if (LSStackSlotAllocator.Options.LIROptLSStackSlotAllocator.getValue(options).booleanValue()) {
            this.appendPhase(new LSStackSlotAllocator());
        } else {
            this.appendPhase(new SimpleStackSlotAllocator());
        }
        if (Assertions.detailedAssertionsEnabled(options)) {
            this.appendPhase(new AllocationStageVerifier());
        }
    }
}

