/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.loop.phases;

import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.ControlFlowGraph;
import org.graalvm.compiler.nodes.extended.ForeignCall;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.LoopsData;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.compiler.phases.BasePhase;
import org.graalvm.compiler.phases.tiers.MidTierContext;

public class LoopSafepointEliminationPhase
extends BasePhase<MidTierContext> {
    private static final long IntegerRangeDistance = Math.abs(0xFFFFFFFFL);

    private static boolean iterationRangeIsIn32Bit(LoopEx loop) {
        if (loop.counted().getStamp().getBits() <= 32) {
            return true;
        }
        Stamp limitStamp = loop.counted().getTripCountLimit().stamp(NodeView.DEFAULT);
        if (limitStamp instanceof IntegerStamp) {
            IntegerStamp limitIStamp = (IntegerStamp)limitStamp;
            long upperBoundLimit = limitIStamp.upperBound();
            Stamp startStamp = loop.counted().getBodyIVStart().stamp(NodeView.DEFAULT);
            if (startStamp instanceof IntegerStamp) {
                IntegerStamp startIStamp = (IntegerStamp)startStamp;
                long lowerBoundStart = startIStamp.lowerBound();
                if (IntegerStamp.subtractionOverflows(upperBoundLimit, lowerBoundStart, 64)) {
                    return false;
                }
                long startToLimitDistance = Math.abs(upperBoundLimit - lowerBoundStart);
                return startToLimitDistance <= IntegerRangeDistance;
            }
        }
        return false;
    }

    @Override
    protected void run(StructuredGraph graph, MidTierContext context) {
        new Instance(graph, context).optimizeSafepoints();
    }

    public static boolean canDisableSafepoint(FixedNode node, CoreProviders context) {
        if (node instanceof Invoke) {
            Invoke invoke = (Invoke)((Object)node);
            ResolvedJavaMethod method = invoke.getTargetMethod();
            return context.getMetaAccessExtensionProvider().isGuaranteedSafepoint(method, invoke.getInvokeKind().isDirect());
        }
        if (node instanceof ForeignCall) {
            return ((ForeignCall)((Object)node)).isGuaranteedSafepoint();
        }
        return false;
    }

    protected static class Instance {
        private final StructuredGraph graph;
        private final MidTierContext context;

        protected Instance(StructuredGraph graph, MidTierContext context) {
            this.graph = graph;
            this.context = context;
        }

        private int disableSafepointsByBodyNodes(LoopEx loop, ControlFlowGraph cfg) {
            int loopEndSafepointsDisabled = 0;
            block0: for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                for (Block b = cfg.blockFor(loopEnd); b != loop.loop().getHeader(); b = (Block)b.getDominator()) {
                    assert (b != null);
                    for (FixedNode node : b.getNodes()) {
                        boolean canDisableSafepoint = LoopSafepointEliminationPhase.canDisableSafepoint(node, this.context);
                        boolean disabledInSubclass = this.onCallInLoop(loopEnd, node);
                        if (!canDisableSafepoint) continue;
                        loopEnd.disableSafepoint();
                        ++loopEndSafepointsDisabled;
                        if (!disabledInSubclass) continue;
                        continue block0;
                    }
                }
            }
            return loopEndSafepointsDisabled;
        }

        public void optimizeSafepoints() {
            boolean optimisticallyRemoveLoopSafepoints = Options.RemoveLoopSafepoints.getValue(this.graph.getOptions());
            LoopsData loops = this.context.getLoopsDataProvider().getLoopsData(this.graph);
            loops.detectedCountedLoops();
            for (LoopEx loop : loops.loops()) {
                boolean allLoopEndSafepointsEnabled;
                int loopEndSafepointsDisabled;
                boolean allLoopEndSafepointsDisabled;
                if (!this.allowGuestSafepoints()) {
                    loop.loopBegin().disableGuestSafepoint(LoopBeginNode.SafepointState.MUST_NEVER_SAFEPOINT);
                }
                boolean bl = allLoopEndSafepointsDisabled = (loopEndSafepointsDisabled = this.disableSafepointsByBodyNodes(loop, loops.getCFG())) == loop.loopBegin().getLoopEndCount();
                if (!allLoopEndSafepointsDisabled && optimisticallyRemoveLoopSafepoints && this.optimizeSafepointsForCountedLoop(loop)) {
                    loopEndSafepointsDisabled = loop.loopBegin().getLoopEndCount();
                }
                if (!(allLoopEndSafepointsEnabled = loopEndSafepointsDisabled == 0)) continue;
                loop.loopBegin().disableLoopExitSafepoint(LoopBeginNode.SafepointState.OPTIMIZER_DISABLED);
            }
            loops.deleteUnusedNodes();
        }

        protected boolean allowGuestSafepoints() {
            return false;
        }

        protected boolean onCallInLoop(LoopEndNode loopEnd, FixedNode currentCallNode) {
            return true;
        }

        protected void onSafepointDisabledLoopBegin(LoopEx loop) {
        }

        private boolean optimizeSafepointsForCountedLoop(LoopEx loop) {
            if (loop.isCounted() && loop.loop().getChildren().isEmpty() && (loop.loopBegin().isPreLoop() || loop.loopBegin().isPostLoop() || this.loopIsIn32BitRange(loop) || loop.loopBegin().isStripMinedInner())) {
                boolean hasSafepoint = false;
                for (LoopEndNode loopEnd : loop.loopBegin().loopEnds()) {
                    hasSafepoint |= loopEnd.canSafepoint();
                }
                if (hasSafepoint) {
                    if (!loop.counted().counterNeverOverflows()) {
                        boolean allowsLoopLimitChecks = this.context.getOptimisticOptimizations().useLoopLimitChecks(this.graph.getOptions());
                        boolean allowsFloatingGuards = this.graph.getGuardsStage().allowsFloatingGuards();
                        if (allowsLoopLimitChecks && allowsFloatingGuards) {
                            loop.counted().createOverFlowGuard();
                        } else {
                            return false;
                        }
                    }
                    loop.loopBegin().disableSafepoint(LoopBeginNode.SafepointState.OPTIMIZER_DISABLED);
                    if (loop.loopBegin().isStripMinedInner()) {
                        loop.loopBegin().disableGuestSafepoint(LoopBeginNode.SafepointState.OPTIMIZER_DISABLED);
                    } else {
                        this.onSafepointDisabledLoopBegin(loop);
                    }
                    return true;
                }
            }
            return false;
        }

        public boolean loopIsIn32BitRange(LoopEx loop) {
            return LoopSafepointEliminationPhase.iterationRangeIsIn32Bit(loop);
        }
    }

    public static class Options {
        @Option(help={"Removes safepoints on counted loop ends."}, type=OptionType.Expert)
        public static final OptionKey<Boolean> RemoveLoopSafepoints = new OptionKey<Boolean>(true);
    }
}

