/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class BeginNode
extends AbstractBeginNode
implements Simplifiable {
    public static final NodeClass<BeginNode> TYPE = NodeClass.create(BeginNode.class);

    public BeginNode() {
        super((NodeClass<? extends AbstractBeginNode>)TYPE, StampFactory.forVoid());
    }

    public BeginNode(Stamp stamp) {
        super((NodeClass<? extends AbstractBeginNode>)TYPE, stamp);
    }

    public void trySimplify() {
        FixedNode prev = (FixedNode)this.predecessor();
        if (!(prev instanceof ControlSplitNode)) {
            this.prepareDelete();
            this.graph().removeFixed(this);
        }
    }

    @Override
    public void simplify(SimplifierTool tool) {
        FixedNode prev = (FixedNode)this.predecessor();
        if (prev != null && !(prev instanceof ControlSplitNode)) {
            this.prepareDelete();
            tool.addToWorkList(this.next());
            this.graph().removeFixed(this);
        }
    }

    public static AbstractBeginNode begin(FixedNode with) {
        try (DebugCloseable position = with.withNodeSourcePosition();){
            if (with instanceof AbstractBeginNode) {
                AbstractBeginNode abstractBeginNode = (AbstractBeginNode)with;
                return abstractBeginNode;
            }
            BeginNode begin = with.graph().add(new BeginNode());
            begin.setNext(with);
            BeginNode beginNode = begin;
            return beginNode;
        }
    }
}

