/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class KillingBeginNode
extends AbstractBeginNode
implements SingleMemoryKill,
Simplifiable {
    public static final NodeClass<KillingBeginNode> TYPE = NodeClass.create(KillingBeginNode.class);
    protected LocationIdentity locationIdentity;

    public KillingBeginNode(LocationIdentity locationIdentity) {
        super((NodeClass<? extends AbstractBeginNode>)TYPE);
        this.locationIdentity = locationIdentity;
    }

    public static AbstractBeginNode begin(FixedNode with, LocationIdentity locationIdentity) {
        if (with instanceof KillingBeginNode) {
            return (KillingBeginNode)with;
        }
        AbstractBeginNode begin = with.graph().add(KillingBeginNode.create(locationIdentity));
        begin.setNext(with);
        return begin;
    }

    public static AbstractBeginNode create(LocationIdentity locationIdentity) {
        return new KillingBeginNode(locationIdentity);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.predecessor() instanceof FixedWithNextNode && this.predecessor() instanceof SingleMemoryKill) {
            SingleMemoryKill predecessor = (SingleMemoryKill)((Object)this.predecessor());
            if (this.getKilledLocationIdentity().equals(predecessor.getKilledLocationIdentity())) {
                tool.addToWorkList(this.next());
                this.graph().removeFixed(this);
            }
        }
    }

    @Override
    public void prepareDelete() {
        GraalError.guarantee(this.predecessor() instanceof SingleMemoryKill, "Cannot delete %s as its predecessor %s is not a SingleMemoryKill", (Object)this, (Object)this.predecessor());
        GraalError.guarantee(this.getKilledLocationIdentity().equals(((SingleMemoryKill)((Object)this.predecessor())).getKilledLocationIdentity()), "Cannot delete %s as its predecessor %s kills a different location (%s vs. %s)", (Object)this, (Object)this.predecessor(), (Object)this.getKilledLocationIdentity(), (Object)((SingleMemoryKill)((Object)this.predecessor())).getKilledLocationIdentity());
        if (this.hasUsages()) {
            this.replaceAtUsages(this.predecessor(), InputType.Memory);
        }
        super.prepareDelete();
    }
}

