/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.ProfileData;
import org.graalvm.compiler.nodes.ShortCircuitOrNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.calc.FloatingNode;

@NodeInfo(allowedUsageTypes={InputType.Condition}, size=NodeSize.SIZE_1)
public abstract class LogicNode
extends FloatingNode
implements Node.IndirectCanonicalization {
    public static final NodeClass<LogicNode> TYPE = NodeClass.create(LogicNode.class);

    public LogicNode(NodeClass<? extends LogicNode> c) {
        super((NodeClass<? extends FloatingNode>)c, StampFactory.forVoid());
    }

    public static LogicNode and(LogicNode a, LogicNode b, ProfileData.BranchProbabilityData shortCircuitProbability) {
        return LogicNode.and(a, false, b, false, shortCircuitProbability);
    }

    public static LogicNode and(LogicNode a, boolean negateA, LogicNode b, boolean negateB, ProfileData.BranchProbabilityData shortCircuitProbability) {
        StructuredGraph graph = a.graph();
        ShortCircuitOrNode notAorNotB = graph.unique(new ShortCircuitOrNode(a, !negateA, b, !negateB, shortCircuitProbability));
        return graph.unique(new LogicNegationNode(notAorNotB));
    }

    public static LogicNode or(LogicNode a, LogicNode b, ProfileData.BranchProbabilityData shortCircuitProbability) {
        return LogicNode.or(a, false, b, false, shortCircuitProbability);
    }

    public static LogicNode or(LogicNode a, boolean negateA, LogicNode b, boolean negateB, ProfileData.BranchProbabilityData shortCircuitProbability) {
        return a.graph().unique(new ShortCircuitOrNode(a, negateA, b, negateB, shortCircuitProbability));
    }

    public final boolean isTautology() {
        if (this instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)this;
            return logicConstantNode.getValue();
        }
        return false;
    }

    public final boolean isContradiction() {
        if (this instanceof LogicConstantNode) {
            LogicConstantNode logicConstantNode = (LogicConstantNode)this;
            return !logicConstantNode.getValue();
        }
        return false;
    }

    public TriState implies(boolean thisNegated, LogicNode other) {
        if (this == other) {
            return TriState.get((!thisNegated ? 1 : 0) != 0);
        }
        if (other instanceof LogicNegationNode) {
            return LogicNode.flip(this.implies(thisNegated, ((LogicNegationNode)other).getValue()));
        }
        return TriState.UNKNOWN;
    }

    private static TriState flip(TriState triState) {
        return triState.isUnknown() ? triState : TriState.get((!triState.toBoolean() ? 1 : 0) != 0);
    }
}

