/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Collections;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(cycles=NodeCycles.CYCLES_1, cyclesRationale="Backedge jmp", size=NodeSize.SIZE_1, sizeRationale="Backedge jmp")
public final class LoopEndNode
extends AbstractEndNode {
    public static final NodeClass<LoopEndNode> TYPE = NodeClass.create(LoopEndNode.class);
    @Node.Input(value=InputType.Association)
    AbstractBeginNode loopBegin;
    protected int endIndex;
    boolean canSafepoint;
    boolean canGuestSafepoint;

    public LoopEndNode(LoopBeginNode begin) {
        super((NodeClass<? extends AbstractEndNode>)TYPE);
        int idx = begin.nextEndIndex();
        assert (idx >= 0);
        this.endIndex = idx;
        this.loopBegin = begin;
        this.canSafepoint = begin.canEndsSafepoint();
        this.canGuestSafepoint = begin.canEndsGuestSafepoint();
    }

    @Override
    public AbstractMergeNode merge() {
        return this.loopBegin();
    }

    public LoopBeginNode loopBegin() {
        return (LoopBeginNode)this.loopBegin;
    }

    public void setLoopBegin(LoopBeginNode x) {
        this.updateUsages(this.loopBegin, x);
        this.loopBegin = x;
    }

    public void disableSafepoint() {
        this.canSafepoint = false;
    }

    public void disableGuestSafepoint() {
        this.canGuestSafepoint = false;
    }

    public boolean canGuestSafepoint() {
        assert (!this.canGuestSafepoint || this.loopBegin().canEndsGuestSafepoint()) : "When safepoints are disabled for loop begin, safepoints must be disabled for all loop ends";
        return this.canGuestSafepoint;
    }

    public boolean canSafepoint() {
        assert (!this.canSafepoint || this.loopBegin().canEndsSafepoint()) : "When safepoints are disabled for loop begin, safepoints must be disabled for all loop ends";
        return this.canSafepoint;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.visitLoopEnd(this);
        super.generate(gen);
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.loopBegin != null, "must have a loop begin", new Object[0]);
        this.assertTrue(this.hasNoUsages(), "LoopEnds can not be used", new Object[0]);
        return super.verify();
    }

    int endIndex() {
        return this.endIndex;
    }

    void setEndIndex(int idx) {
        this.endIndex = idx;
    }

    @Override
    public Iterable<? extends Node> cfgSuccessors() {
        return Collections.emptyList();
    }

    @Override
    public NodeCycles estimatedNodeCycles() {
        if (!(this.loopBegin instanceof LoopBeginNode) || this.loopBegin() == null) {
            return NodeCycles.CYCLES_UNKNOWN;
        }
        if (this.canSafepoint()) {
            return NodeCycles.CYCLES_2;
        }
        return super.estimatedNodeCycles();
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        if (!(this.loopBegin instanceof LoopBeginNode)) {
            return NodeSize.SIZE_UNKNOWN;
        }
        if (this.canSafepoint()) {
            return NodeSize.SIZE_2;
        }
        return super.dynamicNodeSizeEstimate();
    }
}

