/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ProxyNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.MemoryKill;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, nameTemplate="MemoryProxy({i#value})")
public final class MemoryProxyNode
extends ProxyNode
implements SingleMemoryKill {
    public static final NodeClass<MemoryProxyNode> TYPE = NodeClass.create(MemoryProxyNode.class);
    @Node.OptionalInput(value=InputType.Memory)
    MemoryKill value;
    protected final LocationIdentity locationIdentity;

    public MemoryProxyNode(MemoryKill value, LoopExitNode proxyPoint, LocationIdentity locationIdentity) {
        super(TYPE, StampFactory.forVoid(), proxyPoint);
        this.value = value;
        this.locationIdentity = locationIdentity;
    }

    public void setValue(MemoryKill newValue) {
        this.updateUsages(this.value.asNode(), newValue.asNode());
        this.value = newValue;
    }

    @Override
    public ValueNode value() {
        return this.value == null ? null : this.value.asNode();
    }

    @Override
    public PhiNode createPhi(AbstractMergeNode merge) {
        return this.graph().addWithoutUnique(new MemoryPhiNode(merge, this.locationIdentity));
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public ProxyNode duplicateOn(LoopExitNode newProxyPoint, ValueNode newOriginalNode) {
        assert (newOriginalNode instanceof MemoryKill);
        return this.graph().addWithoutUniqueWithInputs(new MemoryProxyNode((MemoryKill)((Object)newOriginalNode), newProxyPoint, this.getKilledLocationIdentity()));
    }
}

