/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.Arrays;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.memory.MultiMemoryKill;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public final class MultiKillingBeginNode
extends AbstractBeginNode
implements MultiMemoryKill,
Simplifiable {
    public static final NodeClass<MultiKillingBeginNode> TYPE = NodeClass.create(MultiKillingBeginNode.class);
    protected LocationIdentity[] locationIdentities;

    public MultiKillingBeginNode(LocationIdentity[] locationIdentities) {
        super((NodeClass<? extends AbstractBeginNode>)TYPE);
        this.locationIdentities = locationIdentities;
    }

    public static AbstractBeginNode begin(FixedNode with, LocationIdentity[] locationIdentities) {
        if (with instanceof MultiKillingBeginNode) {
            return (MultiKillingBeginNode)with;
        }
        AbstractBeginNode begin = with.graph().add(MultiKillingBeginNode.create(locationIdentities));
        begin.setNext(with);
        return begin;
    }

    public static AbstractBeginNode create(LocationIdentity[] locationIdentities) {
        return new MultiKillingBeginNode(locationIdentities);
    }

    @Override
    public LocationIdentity[] getKilledLocationIdentities() {
        return this.locationIdentities;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (this.predecessor() instanceof FixedWithNextNode && this.predecessor() instanceof MultiMemoryKill) {
            MultiMemoryKill predecessor = (MultiMemoryKill)((Object)this.predecessor());
            if (Arrays.equals(this.getKilledLocationIdentities(), predecessor.getKilledLocationIdentities())) {
                tool.addToWorkList(this.next());
                this.graph().removeFixed(this);
            }
        }
    }

    @Override
    public void prepareDelete() {
        GraalError.guarantee(this.predecessor() instanceof MultiMemoryKill, "Cannot delete %s as its predecessor %s is not a MultiMemoryKill", (Object)this, (Object)this.predecessor());
        GraalError.guarantee(Arrays.equals(this.getKilledLocationIdentities(), ((MultiMemoryKill)((Object)this.predecessor())).getKilledLocationIdentities()), "Cannot delete %s as its predecessor %s kills a different locations", (Object)this, (Object)this.predecessor());
        if (this.hasUsages()) {
            this.replaceAtUsages(this.predecessor(), InputType.Memory);
        }
        super.prepareDelete();
    }
}

