/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.List;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.core.common.type.TypeReference;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FloatingGuardedNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.GuardingNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.memory.ReadNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.spi.ValueProxy;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;

@NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
@Node.NodeIntrinsicFactory
public class PiNode
extends FloatingGuardedNode
implements LIRLowerable,
Virtualizable,
Canonicalizable,
ValueProxy {
    public static final NodeClass<PiNode> TYPE = NodeClass.create(PiNode.class);
    @Node.Input
    ValueNode object;
    protected Stamp piStamp;

    public ValueNode object() {
        return this.object;
    }

    protected PiNode(NodeClass<? extends PiNode> c, ValueNode object, Stamp stamp, GuardingNode guard) {
        super(c, stamp, guard);
        this.object = object;
        this.piStamp = stamp;
        assert (this.piStamp.isCompatible(object.stamp(NodeView.DEFAULT))) : "Object stamp not compatible to piStamp";
        this.inferStamp();
    }

    public PiNode(ValueNode object, Stamp stamp) {
        this(object, stamp, null);
    }

    public PiNode(ValueNode object, Stamp stamp, ValueNode guard) {
        this(TYPE, object, stamp, (GuardingNode)((Object)guard));
    }

    public PiNode(ValueNode object, ValueNode guard) {
        this(object, AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT)), guard);
    }

    public PiNode(ValueNode object, ResolvedJavaType toType, boolean exactType, boolean nonNull) {
        this(object, (Stamp)StampFactory.object(exactType ? TypeReference.createExactTrusted(toType) : TypeReference.createWithoutAssumptions(toType), nonNull || StampTool.isPointerNonNull(object.stamp(NodeView.DEFAULT))));
    }

    public static ValueNode create(ValueNode object, Stamp stamp) {
        ValueNode value = PiNode.canonical(object, stamp, null, null);
        if (value != null) {
            return value;
        }
        return new PiNode(object, stamp);
    }

    public static ValueNode create(ValueNode object, Stamp stamp, ValueNode guard) {
        ValueNode value = PiNode.canonical(object, stamp, (GuardingNode)((Object)guard), null);
        if (value != null) {
            return value;
        }
        return new PiNode(object, stamp, guard);
    }

    public static ValueNode create(ValueNode object, ValueNode guard) {
        Stamp stamp = AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT));
        ValueNode value = PiNode.canonical(object, stamp, (GuardingNode)((Object)guard), null);
        if (value != null) {
            return value;
        }
        return new PiNode(object, stamp, guard);
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode object, ValueNode guard) {
        Stamp stamp = AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT));
        ValueNode value = PiNode.canonical(object, stamp, (GuardingNode)((Object)guard), null);
        if (value == null) {
            value = new PiNode(object, stamp, guard);
        }
        b.push(JavaKind.Object, b.append(value));
        return true;
    }

    public static boolean intrinsify(GraphBuilderContext b, ValueNode object, ResolvedJavaType toType, boolean exactType, boolean nonNull) {
        ObjectStamp stamp = StampFactory.object(exactType ? TypeReference.createExactTrusted(toType) : TypeReference.createWithoutAssumptions(toType), nonNull || StampTool.isPointerNonNull(object.stamp(NodeView.DEFAULT)));
        ValueNode value = PiNode.canonical(object, stamp, null, null);
        if (value == null) {
            value = new PiNode(object, (Stamp)stamp);
        }
        b.push(JavaKind.Object, b.append(value));
        return true;
    }

    public final Stamp piStamp() {
        return this.piStamp;
    }

    public void strengthenPiStamp(Stamp newPiStamp) {
        assert (this.piStamp.join(newPiStamp).equals(newPiStamp)) : "stamp can only improve";
        this.piStamp = newPiStamp;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
        if (generator.hasOperand(this.object)) {
            generator.setResult(this, generator.operand(this.object));
        }
    }

    @Override
    public boolean inferStamp() {
        return this.updateStamp(this.computeStamp());
    }

    private Stamp computeStamp() {
        return this.piStamp.improveWith(this.object().stamp(NodeView.DEFAULT));
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode alias = tool.getAlias(this.object());
        if (alias instanceof VirtualObjectNode) {
            VirtualObjectNode virtual = (VirtualObjectNode)alias;
            ResolvedJavaType type = StampTool.typeOrNull(this, tool.getMetaAccess());
            if (type != null && type.isAssignableFrom(virtual.type())) {
                tool.replaceWithVirtual(virtual);
            } else {
                tool.getDebug().log(2, "could not virtualize Pi because of type mismatch: %s %s vs %s", (Object)this, (Object)type, (Object)virtual.type());
            }
        }
    }

    public static ValueNode canonical(ValueNode object, Stamp piStamp, GuardingNode guard, PiNode self) {
        Stamp computedStamp = piStamp.improveWith(object.stamp(NodeView.DEFAULT));
        if (computedStamp.equals(object.stamp(NodeView.DEFAULT))) {
            return object;
        }
        if (guard == null) {
            if (object instanceof ReadNode && !object.hasMoreThanOneUsage()) {
                ReadNode readNode = (ReadNode)object;
                readNode.setStamp(readNode.stamp(NodeView.DEFAULT).improveWith(piStamp));
                return readNode;
            }
        } else {
            for (Node n : guard.asNode().usages()) {
                Stamp joinedStamp;
                if (!(n instanceof PiNode) || n == self) continue;
                PiNode otherPi = (PiNode)n;
                assert (otherPi.guard == guard);
                if (otherPi.object() != self && otherPi.object() != object || (joinedStamp = piStamp.improveWith(otherPi.piStamp())).equals(piStamp)) continue;
                if (otherPi.object() == object && joinedStamp.equals(otherPi.piStamp())) {
                    return otherPi;
                }
                return new PiNode(object, joinedStamp, guard.asNode());
            }
        }
        return null;
    }

    @Override
    public Node canonical(CanonicalizerTool tool) {
        ValueNode value = PiNode.canonical(this.object(), this.piStamp(), this.getGuard(), this);
        if (value != null) {
            return value;
        }
        return this;
    }

    public static void tryEvacuate(SimplifierTool tool, GuardingNode guard) {
        PiNode.tryEvacuate(tool, guard, true);
    }

    private static void tryEvacuate(SimplifierTool tool, GuardingNode guard, boolean recurse) {
        ValueNode guardNode = guard.asNode();
        if (guardNode.hasNoUsages()) {
            return;
        }
        List<PiNode> pis = guardNode.usages().filter(PiNode.class).snapshot();
        for (PiNode pi : pis) {
            Node canonical;
            GuardingNode otherGuard;
            if (!pi.isAlive()) continue;
            if (pi.hasNoUsages()) {
                pi.safeDelete();
                continue;
            }
            if (recurse && pi.getOriginalNode() instanceof PiNode && (otherGuard = ((PiNode)pi.getOriginalNode()).guard) != null) {
                PiNode.tryEvacuate(tool, otherGuard, false);
            }
            if (!pi.isAlive() || (canonical = pi.canonical(tool)) == pi) continue;
            if (!canonical.isAlive()) {
                canonical = guardNode.graph().addOrUniqueWithInputs(canonical);
            }
            pi.replaceAtUsages(canonical);
            pi.safeDelete();
        }
    }

    @Override
    public ValueNode getOriginalNode() {
        return this.object;
    }

    public void setOriginalNode(ValueNode newNode) {
        this.updateUsages(this.object, newNode);
        this.object = newNode;
        assert (this.piStamp.isCompatible(this.object.stamp(NodeView.DEFAULT))) : "New object stamp not compatible to piStamp";
    }

    public static Class<?> asNonNullClass(Object object) {
        return PiNode.asNonNullClassIntrinsic(object, Class.class, true, true);
    }

    public static Class<?> asNonNullObject(Object object) {
        return PiNode.asNonNullClassIntrinsic(object, Object.class, false, true);
    }

    @Node.NodeIntrinsic(value=PiNode.class)
    private static native Class<?> asNonNullClassIntrinsic(Object var0, @Node.ConstantNodeParameter Class<?> var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3);

    @Node.NodeIntrinsic(value=Placeholder.class)
    public static native Object piCastToSnippetReplaceeStamp(Object var0);

    @Node.NodeIntrinsic
    public static native Object piCastNonNull(Object var0, GuardingNode var1);

    @Node.NodeIntrinsic
    public static native Class<?> piCastNonNullClass(Class<?> var0, GuardingNode var1);

    public static Object piCastNonNull(Object object, @Node.ConstantNodeParameter ResolvedJavaType toType) {
        return PiNode.piCast(object, toType, false, true);
    }

    @Node.NodeIntrinsic
    public static native Object piCast(Object var0, @Node.ConstantNodeParameter ResolvedJavaType var1, @Node.ConstantNodeParameter boolean var2, @Node.ConstantNodeParameter boolean var3);

    public static final class PlaceholderStamp
    extends ObjectStamp {
        private static final PlaceholderStamp SINGLETON = new PlaceholderStamp();

        public static PlaceholderStamp singleton() {
            return SINGLETON;
        }

        private PlaceholderStamp() {
            super(null, false, false, false, false);
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public String toString() {
            return "PlaceholderStamp";
        }
    }

    @NodeInfo(cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
    public static class Placeholder
    extends FloatingGuardedNode {
        public static final NodeClass<Placeholder> TYPE = NodeClass.create(Placeholder.class);
        @Node.Input
        ValueNode object;

        public ValueNode object() {
            return this.object;
        }

        protected Placeholder(NodeClass<? extends Placeholder> c, ValueNode object) {
            super(c, PlaceholderStamp.SINGLETON, null);
            this.object = object;
        }

        public Placeholder(ValueNode object) {
            this(TYPE, object);
        }

        public void makeReplacement(Stamp snippetReplaceeStamp) {
            ValueNode value = this.graph().maybeAddOrUnique(PiNode.create(this.object(), snippetReplaceeStamp, null));
            this.replaceAndDelete(value);
        }
    }
}

