/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNegationNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.AddNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.IntegerBelowNode;
import org.graalvm.compiler.nodes.calc.IntegerEqualsNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.util.GraphUtil;
import org.graalvm.compiler.options.OptionValues;

@NodeInfo
public abstract class IntegerLowerThanNode
extends CompareNode {
    public static final NodeClass<IntegerLowerThanNode> TYPE = NodeClass.create(IntegerLowerThanNode.class);
    private final LowerOp op;

    protected IntegerLowerThanNode(NodeClass<? extends CompareNode> c, ValueNode x, ValueNode y, LowerOp op) {
        super(c, op.getCondition(), false, x, y);
        this.op = op;
    }

    protected LowerOp getOp() {
        return this.op;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStampGeneric, Stamp yStampGeneric) {
        return this.getSucceedingStampForX(negated, !negated, xStampGeneric, yStampGeneric, this.getX(), this.getY());
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStampGeneric, Stamp yStampGeneric) {
        return this.getSucceedingStampForX(!negated, !negated, yStampGeneric, xStampGeneric, this.getY(), this.getX());
    }

    private Stamp getSucceedingStampForX(boolean mirror, boolean strict, Stamp xStampGeneric, Stamp yStampGeneric, ValueNode forX, ValueNode forY) {
        Stamp s = this.getSucceedingStampForX(mirror, strict, xStampGeneric, yStampGeneric);
        if (s != null && s.isUnrestricted()) {
            s = null;
        }
        if (forY instanceof AddNode && xStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            AddNode addNode = (AddNode)forY;
            IntegerStamp aStamp = null;
            if (addNode.getX() == forX && addNode.getY().stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getY().stamp(NodeView.DEFAULT);
            } else if (addNode.getY() == forX && addNode.getX().stamp(NodeView.DEFAULT) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getX().stamp(NodeView.DEFAULT);
            }
            if (aStamp != null) {
                IntegerStamp result = this.getOp().getSucceedingStampForXLowerXPlusA(mirror, strict, aStamp, xStamp);
                if ((result = (IntegerStamp)xStamp.tryImproveWith(result)) != null) {
                    s = s != null ? s.improveWith(result) : result;
                }
            }
        }
        return s;
    }

    private Stamp getSucceedingStampForX(boolean mirror, boolean strict, Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            if (yStampGeneric instanceof IntegerStamp) {
                IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
                assert (yStamp.getBits() == xStamp.getBits());
                IntegerStamp s = this.getOp().getSucceedingStampForX(xStamp, yStamp, mirror, strict);
                if (s != null) {
                    return s;
                }
            }
        }
        return null;
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        return this.getOp().tryFold(xStampGeneric, yStampGeneric);
    }

    @Override
    public TriState implies(boolean thisNegated, LogicNode other) {
        if (other instanceof IntegerLowerThanNode) {
            IntegerLowerThanNode otherLowerThan = (IntegerLowerThanNode)other;
            if (this.getOp() == otherLowerThan.getOp() && this.getX() == otherLowerThan.getX()) {
                LogicNode compareYs = this.getOp().create(this.getY(), otherLowerThan.getY(), NodeView.DEFAULT);
                if (!thisNegated && compareYs.isTautology()) {
                    return TriState.TRUE;
                }
                if (thisNegated && compareYs.isContradiction()) {
                    return TriState.FALSE;
                }
            }
        }
        return super.implies(thisNegated, other);
    }

    public static abstract class LowerOp
    extends CompareNode.CompareOp {
        @Override
        public LogicNode canonical(ConstantReflectionProvider constantReflection, MetaAccessProvider metaAccess, OptionValues options, Integer smallestCompareWidth, CanonicalCondition condition, boolean unorderedIsTrue, ValueNode forX, ValueNode forY, NodeView view) {
            LogicNode result = super.canonical(constantReflection, metaAccess, options, smallestCompareWidth, condition, unorderedIsTrue, forX, forY, view);
            if (result != null) {
                return result;
            }
            LogicNode synonym = this.findSynonym(forX, forY, view);
            if (synonym != null) {
                return synonym;
            }
            return null;
        }

        protected abstract long upperBound(IntegerStamp var1);

        protected abstract long lowerBound(IntegerStamp var1);

        protected abstract int compare(long var1, long var3);

        protected abstract long min(long var1, long var3);

        protected abstract long max(long var1, long var3);

        protected long min(long a, long b, int bits) {
            return this.min(this.cast(a, bits), this.cast(b, bits));
        }

        protected long max(long a, long b, int bits) {
            return this.max(this.cast(a, bits), this.cast(b, bits));
        }

        protected abstract long cast(long var1, int var3);

        protected abstract long minValue(int var1);

        protected abstract long maxValue(int var1);

        protected abstract IntegerStamp forInteger(int var1, long var2, long var4);

        protected abstract CanonicalCondition getCondition();

        protected abstract IntegerLowerThanNode createNode(ValueNode var1, ValueNode var2);

        public LogicNode create(ValueNode x, ValueNode y, NodeView view) {
            LogicNode result = CompareNode.tryConstantFoldPrimitive(this.getCondition(), x, y, false, view);
            if (result != null) {
                return result;
            }
            result = this.findSynonym(x, y, view);
            if (result != null) {
                return result;
            }
            return this.createNode(x, y);
        }

        protected LogicNode findSynonym(ValueNode forX, ValueNode forY, NodeView view) {
            if (GraphUtil.unproxify(forX) == GraphUtil.unproxify(forY)) {
                return LogicConstantNode.contradiction();
            }
            Stamp xStampGeneric = forX.stamp(view);
            TriState fold = this.tryFold(xStampGeneric, forY.stamp(view));
            if (fold.isTrue()) {
                return LogicConstantNode.tautology();
            }
            if (fold.isFalse()) {
                return LogicConstantNode.contradiction();
            }
            if (forY.stamp(view) instanceof IntegerStamp) {
                AddNode addNode;
                LogicNode canonical;
                long xValue;
                IntegerStamp yStamp = (IntegerStamp)forY.stamp(view);
                IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
                int bits = yStamp.getBits();
                if (forX.isJavaConstant() && !forY.isConstant() && (xValue = forX.asJavaConstant().asLong()) != this.maxValue(bits)) {
                    return LogicNegationNode.create(this.create(forY, ConstantNode.forIntegerStamp(yStamp, xValue + 1L), view));
                }
                if (forY.isJavaConstant()) {
                    long yValue = forY.asJavaConstant().asLong();
                    if (yValue == this.maxValue(bits)) {
                        return LogicNegationNode.create(IntegerEqualsNode.create(forX, forY, view));
                    }
                    if (yValue == this.minValue(bits) + 1L) {
                        return IntegerEqualsNode.create(forX, ConstantNode.forIntegerStamp(yStamp, this.minValue(bits)), view);
                    }
                    if (yValue != this.minValue(bits) && xStamp.lowerBound() == yValue - 1L && (yValue > 0L || this.getCondition() == CanonicalCondition.LT)) {
                        return IntegerEqualsNode.create(forX, ConstantNode.forIntegerStamp(yStamp, yValue - 1L), view);
                    }
                } else if (forY instanceof AddNode && (canonical = this.canonicalizeXLowerXPlusA(forX, addNode = (AddNode)forY, false, true, view)) != null) {
                    return canonical;
                }
                if (forX instanceof AddNode && (canonical = this.canonicalizeXLowerXPlusA(forY, addNode = (AddNode)forX, true, false, view)) != null) {
                    return canonical;
                }
            }
            return null;
        }

        protected static LogicNode canonicalizeRangeFlip(ValueNode forX, ValueNode forY, int bits, boolean signed, NodeView view) {
            long min = CodeUtil.minValue((int)bits);
            long xResidue = 0L;
            ValueNode left = null;
            JavaConstant leftCst = null;
            if (forX instanceof AddNode) {
                AddNode xAdd = (AddNode)forX;
                if (xAdd.getY().isJavaConstant() && !xAdd.getY().asJavaConstant().isDefaultForKind()) {
                    long xCst = xAdd.getY().asJavaConstant().asLong();
                    xResidue = xCst - min;
                    left = xAdd.getX();
                }
            } else if (forX.isJavaConstant()) {
                leftCst = forX.asJavaConstant();
            }
            if (left == null && leftCst == null) {
                return null;
            }
            long yResidue = 0L;
            ValueNode right = null;
            JavaConstant rightCst = null;
            if (forY instanceof AddNode) {
                AddNode yAdd = (AddNode)forY;
                if (yAdd.getY().isJavaConstant() && !yAdd.getY().asJavaConstant().isDefaultForKind()) {
                    long yCst = yAdd.getY().asJavaConstant().asLong();
                    yResidue = yCst - min;
                    right = yAdd.getX();
                }
            } else if (forY.isJavaConstant()) {
                rightCst = forY.asJavaConstant();
            }
            if (right == null && rightCst == null) {
                return null;
            }
            if (xResidue == 0L && left != null || yResidue == 0L && right != null) {
                if (left == null) {
                    assert (leftCst != null);
                    left = ConstantNode.forIntegerBits(bits, leftCst.asLong() - min);
                } else if (xResidue != 0L) {
                    left = AddNode.create(left, ConstantNode.forIntegerBits(bits, xResidue), view);
                }
                if (right == null) {
                    assert (rightCst != null);
                    right = ConstantNode.forIntegerBits(bits, rightCst.asLong() - min);
                } else if (yResidue != 0L) {
                    right = AddNode.create(right, ConstantNode.forIntegerBits(bits, yResidue), view);
                }
                if (signed) {
                    return new IntegerBelowNode(left, right);
                }
                return new IntegerLessThanNode(left, right);
            }
            return null;
        }

        private LogicNode canonicalizeXLowerXPlusA(ValueNode forX, AddNode addNode, boolean mirrored, boolean strict, NodeView view) {
            boolean exact;
            IntegerStamp succeedingXStamp;
            IntegerStamp aStamp;
            IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
            if (addNode.getX() == forX && addNode.getY().stamp(view) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getY().stamp(view);
                succeedingXStamp = this.getSucceedingStampForXLowerXPlusA(mirrored, strict, aStamp, xStamp);
                exact = aStamp.lowerBound() == aStamp.upperBound();
            } else if (addNode.getY() == forX && addNode.getX().stamp(view) instanceof IntegerStamp) {
                aStamp = (IntegerStamp)addNode.getX().stamp(view);
                succeedingXStamp = this.getSucceedingStampForXLowerXPlusA(mirrored, strict, aStamp, xStamp);
                exact = aStamp.lowerBound() == aStamp.upperBound();
            } else {
                return null;
            }
            if (succeedingXStamp.join(forX.stamp(view)).isEmpty()) {
                return LogicConstantNode.contradiction();
            }
            if (exact && !succeedingXStamp.isEmpty()) {
                int bits = succeedingXStamp.getBits();
                if (this.compare(this.lowerBound(succeedingXStamp), this.minValue(bits)) > 0) {
                    return LogicNegationNode.create(this.create(forX, ConstantNode.forIntegerStamp(succeedingXStamp, this.lowerBound(succeedingXStamp)), view));
                }
                if (this.compare(this.upperBound(succeedingXStamp), this.maxValue(bits)) < 0) {
                    return LogicNegationNode.create(this.create(ConstantNode.forIntegerStamp(succeedingXStamp, this.upperBound(succeedingXStamp)), forX, view));
                }
            }
            return null;
        }

        protected TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
            if (xStampGeneric instanceof IntegerStamp && yStampGeneric instanceof IntegerStamp) {
                IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
                IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
                if (this.compare(this.upperBound(xStamp), this.lowerBound(yStamp)) < 0) {
                    return TriState.TRUE;
                }
                if (this.compare(this.lowerBound(xStamp), this.upperBound(yStamp)) >= 0) {
                    return TriState.FALSE;
                }
            }
            return TriState.UNKNOWN;
        }

        protected IntegerStamp getSucceedingStampForX(IntegerStamp xStamp, IntegerStamp yStamp, boolean mirror, boolean strict) {
            int bits = xStamp.getBits();
            assert (yStamp.getBits() == bits);
            if (mirror) {
                long low = this.lowerBound(yStamp);
                if (strict) {
                    if (low == this.maxValue(bits)) {
                        return null;
                    }
                    ++low;
                }
                if (this.compare(low, this.lowerBound(xStamp)) > 0 || this.upperBound(xStamp) != (xStamp.upperBound() & CodeUtil.mask((int)xStamp.getBits()))) {
                    return this.forInteger(bits, low, this.upperBound(xStamp));
                }
            } else {
                long low = this.upperBound(yStamp);
                if (strict) {
                    if (low == this.minValue(bits)) {
                        return null;
                    }
                    --low;
                }
                if (this.compare(low, this.upperBound(xStamp)) < 0 || this.lowerBound(xStamp) != (xStamp.lowerBound() & CodeUtil.mask((int)xStamp.getBits()))) {
                    return this.forInteger(bits, this.lowerBound(xStamp), low);
                }
            }
            return null;
        }

        protected IntegerStamp getSucceedingStampForXLowerXPlusA(boolean mirrored, boolean strict, IntegerStamp aStamp, IntegerStamp xStamp) {
            int bits = aStamp.getBits();
            long min = this.minValue(bits);
            long max = this.maxValue(bits);
            if (mirrored) {
                if (aStamp.contains(0L)) {
                    return aStamp.unrestricted();
                }
                return this.forInteger(bits, this.min(max - aStamp.lowerBound() + 1L, max - aStamp.upperBound() + 1L, bits), this.min(max, this.upperBound(xStamp)));
            }
            long aLower = aStamp.lowerBound();
            long aUpper = aStamp.upperBound();
            if (strict) {
                if (aLower == 0L) {
                    aLower = 1L;
                }
                if (aUpper == 0L) {
                    aUpper = -1L;
                }
                if (aLower > aUpper) {
                    return aStamp.empty();
                }
            }
            if (aLower < 0L && aUpper > 0L) {
                return aStamp.unrestricted();
            }
            return this.forInteger(bits, min, this.max(max - aLower, max - aUpper, bits));
        }
    }
}

