/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import jdk.vm.ci.meta.TriState;
import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.BinaryOpLogicNode;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Canonicalizable;
import org.graalvm.compiler.nodes.spi.CanonicalizerTool;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_2)
public final class IntegerTestNode
extends BinaryOpLogicNode
implements Canonicalizable.BinaryCommutative<ValueNode> {
    public static final NodeClass<IntegerTestNode> TYPE = NodeClass.create(IntegerTestNode.class);

    public IntegerTestNode(ValueNode x, ValueNode y) {
        super(TYPE, x, y);
    }

    public static LogicNode create(ValueNode x, ValueNode y, NodeView view) {
        LogicNode value = IntegerTestNode.canonical(x, y, view);
        if (value != null) {
            return value;
        }
        return new IntegerTestNode(x, y);
    }

    private static LogicNode canonical(ValueNode forX, ValueNode forY, NodeView view) {
        if (forX.isConstant() && forY.isConstant() && forX.isJavaConstant() && forY.isJavaConstant()) {
            return LogicConstantNode.forBoolean((forX.asJavaConstant().asLong() & forY.asJavaConstant().asLong()) == 0L);
        }
        if (forX.stamp(view) instanceof IntegerStamp && forY.stamp(view) instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)forX.stamp(view);
            IntegerStamp yStamp = (IntegerStamp)forY.stamp(view);
            if ((xStamp.upMask() & yStamp.upMask()) == 0L) {
                return LogicConstantNode.tautology();
            }
            if ((xStamp.downMask() & yStamp.downMask()) != 0L) {
                return LogicConstantNode.contradiction();
            }
        }
        return null;
    }

    public ValueNode canonical(CanonicalizerTool tool, ValueNode forX, ValueNode forY) {
        LogicNode value = IntegerTestNode.canonical(forX, forY, NodeView.from(tool));
        return value != null ? value : this;
    }

    @Override
    public Stamp getSucceedingStampForX(boolean negated, Stamp xStamp, Stamp yStamp) {
        return IntegerTestNode.getSucceedingStamp(negated, xStamp, yStamp);
    }

    private static Stamp getSucceedingStamp(boolean negated, Stamp xStampGeneric, Stamp otherStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp && otherStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            IntegerStamp otherStamp = (IntegerStamp)otherStampGeneric;
            if (negated) {
                if (Long.bitCount(otherStamp.upMask()) == 1) {
                    long newDownMask = xStamp.downMask() | otherStamp.upMask();
                    if (xStamp.downMask() != newDownMask) {
                        return IntegerStamp.stampForMask(xStamp.getBits(), newDownMask, xStamp.upMask()).join(xStamp);
                    }
                }
            } else {
                long restrictedUpMask = (otherStamp.downMask() ^ 0xFFFFFFFFFFFFFFFFL) & xStamp.upMask();
                if (xStamp.upMask() != restrictedUpMask) {
                    return IntegerStamp.stampForMask(xStamp.getBits(), xStamp.downMask(), restrictedUpMask).join(xStamp);
                }
            }
        }
        return null;
    }

    @Override
    public Stamp getSucceedingStampForY(boolean negated, Stamp xStamp, Stamp yStamp) {
        return IntegerTestNode.getSucceedingStamp(negated, yStamp, xStamp);
    }

    @Override
    public TriState tryFold(Stamp xStampGeneric, Stamp yStampGeneric) {
        if (xStampGeneric instanceof IntegerStamp && yStampGeneric instanceof IntegerStamp) {
            IntegerStamp xStamp = (IntegerStamp)xStampGeneric;
            IntegerStamp yStamp = (IntegerStamp)yStampGeneric;
            if ((xStamp.upMask() & yStamp.upMask()) == 0L) {
                return TriState.TRUE;
            }
            if ((xStamp.downMask() & yStamp.downMask()) != 0L) {
                return TriState.FALSE;
            }
        }
        return TriState.UNKNOWN;
    }
}

