/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.AbstractControlFlowGraph;
import org.graalvm.compiler.core.common.cfg.CFGVerifier;
import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeMap;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.AbstractBeginNode;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.AbstractMergeNode;
import org.graalvm.compiler.nodes.ControlSinkNode;
import org.graalvm.compiler.nodes.ControlSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.IfNode;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.LoopExitNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.HIRLoop;

public final class ControlFlowGraph
implements AbstractControlFlowGraph<Block> {
    public static final double MIN_RELATIVE_FREQUENCY = 3.054936363499605E-151;
    public static final double MAX_RELATIVE_FREQUENCY = 3.273390607896142E150;
    public final StructuredGraph graph;
    private NodeMap<Block> nodeToBlock;
    private Block[] reversePostOrder;
    private List<Loop<Block>> loops;
    private int maxDominatorDepth;

    public static ControlFlowGraph compute(StructuredGraph graph, boolean connectBlocks, boolean computeLoops, boolean computeDominators, boolean computePostdominators) {
        ControlFlowGraph cfg = new ControlFlowGraph(graph);
        cfg.identifyBlocks();
        cfg.computeFrequencies();
        if (computeLoops) {
            cfg.computeLoopInformation();
        }
        if (computeDominators) {
            cfg.computeDominators();
        }
        if (computePostdominators) {
            cfg.computePostdominators();
        }
        assert (!connectBlocks && !computeLoops && !computeDominators && !computePostdominators || CFGVerifier.verify(cfg));
        return cfg;
    }

    public String dominatorTreeString() {
        return ControlFlowGraph.dominatorTreeString(this.getStartBlock());
    }

    private static String dominatorTreeString(Block b) {
        StringBuilder sb = new StringBuilder();
        sb.append(b);
        sb.append("(");
        for (Block firstDominated = (Block)b.getFirstDominated(); firstDominated != null; firstDominated = (Block)firstDominated.getDominatedSibling()) {
            if (((Block)firstDominated.getDominator()).getPostdominator() == firstDominated) {
                sb.append("!");
            }
            sb.append(ControlFlowGraph.dominatorTreeString(firstDominated));
        }
        sb.append(") ");
        return sb.toString();
    }

    public <V> void visitDominatorTreeDefault(RecursiveVisitor<V> visitor) {
        Block[] stack = new Block[this.maxDominatorDepth + 1];
        Block current = this.getStartBlock();
        int tos = 0;
        Object[] values = null;
        int valuesTOS = 0;
        while (tos >= 0) {
            Object value;
            Block state = stack[tos];
            if (state == null || state.getDominator() == null || ((Block)state.getDominator()).getPostdominator() != state) {
                Block postDom;
                if (state == null) {
                    Block dominated;
                    value = visitor.enter(current);
                    if (value != null || values != null) {
                        if (values == null) {
                            values = new Object[this.maxDominatorDepth + 1];
                        }
                        values[valuesTOS++] = value;
                    }
                    if ((dominated = ControlFlowGraph.skipPostDom((Block)current.getFirstDominated())) != null) {
                        stack[tos] = dominated;
                        current = dominated;
                        stack[++tos] = null;
                        continue;
                    }
                } else {
                    Block next = ControlFlowGraph.skipPostDom((Block)state.getDominatedSibling());
                    if (next != null) {
                        stack[tos] = next;
                        current = next;
                        stack[++tos] = null;
                        continue;
                    }
                }
                if ((postDom = current.getPostdominator()) != null && postDom.getDominator() == current) {
                    stack[tos] = postDom;
                    current = postDom;
                    stack[++tos] = null;
                    continue;
                }
            }
            value = null;
            if (values != null && valuesTOS > 0) {
                value = values[--valuesTOS];
            }
            visitor.exit(current, value);
            current = (Block)current.getDominator();
            --tos;
        }
    }

    private static Block skipPostDom(Block block) {
        if (block != null && ((Block)block.getDominator()).getPostdominator() == block) {
            return (Block)block.getDominatedSibling();
        }
        return block;
    }

    public static void addDeferredExit(DeferredExit[] deferredExits, Block b) {
        Loop<Block> outermostExited = ((Block)b.getDominator()).getLoop();
        Loop<Block> exitBlockLoop = b.getLoop();
        assert (outermostExited != null) : "Dominator must be in a loop. Possible cause is a missing loop exit node.";
        while (outermostExited.getParent() != null && outermostExited.getParent() != exitBlockLoop) {
            outermostExited = outermostExited.getParent();
        }
        int loopIndex = outermostExited.getIndex();
        deferredExits[loopIndex] = new DeferredExit(b, deferredExits[loopIndex]);
    }

    public <V> void visitDominatorTreeDeferLoopExits(RecursiveVisitor<V> visitor) {
        Block[] stack = new Block[this.getBlocks().length];
        int tos = 0;
        BitSet visited = new BitSet(this.getBlocks().length);
        int loopCount = this.getLoops().size();
        DeferredExit[] deferredExits = new DeferredExit[loopCount];
        Object[] values = null;
        int valuesTOS = 0;
        stack[0] = this.getStartBlock();
        while (tos >= 0) {
            Block alwaysReached;
            Object value;
            Block cur = stack[tos];
            int curId = cur.getId();
            if (visited.get(curId)) {
                int loopIndex;
                DeferredExit deferredExit;
                value = null;
                if (values != null && valuesTOS > 0) {
                    value = values[--valuesTOS];
                }
                visitor.exit(cur, value);
                --tos;
                if (!cur.isLoopHeader() || (deferredExit = deferredExits[loopIndex = cur.getLoop().getIndex()]) == null) continue;
                while (deferredExit != null) {
                    stack[++tos] = deferredExit.block;
                    deferredExit = deferredExit.next;
                }
                deferredExits[loopIndex] = null;
                continue;
            }
            visited.set(curId);
            value = visitor.enter(cur);
            if (value != null || values != null) {
                if (values == null) {
                    values = new Object[this.maxDominatorDepth + 1];
                }
                values[valuesTOS++] = value;
            }
            if ((alwaysReached = cur.getPostdominator()) != null) {
                if (alwaysReached.getDominator() != cur) {
                    alwaysReached = null;
                } else if (ControlFlowGraph.isDominatorTreeLoopExit(alwaysReached)) {
                    ControlFlowGraph.addDeferredExit(deferredExits, alwaysReached);
                } else {
                    stack[++tos] = alwaysReached;
                }
            }
            for (Block b = (Block)cur.getFirstDominated(); b != null; b = (Block)b.getDominatedSibling()) {
                if (b == alwaysReached) continue;
                if (ControlFlowGraph.isDominatorTreeLoopExit(b)) {
                    ControlFlowGraph.addDeferredExit(deferredExits, b);
                    continue;
                }
                stack[++tos] = b;
            }
        }
    }

    public <V> void visitDominatorTree(RecursiveVisitor<V> visitor, boolean deferLoopExits) {
        if (deferLoopExits && this.getLoops().size() > 0) {
            this.visitDominatorTreeDeferLoopExits(visitor);
        } else {
            this.visitDominatorTreeDefault(visitor);
        }
    }

    public static boolean isDominatorTreeLoopExit(Block b) {
        Block dominator = (Block)b.getDominator();
        return dominator != null && b.getLoop() != dominator.getLoop() && (!b.isLoopHeader() || dominator.getLoopDepth() >= b.getLoopDepth());
    }

    private ControlFlowGraph(StructuredGraph graph) {
        this.graph = graph;
        this.nodeToBlock = graph.createNodeMap();
    }

    private void computeDominators() {
        assert (this.reversePostOrder[0].getPredecessorCount() == 0) : "start block has no predecessor and therefore no dominator";
        Block[] blocks = this.reversePostOrder;
        int curMaxDominatorDepth = 0;
        for (int i = 1; i < blocks.length; ++i) {
            Block block = blocks[i];
            assert (block.getPredecessorCount() > 0);
            AbstractBlockBase dominator = null;
            for (Block pred : (Block[])block.getPredecessors()) {
                if (pred.isLoopEnd()) continue;
                dominator = dominator == null ? pred : ControlFlowGraph.commonDominatorRaw((Block)dominator, pred);
            }
            assert (dominator != null);
            block.setDominator(dominator);
            Block currentDominated = (Block)dominator.getFirstDominated();
            if (currentDominated != null && currentDominated.getId() < block.getId()) {
                while (currentDominated.getDominatedSibling() != null && ((Block)currentDominated.getDominatedSibling()).getId() < block.getId()) {
                    currentDominated = (Block)currentDominated.getDominatedSibling();
                }
                block.setDominatedSibling(currentDominated.getDominatedSibling());
                currentDominated.setDominatedSibling(block);
            } else {
                block.setDominatedSibling(dominator.getFirstDominated());
                dominator.setFirstDominated(block);
            }
            curMaxDominatorDepth = Math.max(curMaxDominatorDepth, block.getDominatorDepth());
        }
        this.maxDominatorDepth = curMaxDominatorDepth;
        ControlFlowGraph.calcDominatorRanges(this.getStartBlock(), this.reversePostOrder.length);
    }

    private static void calcDominatorRanges(Block block, int size) {
        Block[] stack = new Block[size];
        stack[0] = block;
        int tos = 0;
        int myNumber = 0;
        do {
            Block cur = stack[tos];
            Block dominated = (Block)cur.getFirstDominated();
            if (cur.getDominatorNumber() == -1) {
                cur.setDominatorNumber(myNumber);
                if (dominated != null) {
                    do {
                        stack[++tos] = dominated;
                    } while ((dominated = (Block)dominated.getDominatedSibling()) != null);
                } else {
                    cur.setMaxChildDomNumber(myNumber);
                    --tos;
                }
                ++myNumber;
                continue;
            }
            cur.setMaxChildDomNumber(dominated.getMaxChildDominatorNumber());
            --tos;
        } while (tos >= 0);
    }

    private static Block commonDominatorRaw(Block a, Block b) {
        int bDomDepth;
        int aDomDepth = a.getDominatorDepth();
        if (aDomDepth > (bDomDepth = b.getDominatorDepth())) {
            return ControlFlowGraph.commonDominatorRawSameDepth(a.getDominator(aDomDepth - bDomDepth), b);
        }
        return ControlFlowGraph.commonDominatorRawSameDepth(a, b.getDominator(bDomDepth - aDomDepth));
    }

    private static Block commonDominatorRawSameDepth(Block a, Block b) {
        Block iterA = a;
        for (Block iterB = b; iterA != iterB; iterA = (Block)iterA.getDominator(), iterB = (Block)iterB.getDominator()) {
        }
        return iterA;
    }

    public Block[] getBlocks() {
        return this.reversePostOrder;
    }

    @Override
    public Block getStartBlock() {
        return this.reversePostOrder[0];
    }

    public Block[] reversePostOrder() {
        return this.reversePostOrder;
    }

    public NodeMap<Block> getNodeToBlock() {
        return this.nodeToBlock;
    }

    public Block blockFor(Node node) {
        return this.nodeToBlock.get(node);
    }

    public Block commonDominatorFor(NodeIterable<? extends Node> nodes) {
        Block commonDom = null;
        for (Node node : nodes) {
            Block b = this.blockFor(node);
            commonDom = (Block)AbstractControlFlowGraph.commonDominator(commonDom, b);
        }
        return commonDom;
    }

    @Override
    public List<Loop<Block>> getLoops() {
        return this.loops;
    }

    public int getMaxDominatorDepth() {
        return this.maxDominatorDepth;
    }

    private void identifyBlock(Block block) {
        FixedNode next;
        FixedWithNextNode cur = block.getBeginNode();
        while (true) {
            assert (cur.isAlive()) : cur;
            assert (this.nodeToBlock.get(cur) == null);
            this.nodeToBlock.set(cur, block);
            next = cur.next();
            assert (next != null) : cur;
            if (next instanceof AbstractBeginNode) {
                block.endNode = cur;
                return;
            }
            if (!(next instanceof FixedWithNextNode)) break;
            cur = (FixedWithNextNode)next;
        }
        this.nodeToBlock.set(next, block);
        block.endNode = next;
    }

    private void identifyBlocks() {
        Block startBlock;
        int numBlocks = 0;
        for (AbstractBeginNode begin : this.graph.getNodes(AbstractBeginNode.TYPE)) {
            Block block = new Block(begin);
            this.identifyBlock(block);
            ++numBlocks;
        }
        int count = 0;
        NodeMap<Block> nodeMap = this.nodeToBlock;
        Block[] stack = new Block[numBlocks];
        int tos = 0;
        stack[0] = startBlock = this.blockFor(this.graph.start());
        startBlock.setPredecessors(Block.EMPTY_ARRAY);
        do {
            Block block;
            int id;
            if ((id = (block = stack[tos]).getId()) == -1) {
                FixedNode last = block.getEndNode();
                if (last instanceof EndNode) {
                    EndNode endNode = (EndNode)last;
                    Block suxBlock = nodeMap.get(endNode.merge());
                    if (suxBlock.getId() == -1) {
                        stack[++tos] = suxBlock;
                    }
                    block.setSuccessors(new Block[]{suxBlock});
                } else if (last instanceof IfNode) {
                    IfNode ifNode = (IfNode)last;
                    Block trueSucc = nodeMap.get(ifNode.trueSuccessor());
                    stack[++tos] = trueSucc;
                    Block falseSucc = nodeMap.get(ifNode.falseSuccessor());
                    stack[++tos] = falseSucc;
                    block.setSuccessors(new Block[]{trueSucc, falseSucc});
                    AbstractBlockBase[] ifPred = new Block[]{block};
                    trueSucc.setPredecessors(ifPred);
                    falseSucc.setPredecessors(ifPred);
                } else if (last instanceof LoopEndNode) {
                    LoopEndNode loopEndNode = (LoopEndNode)last;
                    block.setSuccessors(new Block[]{nodeMap.get(loopEndNode.loopBegin())});
                } else if (last instanceof ControlSinkNode) {
                    block.setSuccessors(Block.EMPTY_ARRAY);
                } else {
                    assert (!(last instanceof AbstractEndNode)) : "Algorithm only supports EndNode and LoopEndNode.";
                    int startTos = tos;
                    AbstractBlockBase[] ifPred = new Block[]{block};
                    for (Node suxNode : last.successors()) {
                        Block sux = nodeMap.get(suxNode);
                        stack[++tos] = sux;
                        sux.setPredecessors(ifPred);
                    }
                    int suxCount = tos - startTos;
                    AbstractBlockBase[] successors = new Block[suxCount];
                    System.arraycopy(stack, startTos + 1, successors, 0, suxCount);
                    block.setSuccessors(successors);
                }
                block.setId(-2);
                AbstractBeginNode beginNode = block.getBeginNode();
                if (beginNode instanceof LoopBeginNode) {
                    ControlFlowGraph.computeLoopPredecessors(nodeMap, block, (LoopBeginNode)beginNode);
                    continue;
                }
                if (!(beginNode instanceof AbstractMergeNode)) continue;
                AbstractMergeNode mergeNode = (AbstractMergeNode)beginNode;
                int forwardEndCount = mergeNode.forwardEndCount();
                AbstractBlockBase[] predecessors = new Block[forwardEndCount];
                for (int i = 0; i < forwardEndCount; ++i) {
                    predecessors[i] = nodeMap.get(mergeNode.forwardEndAt(i));
                }
                block.setPredecessors(predecessors);
                continue;
            }
            if (id == -2) {
                --tos;
                int index = numBlocks - ++count;
                stack[index] = block;
                block.setId(index);
                continue;
            }
            throw GraalError.shouldNotReachHere();
        } while (tos >= 0);
        assert (count == numBlocks) : "all blocks must be reachable";
        this.reversePostOrder = stack;
    }

    private static void computeLoopPredecessors(NodeMap<Block> nodeMap, Block block, LoopBeginNode loopBeginNode) {
        int i;
        int forwardEndCount = loopBeginNode.forwardEndCount();
        LoopEndNode[] loopEnds = loopBeginNode.orderedLoopEnds();
        AbstractBlockBase[] predecessors = new Block[forwardEndCount + loopEnds.length];
        for (i = 0; i < forwardEndCount; ++i) {
            predecessors[i] = nodeMap.get(loopBeginNode.forwardEndAt(i));
        }
        for (i = 0; i < loopEnds.length; ++i) {
            predecessors[i + forwardEndCount] = nodeMap.get(loopEnds[i]);
        }
        block.setPredecessors(predecessors);
    }

    private void computeFrequencies() {
        for (Block block : this.reversePostOrder) {
            double relativeFrequency;
            Block[] predecessors = (Block[])block.getPredecessors();
            if (predecessors.length == 0) {
                relativeFrequency = 1.0;
            } else if (predecessors.length == 1) {
                Block pred = predecessors[0];
                relativeFrequency = pred.relativeFrequency;
                if (pred.getSuccessorCount() > 1) {
                    assert (pred.getEndNode() instanceof ControlSplitNode);
                    ControlSplitNode controlSplit = (ControlSplitNode)pred.getEndNode();
                    relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(relativeFrequency, controlSplit.probability(block.getBeginNode()));
                }
            } else {
                relativeFrequency = predecessors[0].relativeFrequency;
                for (int i = 1; i < predecessors.length; ++i) {
                    relativeFrequency += predecessors[i].relativeFrequency;
                }
                if (block.getBeginNode() instanceof LoopBeginNode) {
                    LoopBeginNode loopBegin = (LoopBeginNode)block.getBeginNode();
                    relativeFrequency = ControlFlowGraph.multiplyRelativeFrequencies(relativeFrequency, loopBegin.loopFrequency());
                }
            }
            if (relativeFrequency < 3.054936363499605E-151) {
                relativeFrequency = 3.054936363499605E-151;
            } else if (relativeFrequency > 3.273390607896142E150) {
                relativeFrequency = 3.273390607896142E150;
            }
            block.setRelativeFrequency(relativeFrequency);
        }
    }

    private void computeLoopInformation() {
        this.loops = new ArrayList<Loop<Block>>();
        if (this.graph.hasLoops()) {
            Block[] stack = new Block[this.reversePostOrder.length];
            for (Block block : this.reversePostOrder) {
                AbstractBeginNode beginNode = block.getBeginNode();
                if (!(beginNode instanceof LoopBeginNode)) continue;
                Loop<Block> parent = block.getLoop();
                HIRLoop loop = new HIRLoop(parent, this.loops.size(), block);
                if (((LoopBeginNode)beginNode).isCompilerInverted()) {
                    loop.setInverted(true);
                }
                if (parent != null) {
                    parent.getChildren().add(loop);
                }
                this.loops.add(loop);
                block.setLoop(loop);
                loop.getBlocks().add(block);
                LoopBeginNode loopBegin = (LoopBeginNode)beginNode;
                for (LoopEndNode end : loopBegin.loopEnds()) {
                    Block[] endBlock = this.nodeToBlock.get(end);
                    ControlFlowGraph.computeLoopBlocks((Block)endBlock, loop, stack, true);
                }
                for (Block b : loop.getBlocks()) {
                    for (Block sux : (Block[])b.getSuccessors()) {
                        if (sux.getLoop() == loop) continue;
                        assert (sux.getLoopDepth() < loop.getDepth());
                        loop.getNaturalExits().add(sux);
                    }
                }
                loop.getNaturalExits().sort(AbstractBlockBase.BLOCK_ID_COMPARATOR);
                if (!this.graph.getGuardsStage().areFrameStatesAtDeopts()) {
                    for (LoopExitNode exit : loopBegin.loopExits()) {
                        Block exitBlock = this.nodeToBlock.get(exit);
                        assert (exitBlock.getPredecessorCount() == 1);
                        ControlFlowGraph.computeLoopBlocks(exitBlock.getFirstPredecessor(), loop, stack, true);
                        loop.getLoopExits().add(exitBlock);
                    }
                    loop.getLoopExits().sort(AbstractBlockBase.BLOCK_ID_COMPARATOR);
                    int size = loop.getBlocks().size();
                    for (int i = 0; i < size; ++i) {
                        Block b = (Block)loop.getBlocks().get(i);
                        for (Block sux : (Block[])b.getSuccessors()) {
                            AbstractBeginNode begin;
                            if (sux.getLoop() == loop || loopBegin.isLoopExit(begin = sux.getBeginNode())) continue;
                            assert (!(begin instanceof LoopBeginNode));
                            assert (sux.getLoopDepth() < loop.getDepth());
                            this.graph.getDebug().log(3, "Unexpected loop exit with %s, including whole branch in the loop", (Object)sux);
                            ControlFlowGraph.computeLoopBlocks(sux, loop, stack, false);
                        }
                    }
                    continue;
                }
                loop.getLoopExits().addAll(loop.getNaturalExits());
            }
        }
    }

    private static void computeLoopBlocks(Block start, Loop<Block> loop, Block[] stack, boolean usePred) {
        if (start.getLoop() != loop) {
            start.setLoop(loop);
            stack[0] = start;
            loop.getBlocks().add(start);
            int tos = 0;
            do {
                Block block = stack[tos--];
                for (Block b : usePred ? (Block[])block.getPredecessors() : (Block[])block.getSuccessors()) {
                    if (b.getLoop() == loop) continue;
                    stack[++tos] = b;
                    b.setLoop(loop);
                    loop.getBlocks().add(b);
                }
            } while (tos >= 0);
        }
    }

    public void computePostdominators() {
        Block[] reversePostOrderTmp = this.reversePostOrder;
        block0: for (int j = reversePostOrderTmp.length - 1; j >= 0; --j) {
            Block block = reversePostOrderTmp[j];
            if (block.isLoopEnd() || block.getSuccessorCount() == 0) continue;
            Block firstSucc = ((Block[])block.getSuccessors())[0];
            if (block.getSuccessorCount() == 1) {
                block.postdominator = firstSucc;
                continue;
            }
            Block postdominator = firstSucc;
            for (Block sux : (Block[])block.getSuccessors()) {
                if ((postdominator = ControlFlowGraph.commonPostdominator(postdominator, sux)) == null) continue block0;
            }
            assert (!Arrays.asList(block.getSuccessors()).contains(postdominator)) : "Block " + block + " has a wrong post dominator: " + postdominator;
            block.setPostDominator(postdominator);
        }
    }

    private static Block commonPostdominator(Block a, Block b) {
        Block iterA = a;
        Block iterB = b;
        while (iterA != iterB) {
            if (iterA.getId() < iterB.getId()) {
                if ((iterA = iterA.getPostdominator()) != null) continue;
                return null;
            }
            assert (iterB.getId() < iterA.getId());
            if ((iterB = iterB.getPostdominator()) != null) continue;
            return null;
        }
        return iterA;
    }

    public void setNodeToBlock(NodeMap<Block> nodeMap) {
        this.nodeToBlock = nodeMap;
    }

    public static double multiplyRelativeFrequencies(double a, double b) {
        assert (!Double.isNaN(a) && !Double.isNaN(b) && Double.isFinite(a) && Double.isFinite(b)) : a + " " + b;
        double r = a * b;
        if (r > 3.273390607896142E150) {
            return 3.273390607896142E150;
        }
        if (r < 3.054936363499605E-151) {
            return 3.054936363499605E-151;
        }
        return r;
    }

    public static final class DeferredExit {
        private final Block block;
        private final DeferredExit next;

        public DeferredExit(Block block, DeferredExit next) {
            this.block = block;
            this.next = next;
        }

        public Block getBlock() {
            return this.block;
        }

        public DeferredExit getNext() {
            return this.next;
        }
    }

    public static interface RecursiveVisitor<V> {
        public V enter(Block var1);

        public void exit(Block var1, V var2);
    }
}

