/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import org.graalvm.compiler.core.common.cfg.Loop;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.cfg.Block;
import org.graalvm.compiler.nodes.cfg.LocationSet;
import org.graalvm.word.LocationIdentity;

public final class HIRLoop
extends Loop<Block> {
    private LocationSet killLocations;

    protected HIRLoop(Loop<Block> parent, int index, Block header) {
        super(parent, index, header);
    }

    @Override
    public long numBackedges() {
        return ((LoopBeginNode)((Block)this.getHeader()).getBeginNode()).loopEnds().count();
    }

    public LocationSet getKillLocations() {
        if (this.killLocations == null) {
            this.killLocations = new LocationSet();
            for (Block b : this.getBlocks()) {
                if (b.getLoop() != this) continue;
                this.killLocations.addAll(b.getKillLocations());
                if (!this.killLocations.isAny()) continue;
                break;
            }
        }
        for (Loop child : this.getChildren()) {
            if (this.killLocations.isAny()) break;
            this.killLocations.addAll(((HIRLoop)child).getKillLocations());
        }
        return this.killLocations;
    }

    public boolean canKill(LocationIdentity location) {
        return this.getKillLocations().contains(location);
    }

    @Override
    public String toString() {
        return super.toString() + " header:" + ((Block)this.getHeader()).getBeginNode();
    }
}

