/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.graalvm.word.LocationIdentity;

public class LocationSet {
    private LocationIdentity firstLocation;
    private List<LocationIdentity> list;

    public LocationSet() {
        this.list = null;
    }

    public LocationSet(LocationSet other) {
        this.firstLocation = other.firstLocation;
        if (other.list != null && other.list.size() > 0) {
            this.list = new ArrayList<LocationIdentity>(other.list);
        }
    }

    private void initList() {
        if (this.list == null) {
            this.list = new ArrayList<LocationIdentity>(4);
        }
    }

    public boolean isEmpty() {
        return this.firstLocation == null;
    }

    public boolean isAny() {
        return this.firstLocation != null && this.firstLocation.isAny();
    }

    public void add(LocationIdentity location) {
        if (this.isAny()) {
            return;
        }
        if (location.isAny()) {
            this.firstLocation = location;
            this.list = null;
        } else {
            if (location.isImmutable()) {
                return;
            }
            assert (location.isMutable() && location.isSingle());
            if (this.firstLocation == null) {
                this.firstLocation = location;
            } else {
                if (location.equals(this.firstLocation)) {
                    return;
                }
                this.initList();
                for (int i = 0; i < this.list.size(); ++i) {
                    LocationIdentity value = this.list.get(i);
                    if (!location.equals(value)) continue;
                    return;
                }
                this.list.add(location);
            }
        }
    }

    public void addAll(LocationSet other) {
        List<LocationIdentity> otherList;
        if (other.firstLocation != null) {
            this.add(other.firstLocation);
        }
        if ((otherList = other.list) != null) {
            for (LocationIdentity l : otherList) {
                this.add(l);
            }
        }
    }

    public boolean contains(LocationIdentity locationIdentity) {
        assert (locationIdentity.isSingle());
        assert (locationIdentity.isMutable());
        if (LocationIdentity.any().equals(this.firstLocation)) {
            return true;
        }
        if (locationIdentity.equals(this.firstLocation)) {
            return true;
        }
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                LocationIdentity value = this.list.get(i);
                if (!locationIdentity.equals(value)) continue;
                return true;
            }
        }
        return false;
    }

    public List<LocationIdentity> getCopyAsList() {
        ArrayList<LocationIdentity> result = new ArrayList<LocationIdentity>();
        if (this.firstLocation != null) {
            result.add(this.firstLocation);
        }
        if (this.list != null) {
            result.addAll(this.list);
        }
        return result;
    }

    public String toString() {
        if (this.isAny()) {
            return "ANY";
        }
        if (this.isEmpty()) {
            return "EMPTY";
        }
        List<LocationIdentity> copyAsList = this.getCopyAsList();
        return Arrays.toString(copyAsList.toArray(new LocationIdentity[0]));
    }
}

