/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.graphbuilderconf;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import jdk.vm.ci.meta.MetaUtil;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import jdk.vm.ci.services.Services;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.Equivalence;
import org.graalvm.collections.MapCursor;
import org.graalvm.collections.Pair;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.collections.UnmodifiableMapCursor;
import org.graalvm.compiler.api.replacements.MethodSubstitution;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.core.common.SuppressFBWarnings;
import org.graalvm.compiler.debug.Assertions;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ForeignCallPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GeneratedInvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.MethodSubstitutionPlugin;
import org.graalvm.compiler.nodes.spi.Replacements;

public class InvocationPlugins {
    private final UnmodifiableEconomicMap<ResolvedJavaMethod, InvocationPlugin> resolvedRegistrations;
    private final EconomicMap<String, ClassPlugins> registrations;
    private volatile List<Runnable> deferredRegistrations = new ArrayList<Runnable>();
    private volatile LateClassPlugins lateRegistrations;
    private volatile EconomicMap<String, List<Binding>> testExtensions;
    protected final InvocationPlugins parent;

    static String toArgumentDescriptor(boolean isStatic, Type[] argumentTypes) {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append('(');
        int n = i = isStatic ? 0 : 1;
        while (i < argumentTypes.length) {
            buf.append(MetaUtil.toInternalName((String)argumentTypes[i].getTypeName()));
            ++i;
        }
        buf.append(')');
        return buf.toString();
    }

    public void defer(Runnable deferrable) {
        assert (this.deferredRegistrations != null) : "registration is closed";
        this.deferredRegistrations.add(deferrable);
    }

    Binding put(InvocationPlugin plugin, boolean isStatic, boolean allowOverwrite, Type declaringClass, String name, Type ... argumentTypes) {
        assert (this.resolvedRegistrations == null) : "registration is closed";
        String internalName = MetaUtil.toInternalName((String)declaringClass.getTypeName());
        assert (isStatic || argumentTypes[0] == declaringClass);
        assert (this.deferredRegistrations != null) : "initial registration is closed - use " + LateRegistration.class.getName() + " for late registrations";
        ClassPlugins classPlugins = (ClassPlugins)this.registrations.get((Object)internalName);
        if (classPlugins == null) {
            classPlugins = new ClassPlugins();
            this.registrations.put((Object)internalName, (Object)classPlugins);
        }
        Binding binding = new Binding(plugin, isStatic, name, argumentTypes);
        classPlugins.register(binding, allowOverwrite);
        return binding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InvocationPlugin get(ResolvedJavaMethod method) {
        if (this.resolvedRegistrations != null) {
            return (InvocationPlugin)this.resolvedRegistrations.get((Object)method);
        }
        if (!method.isBridge()) {
            LateClassPlugins lcp;
            ResolvedJavaType declaringClass = method.getDeclaringClass();
            this.flushDeferrables();
            String internalName = declaringClass.getName();
            ClassPlugins classPlugins = (ClassPlugins)this.registrations.get((Object)internalName);
            InvocationPlugin res = null;
            if (classPlugins != null) {
                res = classPlugins.get(method);
            }
            if (res == null && (lcp = this.findLateClassPlugins(internalName)) != null) {
                res = lcp.get(method);
            }
            if (res != null && (res.isDecorator() || res instanceof GeneratedInvocationPlugin || this.canBeIntrinsified(declaringClass))) {
                return res;
            }
            if (this.testExtensions != null) {
                InvocationPlugins invocationPlugins = this;
                synchronized (invocationPlugins) {
                    List bindings;
                    if (this.testExtensions != null && (bindings = (List)this.testExtensions.get((Object)internalName)) != null) {
                        String name = method.getName();
                        String descriptor = method.getSignature().toMethodDescriptor();
                        for (Binding b : bindings) {
                            if (b.isStatic != method.isStatic() || !b.name.equals(name) || !descriptor.startsWith(b.argumentsDescriptor)) continue;
                            return b.plugin;
                        }
                    }
                }
            }
        }
        return null;
    }

    public boolean canBeIntrinsified(ResolvedJavaType declaringClass) {
        return true;
    }

    public void registerIntrinsificationPredicate(Predicate<ResolvedJavaType> predicate) {
    }

    LateClassPlugins findLateClassPlugins(String internalClassName) {
        LateClassPlugins lcp = this.lateRegistrations;
        while (lcp != null) {
            if (lcp.className.equals(internalClassName)) {
                return lcp;
            }
            lcp = lcp.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushDeferrables() {
        if (this.deferredRegistrations != null) {
            InvocationPlugins invocationPlugins = this;
            synchronized (invocationPlugins) {
                if (this.deferredRegistrations != null) {
                    try {
                        for (Runnable deferrable : this.deferredRegistrations) {
                            deferrable.run();
                        }
                        this.deferredRegistrations = null;
                    }
                    catch (InvocationPluginRegistrationError t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        this.deferredRegistrations.clear();
                        Runnable rethrow = new Runnable(){

                            @Override
                            public void run() {
                                throw new InvocationPluginRegistrationError(t);
                            }
                        };
                        this.deferredRegistrations.add(rethrow);
                        rethrow.run();
                    }
                }
            }
        }
    }

    private static int findBinding(List<Binding> list, Binding key) {
        for (int i = 0; i < list.size(); ++i) {
            Binding b = list.get(i);
            if (b.isStatic != key.isStatic || !b.name.equals(key.name) || !b.argumentsDescriptor.equals(key.argumentsDescriptor)) continue;
            return i;
        }
        return -1;
    }

    public synchronized void addTestPlugins(InvocationPlugins other, List<Pair<String, Binding>> ignored) {
        assert (this.resolvedRegistrations == null) : "registration is closed";
        EconomicMap<String, List<Binding>> otherBindings = other.getBindings(true, false);
        if (otherBindings.isEmpty()) {
            return;
        }
        if (this.testExtensions == null) {
            this.testExtensions = EconomicMap.create();
        }
        MapCursor c = otherBindings.getEntries();
        while (c.advance()) {
            String declaringClass = (String)c.getKey();
            ArrayList<Binding> bindings = (ArrayList<Binding>)this.testExtensions.get((Object)declaringClass);
            if (bindings == null) {
                bindings = new ArrayList<Binding>();
                this.testExtensions.put((Object)declaringClass, bindings);
            }
            for (Binding b : (List)c.getValue()) {
                int index = InvocationPlugins.findBinding(bindings, b);
                if (index != -1) {
                    if (ignored == null) continue;
                    ignored.add((Pair<String, Binding>)Pair.create((Object)declaringClass, (Object)b));
                    continue;
                }
                bindings.add(b);
            }
        }
    }

    public synchronized void removeTestPlugins(InvocationPlugins other) {
        assert (this.resolvedRegistrations == null) : "registration is closed";
        if (this.testExtensions != null) {
            MapCursor c = other.getBindings(false).getEntries();
            while (c.advance()) {
                String declaringClass = (String)c.getKey();
                List bindings = (List)this.testExtensions.get((Object)declaringClass);
                if (bindings == null) continue;
                for (Binding b : (List)c.getValue()) {
                    int index = InvocationPlugins.findBinding(bindings, b);
                    if (index == -1) continue;
                    bindings.remove(index);
                }
                if (!bindings.isEmpty()) continue;
                this.testExtensions.removeKey((Object)declaringClass);
            }
            if (this.testExtensions.isEmpty()) {
                this.testExtensions = null;
            }
        }
    }

    synchronized void registerLate(Type declaringType, List<Binding> bindings) {
        String internalName = MetaUtil.toInternalName((String)declaringType.getTypeName());
        assert (this.findLateClassPlugins(internalName) == null) : "Cannot have more than one late registration of invocation plugins for " + internalName;
        LateClassPlugins lateClassPlugins = new LateClassPlugins(this.lateRegistrations, internalName);
        for (Binding b : bindings) {
            lateClassPlugins.register(b);
        }
        this.lateRegistrations = lateClassPlugins;
    }

    @SuppressFBWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"}, justification="string literal object identity used as sentinel")
    private synchronized boolean closeLateRegistrations() {
        if (this.lateRegistrations == null || this.lateRegistrations.className != "-----") {
            this.lateRegistrations = new LateClassPlugins(this.lateRegistrations, "-----");
        }
        return true;
    }

    public void closeRegistration() {
        assert (this.closeLateRegistrations());
        this.flushDeferrables();
    }

    public boolean isEmpty() {
        if (this.parent != null && !this.parent.isEmpty()) {
            return false;
        }
        UnmodifiableEconomicMap<ResolvedJavaMethod, InvocationPlugin> resolvedRegs = this.resolvedRegistrations;
        if (resolvedRegs != null && !resolvedRegs.isEmpty()) {
            return false;
        }
        List<Runnable> deferred = this.deferredRegistrations;
        if (deferred != null && !deferred.isEmpty()) {
            return false;
        }
        LateClassPlugins late = this.lateRegistrations;
        while (late != null) {
            if (!late.bindings.isEmpty()) {
                return false;
            }
            late = late.next;
        }
        return this.registrations.size() == 0;
    }

    public InvocationPlugins() {
        this(null);
    }

    public InvocationPlugins(InvocationPlugins parent) {
        InvocationPlugins p;
        this.parent = p = parent;
        this.registrations = EconomicMap.create();
        this.resolvedRegistrations = null;
    }

    public InvocationPlugins(Map<ResolvedJavaMethod, InvocationPlugin> plugins, InvocationPlugins parent) {
        this.parent = parent;
        this.registrations = null;
        this.deferredRegistrations = null;
        EconomicMap map = EconomicMap.create((int)plugins.size());
        for (Map.Entry<ResolvedJavaMethod, InvocationPlugin> entry : plugins.entrySet()) {
            map.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.resolvedRegistrations = map;
    }

    protected void register(InvocationPlugin plugin, boolean isOptional, boolean allowOverwrite, Type declaringClass, String name, Type ... argumentTypes) {
        boolean isStatic;
        boolean bl = isStatic = argumentTypes.length == 0 || argumentTypes[0] != InvocationPlugin.Receiver.class;
        if (!isStatic) {
            argumentTypes[0] = declaringClass;
        }
        Binding binding = this.put(plugin, isStatic, allowOverwrite, declaringClass, name, argumentTypes);
        assert (Services.IS_IN_NATIVE_IMAGE || Checks.check(this, declaringClass, binding));
        assert (Services.IS_IN_NATIVE_IMAGE || Checks.checkResolvable(isOptional, declaringClass, binding));
    }

    public final void register(InvocationPlugin plugin, Type declaringClass, String name, Type ... argumentTypes) {
        this.register(plugin, false, false, declaringClass, name, argumentTypes);
    }

    public final void register(InvocationPlugin plugin, String declaringClass, String name, Type ... argumentTypes) {
        this.register(plugin, false, false, (Type)new OptionalLazySymbol(declaringClass), name, argumentTypes);
    }

    public final void registerOptional(InvocationPlugin plugin, Type declaringClass, String name, Type ... argumentTypes) {
        this.register(plugin, true, false, declaringClass, name, argumentTypes);
    }

    public InvocationPlugin lookupInvocation(ResolvedJavaMethod method, boolean allowDecorators) {
        InvocationPlugin plugin;
        if (this.parent != null && (plugin = this.parent.lookupInvocation(method, allowDecorators)) != null) {
            return plugin;
        }
        InvocationPlugin invocationPlugin = this.get(method);
        if (invocationPlugin == null || allowDecorators || !invocationPlugin.isDecorator()) {
            return invocationPlugin;
        }
        return null;
    }

    public InvocationPlugin lookupInvocation(ResolvedJavaMethod method) {
        return this.lookupInvocation(method, false);
    }

    public EconomicMap<String, List<Binding>> getBindings(boolean includeParents) {
        return this.getBindings(includeParents, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EconomicMap<String, List<Binding>> getBindings(boolean includeParents, boolean flushDeferrables) {
        EconomicMap res = EconomicMap.create((Equivalence)Equivalence.DEFAULT);
        if (this.parent != null && includeParents) {
            res.putAll(this.parent.getBindings(true, flushDeferrables));
        }
        if (this.resolvedRegistrations != null) {
            UnmodifiableMapCursor cursor = this.resolvedRegistrations.getEntries();
            while (cursor.advance()) {
                ResolvedJavaMethod method = (ResolvedJavaMethod)cursor.getKey();
                InvocationPlugin plugin = (InvocationPlugin)cursor.getValue();
                String type = method.getDeclaringClass().getName();
                ArrayList<Binding> bindings = (ArrayList<Binding>)res.get((Object)type);
                if (bindings == null) {
                    bindings = new ArrayList<Binding>();
                    res.put((Object)type, bindings);
                }
                bindings.add(new Binding(method, plugin));
            }
        } else {
            if (flushDeferrables) {
                this.flushDeferrables();
            }
            MapCursor classes = this.registrations.getEntries();
            while (classes.advance()) {
                String type = (String)classes.getKey();
                ClassPlugins cp = (ClassPlugins)classes.getValue();
                InvocationPlugins.collectBindingsTo((EconomicMap<String, List<Binding>>)res, type, cp);
            }
            LateClassPlugins lcp = this.lateRegistrations;
            while (lcp != null) {
                String type = lcp.className;
                InvocationPlugins.collectBindingsTo((EconomicMap<String, List<Binding>>)res, type, lcp);
                lcp = lcp.next;
            }
            if (this.testExtensions != null) {
                InvocationPlugins invocationPlugins = this;
                synchronized (invocationPlugins) {
                    if (this.testExtensions != null) {
                        MapCursor c = this.testExtensions.getEntries();
                        while (c.advance()) {
                            String name = (String)c.getKey();
                            ArrayList bindings = (ArrayList)res.get((Object)name);
                            if (bindings == null) {
                                bindings = new ArrayList();
                                res.put((Object)name, bindings);
                            }
                            bindings.addAll((Collection)c.getValue());
                        }
                    }
                }
            }
        }
        return res;
    }

    private static void collectBindingsTo(EconomicMap<String, List<Binding>> res, String type, ClassPlugins cp) {
        MapCursor methods = cp.bindings.getEntries();
        while (methods.advance()) {
            ArrayList<Binding> bindings = (ArrayList<Binding>)res.get((Object)type);
            if (bindings == null) {
                bindings = new ArrayList<Binding>();
                res.put((Object)type, bindings);
            }
            Binding b = (Binding)methods.getValue();
            while (b != null) {
                bindings.add(b);
                b = b.next;
            }
        }
    }

    public InvocationPlugins getParent() {
        return this.parent;
    }

    public String toString() {
        MapCursor entries = this.getBindings(false, false).getEntries();
        ArrayList<String> all = new ArrayList<String>();
        while (entries.advance()) {
            String c = MetaUtil.internalNameToJava((String)((String)entries.getKey()), (boolean)true, (boolean)false);
            for (Binding b : (List)entries.getValue()) {
                all.add(c + '.' + b);
            }
        }
        Collections.sort(all);
        StringBuilder buf = new StringBuilder();
        String nl = String.format("%n", new Object[0]);
        for (String s : all) {
            if (buf.length() != 0) {
                buf.append(nl);
            }
            buf.append(s);
        }
        if (this.parent != null) {
            if (buf.length() != 0) {
                buf.append(nl);
            }
            buf.append("// parent").append(nl).append(this.parent);
        }
        return buf.toString();
    }

    public void checkNewNodes(GraphBuilderContext b, InvocationPlugin plugin, NodeIterable<Node> newNodes) {
        if (this.parent != null) {
            this.parent.checkNewNodes(b, plugin, newNodes);
        }
    }

    public static Class<?> resolveClass(String className, boolean optional) {
        try {
            ClassLoader cl = ClassLoader.getSystemClassLoader();
            return Class.forName(className, false, cl);
        }
        catch (ClassNotFoundException e) {
            if (optional) {
                return null;
            }
            throw new GraalError("Could not resolve type " + className);
        }
    }

    public static Class<?> resolveType(Type type, boolean optional) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof OptionalLazySymbol) {
            return ((OptionalLazySymbol)type).resolve();
        }
        if (Services.IS_IN_NATIVE_IMAGE) {
            throw new GraalError("Unresolved type in native image image:" + type.getTypeName());
        }
        return InvocationPlugins.resolveClass(type.getTypeName(), optional);
    }

    private static List<String> toInternalTypeNames(Class<?>[] types) {
        String[] res = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            res[i] = MetaUtil.toInternalName((String)types[i].getTypeName());
        }
        return Arrays.asList(res);
    }

    public static Method resolveMethod(Class<?> declaringClass, Binding binding) {
        if (binding.name.equals("<init>")) {
            return null;
        }
        Method[] methods = declaringClass.getDeclaredMethods();
        List<String> parameterTypeNames = InvocationPlugins.parseParameters(binding.argumentsDescriptor);
        Method match = null;
        for (int i = 0; i < methods.length; ++i) {
            Method m = methods[i];
            if (binding.isStatic != Modifier.isStatic(m.getModifiers()) || !m.getName().equals(binding.name) || !parameterTypeNames.equals(InvocationPlugins.toInternalTypeNames(m.getParameterTypes()))) continue;
            if (match == null) {
                match = m;
                continue;
            }
            if (match.getReturnType().isAssignableFrom(m.getReturnType())) {
                match = m;
                continue;
            }
            if (m.getReturnType().isAssignableFrom(match.getReturnType())) continue;
            throw new NoSuchMethodError(String.format("Found 2 methods with same name and parameter types but unrelated return types:%n %s%n %s", match, m));
        }
        return match;
    }

    public static ResolvedJavaMethod resolveJavaMethod(ResolvedJavaType declaringClass, Binding binding) {
        ResolvedJavaMethod[] methods = declaringClass.getDeclaredMethods();
        if (binding.name.equals("<init>")) {
            for (ResolvedJavaMethod m : methods) {
                if (!m.getName().equals("<init>") || !m.getSignature().toMethodDescriptor().startsWith(binding.argumentsDescriptor)) continue;
                return m;
            }
            return null;
        }
        ResolvedJavaMethod match = null;
        for (int i = 0; i < methods.length; ++i) {
            ResolvedJavaType mReturnType;
            ResolvedJavaMethod m = methods[i];
            if (binding.isStatic != m.isStatic() || !m.getName().equals(binding.name) || !m.getSignature().toMethodDescriptor().startsWith(binding.argumentsDescriptor)) continue;
            if (match == null) {
                match = m;
                continue;
            }
            ResolvedJavaType matchReturnType = (ResolvedJavaType)match.getSignature().getReturnType(declaringClass);
            if (matchReturnType.isAssignableFrom(mReturnType = (ResolvedJavaType)m.getSignature().getReturnType(declaringClass))) {
                match = m;
                continue;
            }
            if (mReturnType.isAssignableFrom(matchReturnType)) continue;
            throw new NoSuchMethodError(String.format("Found 2 methods with same name and parameter types but unrelated return types:%n %s%n %s", match, m));
        }
        return match;
    }

    public static Constructor<?> resolveConstructor(Class<?> declaringClass, Binding binding) {
        if (!binding.name.equals("<init>")) {
            return null;
        }
        Constructor<?>[] constructors = declaringClass.getDeclaredConstructors();
        List<String> parameterTypeNames = InvocationPlugins.parseParameters(binding.argumentsDescriptor);
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (!parameterTypeNames.equals(InvocationPlugins.toInternalTypeNames(c.getParameterTypes()))) continue;
            return c;
        }
        return null;
    }

    private static List<String> parseParameters(String argumentsDescriptor) {
        assert (argumentsDescriptor.startsWith("(") && argumentsDescriptor.endsWith(")")) : argumentsDescriptor;
        ArrayList<String> res = new ArrayList<String>();
        int cur = 1;
        int end = argumentsDescriptor.length() - 1;
        while (cur != end) {
            char first;
            int start = cur;
            while ((first = argumentsDescriptor.charAt(cur++)) == '[') {
            }
            switch (first) {
                case 'L': {
                    int endObject = argumentsDescriptor.indexOf(59, cur);
                    if (endObject == -1) {
                        throw new GraalError("Invalid object type at index %d in signature: %s", cur, argumentsDescriptor);
                    }
                    cur = endObject + 1;
                    break;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    break;
                }
                default: {
                    throw new GraalError("Invalid character at index %d in signature: %s", cur, argumentsDescriptor);
                }
            }
            res.add(argumentsDescriptor.substring(start, cur));
        }
        return res;
    }

    private static class Checks {
        private static final int MAX_ARITY = 7;
        static final Class<?>[][] SIGS;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Checks() {
        }

        static boolean containsBinding(InvocationPlugins p, Type declaringType, Binding key) {
            String internalName = MetaUtil.toInternalName((String)declaringType.getTypeName());
            ClassPlugins classPlugins = (ClassPlugins)p.registrations.get((Object)internalName);
            return classPlugins != null && classPlugins.lookup(key) != null;
        }

        public static boolean check(InvocationPlugins plugins, Type declaringType, Binding binding) {
            InvocationPlugin plugin = binding.plugin;
            InvocationPlugins p = plugins.parent;
            while (p != null) {
                if (!$assertionsDisabled && Checks.containsBinding(p, declaringType, binding)) {
                    throw new AssertionError((Object)("a plugin is already registered for " + binding));
                }
                p = p.parent;
            }
            if (plugin instanceof ForeignCallPlugin || plugin instanceof GeneratedInvocationPlugin) {
                return true;
            }
            if (plugin instanceof MethodSubstitutionPlugin) {
                MethodSubstitutionPlugin msplugin = (MethodSubstitutionPlugin)plugin;
                Method substitute = msplugin.getJavaSubstitute();
                if (!$assertionsDisabled && substitute.getAnnotation(MethodSubstitution.class) == null) {
                    throw new AssertionError((Object)String.format("Substitute method must be annotated with @%s: %s", MethodSubstitution.class.getSimpleName(), substitute));
                }
                return true;
            }
            int arguments = InvocationPlugins.parseParameters(binding.argumentsDescriptor).size();
            if (!$assertionsDisabled && arguments >= SIGS.length) {
                throw new AssertionError((Object)String.format("need to extend %s to support method with %d arguments: %s", InvocationPlugin.class.getSimpleName(), arguments, binding));
            }
            for (Method m : plugin.getClass().getDeclaredMethods()) {
                Object[] parameterTypes;
                if (m.getName().equals("defaultHandler")) {
                    return true;
                }
                if (!m.getName().equals("apply") || !Arrays.equals(SIGS[arguments], parameterTypes = m.getParameterTypes())) continue;
                return true;
            }
            throw new AssertionError((Object)String.format("graph builder plugin for %s not found", binding));
        }

        static boolean checkResolvable(boolean isOptional, Type declaringType, Binding binding) {
            if (declaringType instanceof ResolvedJavaSymbol) {
                return Checks.checkResolvable(isOptional, ((ResolvedJavaSymbol)declaringType).getResolved(), binding);
            }
            Class<?> declaringClass = InvocationPlugins.resolveType(declaringType, isOptional);
            if (declaringClass == null) {
                return true;
            }
            if (binding.name.equals("<init>")) {
                if (InvocationPlugins.resolveConstructor(declaringClass, binding) == null && !isOptional) {
                    throw new AssertionError((Object)String.format("Constructor not found: %s%s", declaringClass.getName(), binding.argumentsDescriptor));
                }
            } else if (InvocationPlugins.resolveMethod(declaringClass, binding) == null && !isOptional) {
                throw new NoSuchMethodError(String.format("%s.%s%s", declaringClass.getName(), binding.name, binding.argumentsDescriptor));
            }
            return true;
        }

        private static boolean checkResolvable(boolean isOptional, ResolvedJavaType declaringType, Binding binding) {
            if (InvocationPlugins.resolveJavaMethod(declaringType, binding) == null && !isOptional) {
                throw new AssertionError((Object)String.format("Method not found: %s.%s%s", declaringType.toJavaName(), binding.name, binding.argumentsDescriptor));
            }
            return true;
        }

        static {
            boolean bl = $assertionsDisabled = !InvocationPlugins.class.desiredAssertionStatus();
            if (!Assertions.assertionsEnabled() && !Services.IS_BUILDING_NATIVE_IMAGE) {
                throw new GraalError("%s must only be used in assertions", Checks.class.getName());
            }
            ArrayList<Class<?>[]> sigs = new ArrayList<Class<?>[]>(7);
            if (!Services.IS_IN_NATIVE_IMAGE) {
                for (Method method : InvocationPlugin.class.getDeclaredMethods()) {
                    if (Modifier.isStatic(method.getModifiers()) || !method.getName().equals("apply")) continue;
                    Class<?>[] sig = method.getParameterTypes();
                    if (!$assertionsDisabled && sig[0] != GraphBuilderContext.class) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && sig[1] != ResolvedJavaMethod.class) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && sig[2] != InvocationPlugin.Receiver.class) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && !Arrays.asList(sig).subList(3, sig.length).stream().allMatch(c -> c == ValueNode.class)) {
                        throw new AssertionError();
                    }
                    while (sigs.size() < sig.length - 2) {
                        sigs.add(null);
                    }
                    sigs.set(sig.length - 3, sig);
                }
                if (!$assertionsDisabled && sigs.indexOf(null) != -1) {
                    throw new AssertionError((Object)String.format("need to add an apply() method to %s that takes %d %s arguments ", InvocationPlugin.class.getName(), sigs.indexOf(null), ValueNode.class.getSimpleName()));
                }
            }
            SIGS = (Class[][])sigs.toArray((T[])new Class[sigs.size()][]);
        }
    }

    static class InvocationPluginRegistrationError
    extends GraalError {
        InvocationPluginRegistrationError(Throwable cause) {
            super(cause);
        }
    }

    static class LateClassPlugins
    extends ClassPlugins {
        static final String CLOSED_LATE_CLASS_PLUGIN = "-----";
        private final String className;
        private final LateClassPlugins next;

        LateClassPlugins(LateClassPlugins next, String className) {
            assert (next == null || next.className != CLOSED_LATE_CLASS_PLUGIN) : "Late registration of invocation plugins is closed";
            this.next = next;
            this.className = className;
        }
    }

    static class ClassPlugins {
        final EconomicMap<String, Binding> bindings = EconomicMap.create((Equivalence)Equivalence.DEFAULT);

        ClassPlugins() {
        }

        InvocationPlugin get(ResolvedJavaMethod method) {
            assert (!method.isBridge());
            Binding binding = (Binding)this.bindings.get((Object)method.getName());
            while (binding != null) {
                if (method.isStatic() == binding.isStatic && method.getSignature().toMethodDescriptor().startsWith(binding.argumentsDescriptor)) {
                    return binding.plugin;
                }
                binding = binding.next;
            }
            return null;
        }

        public void register(Binding binding, boolean allowOverwrite) {
            if (allowOverwrite) {
                if (this.lookup(binding) != null) {
                    this.register(binding);
                    return;
                }
            } else assert (this.lookup(binding) == null) : "a value is already registered for " + binding;
            this.register(binding);
        }

        InvocationPlugin lookup(Binding binding) {
            Binding b = (Binding)this.bindings.get((Object)binding.name);
            while (b != null) {
                if (b.isStatic == binding.isStatic && b.argumentsDescriptor.equals(binding.argumentsDescriptor)) {
                    return b.plugin;
                }
                b = b.next;
            }
            return null;
        }

        void register(Binding binding) {
            Binding head = (Binding)this.bindings.get((Object)binding.name);
            assert (binding.next == null);
            binding.next = head;
            this.bindings.put((Object)binding.name, (Object)binding);
        }
    }

    public static class Binding {
        public final InvocationPlugin plugin;
        public final boolean isStatic;
        public final String name;
        public final String argumentsDescriptor;
        private Binding next;

        Binding(InvocationPlugin data, boolean isStatic, String name, Type ... argumentTypes) {
            this.plugin = data;
            this.isStatic = isStatic;
            this.name = name;
            this.argumentsDescriptor = InvocationPlugins.toArgumentDescriptor(isStatic, argumentTypes);
            assert (!name.equals("<init>") || !isStatic) : this;
        }

        Binding(ResolvedJavaMethod resolved, InvocationPlugin data) {
            this.plugin = data;
            this.isStatic = resolved.isStatic();
            this.name = resolved.getName();
            Signature sig = resolved.getSignature();
            String desc = sig.toMethodDescriptor();
            assert (desc.indexOf(41) != -1) : desc;
            this.argumentsDescriptor = desc.substring(0, desc.indexOf(41) + 1);
            assert (!this.name.equals("<init>") || !this.isStatic) : this;
        }

        public String toString() {
            return this.name + this.argumentsDescriptor;
        }
    }

    public static class LateRegistration
    implements AutoCloseable {
        private InvocationPlugins plugins;
        private final List<Binding> bindings = new ArrayList<Binding>();
        private final Type declaringType;

        public LateRegistration(InvocationPlugins plugins, Type declaringType) {
            this.plugins = plugins;
            this.declaringType = declaringType;
        }

        public void register(InvocationPlugin plugin, String name, Type ... argumentTypes) {
            boolean isStatic;
            assert (this.plugins != null) : String.format("Late registrations of invocation plugins for %s is already closed", this.declaringType);
            boolean bl = isStatic = argumentTypes.length == 0 || argumentTypes[0] != InvocationPlugin.Receiver.class;
            if (!isStatic) {
                argumentTypes[0] = this.declaringType;
            }
            assert (isStatic || argumentTypes[0] == this.declaringType);
            Binding binding = new Binding(plugin, isStatic, name, argumentTypes);
            this.bindings.add(binding);
            assert (Services.IS_IN_NATIVE_IMAGE || Checks.check(this.plugins, this.declaringType, binding));
            assert (Services.IS_IN_NATIVE_IMAGE || Checks.checkResolvable(false, this.declaringType, binding));
        }

        @Override
        public void close() {
            assert (this.plugins != null) : String.format("Late registrations of invocation plugins for %s is already closed", this.declaringType);
            this.plugins.registerLate(this.declaringType, this.bindings);
            this.plugins = null;
        }
    }

    public static class Registration {
        private final InvocationPlugins plugins;
        private final Type declaringType;
        private final Replacements replacements;
        private final BytecodeProvider bytecodeProvider;
        private boolean allowOverwrite;

        public Class<?> getReceiverType() {
            return InvocationPlugin.Receiver.class;
        }

        public Type getDeclaringType() {
            return this.declaringType;
        }

        public Registration(InvocationPlugins plugins, Type declaringType) {
            this.plugins = plugins;
            this.declaringType = declaringType;
            this.replacements = null;
            this.bytecodeProvider = null;
        }

        public Registration(InvocationPlugins plugins, Type declaringType, Replacements replacements) {
            this.plugins = plugins;
            this.declaringType = declaringType;
            this.replacements = replacements;
            this.bytecodeProvider = replacements != null ? replacements.getDefaultReplacementBytecodeProvider() : null;
        }

        public Registration(InvocationPlugins plugins, Type declaringType, Replacements replacements, BytecodeProvider bytecodeProvider) {
            this.plugins = plugins;
            this.declaringType = declaringType;
            this.replacements = replacements;
            this.bytecodeProvider = bytecodeProvider;
        }

        public Registration(InvocationPlugins plugins, String declaringClassName) {
            this.plugins = plugins;
            this.declaringType = new OptionalLazySymbol(declaringClassName);
            this.replacements = null;
            this.bytecodeProvider = null;
        }

        public Registration(InvocationPlugins plugins, String declaringClassName, Replacements replacements) {
            this.plugins = plugins;
            this.declaringType = new OptionalLazySymbol(declaringClassName);
            this.replacements = replacements;
            this.bytecodeProvider = replacements != null ? replacements.getDefaultReplacementBytecodeProvider() : null;
        }

        public Registration setAllowOverwrite(boolean allowOverwrite) {
            this.allowOverwrite = allowOverwrite;
            return this;
        }

        public void register0(String name, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, new Type[0]);
        }

        public void register1(String name, Type arg, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg);
        }

        public void register2(String name, Type arg1, Type arg2, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2);
        }

        public void register3(String name, Type arg1, Type arg2, Type arg3, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3);
        }

        public void register4(String name, Type arg1, Type arg2, Type arg3, Type arg4, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4);
        }

        public void register5(String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5);
        }

        public void register6(String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, Type arg6, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public void register7(String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, Type arg6, Type arg7, InvocationPlugin plugin) {
            this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
        }

        public void registerConditional0(boolean isEnabled, String name, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, new Type[0]);
            }
        }

        public void registerConditional1(boolean isEnabled, String name, Type arg, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg);
            }
        }

        public void registerConditional2(boolean isEnabled, String name, Type arg1, Type arg2, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2);
            }
        }

        public void registerConditional3(boolean isEnabled, String name, Type arg1, Type arg2, Type arg3, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3);
            }
        }

        public void registerConditional4(boolean isEnabled, String name, Type arg1, Type arg2, Type arg3, Type arg4, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4);
            }
        }

        public void registerConditional5(boolean isEnabled, String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5);
            }
        }

        public void registerConditional6(boolean isEnabled, String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, Type arg6, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5, arg6);
            }
        }

        public void registerConditional7(boolean isEnabled, String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, Type arg6, Type arg7, InvocationPlugin plugin) {
            this.replacements.registerConditionalPlugin(plugin);
            if (isEnabled) {
                this.plugins.register(plugin, false, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5, arg6, arg7);
            }
        }

        public void registerOptional0(String name, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, new Type[0]);
        }

        public void registerOptional1(String name, Type arg, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, arg);
        }

        public void registerOptional2(String name, Type arg1, Type arg2, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, arg1, arg2);
        }

        public void registerOptional3(String name, Type arg1, Type arg2, Type arg3, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3);
        }

        public void registerOptional4(String name, Type arg1, Type arg2, Type arg3, Type arg4, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4);
        }

        public void registerOptional5(String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5);
        }

        public void registerOptional6(String name, Type arg1, Type arg2, Type arg3, Type arg4, Type arg5, Type arg6, InvocationPlugin plugin) {
            this.plugins.register(plugin, true, this.allowOverwrite, this.declaringType, name, arg1, arg2, arg3, arg4, arg5, arg6);
        }

        public void registerMethodSubstitution(Class<?> substituteDeclaringClass, String name, Type ... argumentTypes) {
            this.registerMethodSubstitution(substituteDeclaringClass, name, name, argumentTypes);
        }

        public void registerMethodSubstitution(Class<?> substituteDeclaringClass, String name, String substituteName, Type ... argumentTypes) {
            this.doMethodSubstitutionRegistration(false, true, substituteDeclaringClass, name, substituteName, argumentTypes);
        }

        public void registerConditionalMethodSubstitution(boolean isEnabled, Class<?> substituteDeclaringClass, String name, Type ... argumentTypes) {
            this.registerConditionalMethodSubstitution(isEnabled, substituteDeclaringClass, name, name, argumentTypes);
        }

        public void registerConditionalMethodSubstitution(boolean isEnabled, Class<?> substituteDeclaringClass, String name, String substituteName, Type ... argumentTypes) {
            this.doMethodSubstitutionRegistration(true, isEnabled, substituteDeclaringClass, name, substituteName, argumentTypes);
        }

        private void doMethodSubstitutionRegistration(boolean isConditional, boolean isEnabled, Class<?> substituteDeclaringClass, String name, String substituteName, Type[] argumentTypes) {
            MethodSubstitutionPlugin plugin = new MethodSubstitutionPlugin(this, this.bytecodeProvider, name, substituteDeclaringClass, substituteName, argumentTypes);
            this.replacements.registerMethodSubstitution(plugin);
            if (isConditional) {
                this.replacements.registerConditionalPlugin(plugin);
            }
            if (isEnabled) {
                this.plugins.register((InvocationPlugin)plugin, false, this.allowOverwrite, this.declaringType, name, argumentTypes);
            }
        }
    }

    static class OptionalLazySymbol
    implements Type {
        private static final Class<?> MASK_NULL = OptionalLazySymbol.class;
        private final String name;
        private Class<?> resolved;

        OptionalLazySymbol(String name) {
            this.name = name;
            if (Services.IS_BUILDING_NATIVE_IMAGE) {
                this.resolve();
            }
        }

        @Override
        public String getTypeName() {
            return this.name;
        }

        public Class<?> resolve() {
            if (!Services.IS_IN_NATIVE_IMAGE && this.resolved == null) {
                Class<?> resolvedOrNull = InvocationPlugins.resolveClass(this.name, true);
                this.resolved = resolvedOrNull == null ? MASK_NULL : resolvedOrNull;
            }
            return this.resolved == MASK_NULL ? null : this.resolved;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ResolvedJavaSymbol
    implements Type {
        private final ResolvedJavaType resolved;

        public ResolvedJavaSymbol(ResolvedJavaType type) {
            this.resolved = type;
        }

        public ResolvedJavaType getResolved() {
            return this.resolved;
        }

        public String toString() {
            return this.resolved.toJavaName();
        }
    }

    public static class InvocationPluginReceiver
    implements InvocationPlugin.Receiver {
        private final GraphBuilderContext parser;
        private ValueNode[] args;
        private ValueNode value;

        public InvocationPluginReceiver(GraphBuilderContext parser) {
            this.parser = parser;
        }

        @Override
        public ValueNode get(boolean performNullCheck) {
            assert (this.args != null) : "Cannot get the receiver of a static method";
            if (!performNullCheck) {
                return this.args[0];
            }
            if (this.value == null) {
                this.value = this.parser.nullCheckedValue(this.args[0]);
                if (this.value != this.args[0]) {
                    this.args[0] = this.value;
                }
            }
            return this.value;
        }

        @Override
        public boolean isConstant() {
            return this.args[0].isConstant();
        }

        public InvocationPluginReceiver init(ResolvedJavaMethod targetMethod, ValueNode[] newArgs) {
            if (!targetMethod.isStatic()) {
                this.args = newArgs;
                this.value = null;
                return this;
            }
            return null;
        }
    }
}

