/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.calc.CanonicalCondition;
import org.graalvm.compiler.core.common.memory.MemoryOrderMode;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.LogicConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.CompareNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.ObjectEqualsNode;
import org.graalvm.compiler.nodes.memory.AbstractMemoryCheckpoint;
import org.graalvm.compiler.nodes.memory.OrderedMemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.Virtualizable;
import org.graalvm.compiler.nodes.spi.VirtualizerTool;
import org.graalvm.compiler.nodes.virtual.VirtualArrayNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Value, InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_8)
public abstract class AbstractUnsafeCompareAndSwapNode
extends AbstractMemoryCheckpoint
implements OrderedMemoryAccess,
Lowerable,
SingleMemoryKill,
Virtualizable {
    public static final NodeClass<AbstractUnsafeCompareAndSwapNode> TYPE = NodeClass.create(AbstractUnsafeCompareAndSwapNode.class);
    @Node.Input
    ValueNode object;
    @Node.Input
    ValueNode offset;
    @Node.Input
    ValueNode expected;
    @Node.Input
    ValueNode newValue;
    protected final JavaKind valueKind;
    protected final LocationIdentity locationIdentity;
    protected final MemoryOrderMode memoryOrder;

    public AbstractUnsafeCompareAndSwapNode(NodeClass<? extends AbstractMemoryCheckpoint> c, Stamp stamp, ValueNode object, ValueNode offset, ValueNode expected, ValueNode newValue, JavaKind valueKind, LocationIdentity locationIdentity, MemoryOrderMode memoryOrder) {
        super(c, stamp);
        this.object = object;
        this.offset = offset;
        this.expected = expected;
        this.newValue = newValue;
        this.valueKind = valueKind;
        this.locationIdentity = locationIdentity;
        this.memoryOrder = memoryOrder;
    }

    public ValueNode object() {
        return this.object;
    }

    public ValueNode offset() {
        return this.offset;
    }

    public ValueNode expected() {
        return this.expected;
    }

    public ValueNode newValue() {
        return this.newValue;
    }

    public JavaKind getValueKind() {
        return this.valueKind;
    }

    @Override
    public MemoryOrderMode getMemoryOrder() {
        return this.memoryOrder;
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.locationIdentity;
    }

    @Override
    public void virtualize(VirtualizerTool tool) {
        ValueNode fieldValue;
        int index;
        VirtualObjectNode obj;
        ValueNode offsetAlias = tool.getAlias(this.offset);
        if (!offsetAlias.isJavaConstant()) {
            return;
        }
        long constantOffset = offsetAlias.asJavaConstant().asLong();
        ValueNode objectAlias = tool.getAlias(this.object);
        if (objectAlias instanceof VirtualInstanceNode) {
            obj = (VirtualInstanceNode)objectAlias;
            ResolvedJavaField field = obj.type().findInstanceFieldWithOffset(constantOffset, this.expected.getStackKind());
            if (field == null) {
                tool.getDebug().log(4, "%s.virtualize() -> Unknown field", (Object)this);
                return;
            }
            index = obj.fieldIndex(field);
        } else if (objectAlias instanceof VirtualArrayNode) {
            VirtualArrayNode array = (VirtualArrayNode)objectAlias;
            index = array.entryIndexForOffset(tool.getMetaAccess(), constantOffset, this.valueKind);
        } else {
            return;
        }
        if (index < 0) {
            tool.getDebug().log(4, "%s.virtualize() -> Unknown index", (Object)this);
            return;
        }
        obj = (VirtualObjectNode)objectAlias;
        ValueNode currentValue = tool.getEntry(obj, index);
        ValueNode expectedAlias = tool.getAlias(this.expected);
        LogicNode equalsNode = null;
        if (this.valueKind.isObject()) {
            equalsNode = ObjectEqualsNode.virtualizeComparison(expectedAlias, currentValue, this.graph(), tool);
        }
        if (equalsNode == null && !(expectedAlias instanceof VirtualObjectNode) && !(currentValue instanceof VirtualObjectNode)) {
            equalsNode = CompareNode.createCompareNode(CanonicalCondition.EQ, expectedAlias, currentValue, tool.getConstantReflection(), NodeView.DEFAULT);
        }
        if (equalsNode == null) {
            tool.getDebug().log(4, "%s.virtualize() -> Expected and/or current values are virtual and the comparison can not be folded", (Object)this);
            return;
        }
        ValueNode newValueAlias = tool.getAlias(this.newValue);
        if (equalsNode instanceof LogicConstantNode) {
            fieldValue = ((LogicConstantNode)equalsNode).getValue() ? this.newValue : currentValue;
        } else {
            if (currentValue instanceof VirtualObjectNode || newValueAlias instanceof VirtualObjectNode) {
                tool.getDebug().log(4, "%s.virtualize() -> Unknown outcome and current or new value is virtual", (Object)this);
                return;
            }
            fieldValue = ConditionalNode.create(equalsNode, newValueAlias, currentValue, NodeView.DEFAULT);
        }
        if (!tool.setVirtualEntry(obj, index, fieldValue, this.valueKind, constantOffset)) {
            tool.getDebug().log(4, "%s.virtualize() -> Could not set virtual entry", (Object)this);
            return;
        }
        tool.getDebug().log(4, "%s.virtualize() -> Success: virtualizing", (Object)this);
        tool.ensureAdded(equalsNode);
        tool.ensureAdded(fieldValue);
        this.finishVirtualize(tool, equalsNode, currentValue);
    }

    protected abstract void finishVirtualize(VirtualizerTool var1, LogicNode var2, ValueNode var3);
}

