/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodeinfo.Verbosity;
import org.graalvm.compiler.nodes.FixedWithNextNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.Lowerable;

@NodeInfo(cycles=NodeCycles.CYCLES_2, size=NodeSize.SIZE_1)
public abstract class AccessFieldNode
extends FixedWithNextNode
implements Lowerable {
    public static final NodeClass<AccessFieldNode> TYPE = NodeClass.create(AccessFieldNode.class);
    @Node.OptionalInput
    ValueNode object;
    protected final ResolvedJavaField field;
    protected final boolean volatileAccess;

    public ValueNode object() {
        return this.object;
    }

    public AccessFieldNode(NodeClass<? extends AccessFieldNode> c, Stamp stamp, ValueNode object, ResolvedJavaField field, boolean volatileAccess) {
        super((NodeClass<? extends FixedWithNextNode>)c, stamp);
        this.object = object;
        this.field = field;
        this.volatileAccess = volatileAccess;
    }

    public AccessFieldNode(NodeClass<? extends AccessFieldNode> c, Stamp stamp, ValueNode object, ResolvedJavaField field) {
        this(c, stamp, object, field, field.isVolatile());
    }

    public ResolvedJavaField field() {
        return this.field;
    }

    public boolean isStatic() {
        return this.field.isStatic();
    }

    public boolean isVolatile() {
        return this.volatileAccess;
    }

    @Override
    public String toString(Verbosity verbosity) {
        if (verbosity == Verbosity.Name) {
            return super.toString(verbosity) + "#" + this.field.getName();
        }
        return super.toString(verbosity);
    }

    @Override
    public boolean verify() {
        this.assertTrue(this.object == null == this.isStatic(), "static field must not have object, instance field must have object", new Object[0]);
        return super.verify();
    }

    @Override
    protected NodeSize dynamicNodeSizeEstimate() {
        if (this.isVolatile()) {
            return NodeSize.SIZE_2;
        }
        return super.dynamicNodeSizeEstimate();
    }
}

