/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.StateSplit;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.memory.FixedAccessNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.SingleMemoryKill;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(allowedUsageTypes={InputType.Memory}, cycles=NodeCycles.CYCLES_8, size=NodeSize.SIZE_2)
public final class LoweredAtomicReadAndAddNode
extends FixedAccessNode
implements StateSplit,
LIRLowerableAccess,
SingleMemoryKill {
    public static final NodeClass<LoweredAtomicReadAndAddNode> TYPE = NodeClass.create(LoweredAtomicReadAndAddNode.class);
    @Node.Input
    ValueNode delta;
    @Node.OptionalInput(value=InputType.State)
    FrameState stateAfter;
    private final ValueKind<?> valueKind;

    public LoweredAtomicReadAndAddNode(AddressNode address, LocationIdentity location, ValueNode delta, ValueKind<?> valueKind, OnHeapMemoryAccess.BarrierType barrierType) {
        super(TYPE, address, location, delta.stamp(NodeView.DEFAULT).unrestricted(), barrierType);
        this.delta = delta;
        this.valueKind = valueKind;
    }

    @Override
    public FrameState stateAfter() {
        return this.stateAfter;
    }

    @Override
    public void setStateAfter(FrameState x) {
        assert (x == null || x.isAlive()) : "frame state must be in a graph";
        this.updateUsages(this.stateAfter, x);
        this.stateAfter = x;
    }

    @Override
    public boolean hasSideEffect() {
        return true;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        Value result = gen.getLIRGeneratorTool().emitAtomicReadAndAdd(gen.operand(this.getAddress()), this.valueKind, gen.operand(this.delta()));
        gen.setResult(this, result);
    }

    @Override
    public boolean canNullCheck() {
        return false;
    }

    public ValueNode delta() {
        return this.delta;
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.stamp(view);
    }

    @Override
    public LocationIdentity getKilledLocationIdentity() {
        return this.getLocationIdentity();
    }
}

