/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.loop;

import org.graalvm.compiler.core.common.type.IntegerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.IntegerConvertNode;
import org.graalvm.compiler.nodes.calc.NegateNode;
import org.graalvm.compiler.nodes.loop.DerivedInductionVariable;
import org.graalvm.compiler.nodes.loop.InductionVariable;
import org.graalvm.compiler.nodes.loop.LoopEx;
import org.graalvm.compiler.nodes.loop.MathUtil;
import org.graalvm.compiler.nodes.util.GraphUtil;

public class DerivedScaledInductionVariable
extends DerivedInductionVariable {
    protected final ValueNode scale;
    protected final ValueNode value;

    public DerivedScaledInductionVariable(LoopEx loop, InductionVariable base, ValueNode scale, ValueNode value) {
        super(loop, base);
        this.scale = scale;
        this.value = value;
    }

    public DerivedScaledInductionVariable(LoopEx loop, InductionVariable base, NegateNode value) {
        super(loop, base);
        this.scale = ConstantNode.forIntegerStamp(value.stamp(NodeView.DEFAULT), -1L, value.graph());
        this.value = value;
    }

    public ValueNode getScale() {
        return this.scale;
    }

    @Override
    public ValueNode valueNode() {
        return this.value;
    }

    @Override
    public InductionVariable.Direction direction() {
        InductionVariable.Direction baseDirection = this.base.direction();
        if (baseDirection == null) {
            return null;
        }
        Stamp stamp = this.scale.stamp(NodeView.DEFAULT);
        if (stamp instanceof IntegerStamp) {
            IntegerStamp integerStamp = (IntegerStamp)stamp;
            if (integerStamp.isStrictlyPositive()) {
                return baseDirection;
            }
            if (integerStamp.isStrictlyNegative()) {
                return baseDirection.opposite();
            }
        }
        return null;
    }

    @Override
    public ValueNode initNode() {
        return MathUtil.mul(this.graph(), this.base.initNode(), this.scale);
    }

    @Override
    public ValueNode strideNode() {
        return MathUtil.mul(this.graph(), this.base.strideNode(), this.scale);
    }

    @Override
    public boolean isConstantInit() {
        try {
            if (this.scale.isConstant() && this.base.isConstantInit()) {
                this.constantInitSafe();
                return true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isConstantStride() {
        try {
            if (this.scale.isConstant() && this.base.isConstantStride()) {
                this.constantStrideSafe();
                return true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public long constantInit() {
        return this.constantInitSafe();
    }

    private long constantInitSafe() throws ArithmeticException {
        return this.opSafe(this.base.constantInit(), this.scale.asJavaConstant().asLong());
    }

    @Override
    public long constantStride() {
        return this.constantStrideSafe();
    }

    private long constantStrideSafe() throws ArithmeticException {
        return this.opSafe(this.base.constantStride(), this.scale.asJavaConstant().asLong());
    }

    private long opSafe(long a, long b) {
        return DerivedScaledInductionVariable.multiplyExact(IntegerStamp.getBits(this.scale.stamp(NodeView.DEFAULT)), a, b);
    }

    @Override
    public boolean isConstantExtremum() {
        try {
            if (this.scale.isConstant() && this.base.isConstantExtremum()) {
                this.constantExtremumSafe();
                return true;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public long constantExtremum() {
        return this.constantExtremumSafe();
    }

    private long constantExtremumSafe() throws ArithmeticException {
        return this.opSafe(this.base.constantExtremum(), this.scale.asJavaConstant().asLong());
    }

    @Override
    public ValueNode extremumNode(boolean assumeLoopEntered, Stamp stamp) {
        return MathUtil.mul(this.graph(), this.base.extremumNode(assumeLoopEntered, stamp), IntegerConvertNode.convert(this.scale, stamp, this.graph(), NodeView.DEFAULT));
    }

    @Override
    public ValueNode exitValueNode() {
        return MathUtil.mul(this.graph(), this.base.exitValueNode(), this.scale);
    }

    @Override
    public void deleteUnusedNodes() {
        GraphUtil.tryKillUnused(this.scale);
    }

    @Override
    public boolean isConstantScale(InductionVariable ref) {
        return super.isConstantScale(ref) || this.scale.isConstant() && this.base.isConstantScale(ref);
    }

    @Override
    public long constantScale(InductionVariable ref) {
        assert (this.isConstantScale(ref));
        if (super.isConstantScale(ref)) {
            return super.constantScale(ref);
        }
        return this.scale.asJavaConstant().asLong() * this.base.constantScale(ref);
    }

    @Override
    public boolean offsetIsZero(InductionVariable ref) {
        if (super.offsetIsZero(ref)) {
            return true;
        }
        return this.base.offsetIsZero(ref);
    }

    @Override
    public ValueNode offsetNode(InductionVariable ref) {
        assert (!this.offsetIsZero(ref));
        return null;
    }

    public String toString() {
        return String.format("DerivedScaleInductionVariable base (%s) %s %s", this.base, this.value.getNodeClass().shortName(), this.scale);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase, boolean gvn) {
        return MathUtil.mul(this.graph(), newBase.valueNode(), this.scale, gvn);
    }

    @Override
    public ValueNode copyValue(InductionVariable newBase) {
        return this.copyValue(newBase, true);
    }

    @Override
    public InductionVariable copy(InductionVariable newBase, ValueNode newValue) {
        return new DerivedScaledInductionVariable(this.loop, newBase, this.scale, newValue);
    }

    @Override
    public ValueNode entryTripValue() {
        return MathUtil.mul(this.graph(), this.base.entryTripValue(), this.scale);
    }

    private static long multiplyExact(int bits, long a, long b) {
        if (bits == 32) {
            int ia = (int)a;
            int ib = (int)b;
            assert ((long)ia == a && (long)ib == b) : String.format("Conversions must be lossless, [bits]=%d; [a]=%d; [b]=%d; [ia]=%d; [ib]=%d;", bits, a, b, ia, ib);
            return Math.multiplyExact(ia, ib);
        }
        if (bits == 64) {
            return Math.multiplyExact(a, b);
        }
        throw GraalError.shouldNotReachHere("Must be one of java's core datatypes int/long but is " + bits);
    }
}

