/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.memory;

import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.NamedLocationIdentity;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ReinterpretNode;
import org.graalvm.compiler.nodes.memory.AbstractWriteNode;
import org.graalvm.compiler.nodes.memory.LIRLowerableAccess;
import org.graalvm.compiler.nodes.memory.OnHeapMemoryAccess;
import org.graalvm.compiler.nodes.memory.address.AddressNode;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.word.LocationIdentity;

@NodeInfo(nameTemplate="Write#{p#location/s}")
public class WriteNode
extends AbstractWriteNode
implements LIRLowerableAccess,
Simplifiable {
    public static final NodeClass<WriteNode> TYPE = NodeClass.create(WriteNode.class);
    private final LocationIdentity killedLocationIdentity;

    public WriteNode(AddressNode address, LocationIdentity location, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType) {
        this(TYPE, address, location, location, value, barrierType);
    }

    protected WriteNode(NodeClass<? extends WriteNode> c, AddressNode address, LocationIdentity location, LocationIdentity killedLocationIdentity, ValueNode value, OnHeapMemoryAccess.BarrierType barrierType) {
        super(c, address, location, value, barrierType);
        this.killedLocationIdentity = killedLocationIdentity;
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        LIRKind writeKind = gen.getLIRGeneratorTool().getLIRKind(this.value().stamp(NodeView.DEFAULT));
        gen.getLIRGeneratorTool().getArithmetic().emitStore(writeKind, gen.operand(this.address), gen.operand(this.value()), gen.state(this));
    }

    @Override
    public Stamp getAccessStamp(NodeView view) {
        return this.value().stamp(view);
    }

    @Override
    public boolean canNullCheck() {
        return true;
    }

    @Override
    public boolean hasSideEffect() {
        if (this.getLocationIdentity().equals(LocationIdentity.INIT_LOCATION)) {
            return false;
        }
        return super.hasSideEffect();
    }

    @Override
    public final LocationIdentity getKilledLocationIdentity() {
        return this.killedLocationIdentity;
    }

    @Override
    public void simplify(SimplifierTool tool) {
        if (tool.canonicalizeReads() && this.hasExactlyOneUsage() && this.next() instanceof WriteNode) {
            WriteNode write = (WriteNode)this.next();
            if (write.lastLocationAccess == this && write.getAddress() == this.getAddress() && this.getAccessStamp(NodeView.DEFAULT).isCompatible(write.getAccessStamp(NodeView.DEFAULT))) {
                write.setLastLocationAccess(this.getLastLocationAccess());
                tool.addToWorkList(this.inputs());
                tool.addToWorkList(this.next());
                tool.addToWorkList(this.predecessor());
                this.graph().removeFixed(this);
            }
        }
        if (NamedLocationIdentity.isArrayLocation(this.location) && this.value() instanceof ReinterpretNode) {
            tool.addToWorkList(this.value());
            tool.addToWorkList(((ReinterpretNode)this.value()).getValue());
            tool.addToWorkList(this);
            this.setValue(((ReinterpretNode)this.value()).getValue());
        }
    }
}

